/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileSystems;
import sbt.BasicCommandStrings$;
import sbt.State;
import sbt.State$;
import sbt.Watched;
import sbt.internal.io.Source;
import sbt.internal.io.SourceModificationWatch$;
import sbt.internal.io.WatchState;
import sbt.internal.io.WatchState$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.internal.util.Types$;
import sbt.io.PollingWatchService;
import sbt.io.WatchService;
import sbt.io.WatchService$;
import sbt.util.Logger;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class Watched$ {
    public static Watched$ MODULE$;
    private final Function1<WatchState, String> defaultWatchingMessage;
    private final Function1<WatchState, String> defaultTriggeredMessage;
    private final Function1<WatchState, String> clearWhenTriggered;
    private final FiniteDuration PollDelay;
    private final AttributeKey<WatchState> ContinuousState;
    private final AttributeKey<WatchService> ContinuousWatchService;
    private final AttributeKey<Watched> Configuration;

    static {
        new Watched$();
    }

    public Function1<WatchState, String> defaultWatchingMessage() {
        return this.defaultWatchingMessage;
    }

    public Function1<WatchState, String> defaultTriggeredMessage() {
        return this.defaultTriggeredMessage;
    }

    public Function1<WatchState, String> clearWhenTriggered() {
        return this.clearWhenTriggered;
    }

    public String clearScreen() {
        return "\u001b[2J\u001b[0;0H";
    }

    public Watched multi(Watched base, Seq<Watched> paths) {
        return new Watched.AWatched(base, paths){
            private final FiniteDuration pollInterval;
            private final Watched base$1;
            private final Seq paths$1;

            public Seq<Source> watchSources(State s) {
                Seq<Source> seq = this.base$1.watchSources(s);
                return (Seq)this.paths$1.$div$colon(seq, (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (Seq)x$3.$plus$plus(x$4.watchSources(s), Seq$.MODULE$.canBuildFrom()));
            }

            public boolean terminateWatch(int key) {
                return this.base$1.terminateWatch(key);
            }

            public FiniteDuration pollInterval() {
                return this.pollInterval;
            }

            public String watchingMessage(WatchState s) {
                return this.base$1.watchingMessage(s);
            }

            public String triggeredMessage(WatchState s) {
                return this.base$1.triggeredMessage(s);
            }
            {
                this.base$1 = base$1;
                this.paths$1 = paths$1;
                Watched watched = base$1;
                this.pollInterval = (FiniteDuration)((TraversableOnce)((TraversableLike)paths$1.$plus$colon((Object)watched, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.pollInterval(), Seq$.MODULE$.canBuildFrom())).min((Ordering)FiniteDuration.FiniteDurationIsOrdered$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$watchSources$1(sbt.State scala.collection.Seq sbt.Watched ), $anonfun$pollInterval$1(sbt.Watched )}, serializedLambda);
            }
        };
    }

    public Watched empty() {
        return new Watched.AWatched();
    }

    public FiniteDuration PollDelay() {
        return this.PollDelay;
    }

    public boolean isEnter(int key) {
        return key == 10 || key == 13;
    }

    public void printIfDefined(String msg) {
        block0: {
            if (msg.isEmpty()) break block0;
            System.out.println(msg);
        }
    }

    public State executeContinuously(Watched watched, State s, String next, String repeat) {
        State state;
        Tuple2 tuple2;
        Seq<Source> sources = watched.watchSources(s);
        WatchService service = (WatchService)State$.MODULE$.stateOps(s).get(this.ContinuousWatchService()).getOrElse((Function0 & Serializable & scala.Serializable)() -> watched.watchService());
        WatchState watchState = (WatchState)State$.MODULE$.stateOps(s).get(this.ContinuousState()).getOrElse((Function0 & Serializable & scala.Serializable)() -> WatchState$.MODULE$.empty(service, sources));
        if (watchState.count() > 0) {
            this.printIfDefined(watched.watchingMessage(watchState));
        }
        if ((tuple2 = this.liftedTree1$1(watched, s, watchState)) == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean triggered = tuple2._1$mcZ$sp();
        WatchState newWatchState = (WatchState)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)triggered), (Object)newWatchState);
        Tuple2 tuple23 = tuple22;
        boolean triggered2 = tuple23._1$mcZ$sp();
        WatchState newWatchState2 = (WatchState)tuple23._2();
        if (triggered2) {
            this.printIfDefined(watched.triggeredMessage(newWatchState2));
            String string = BasicCommandStrings$.MODULE$.ClearOnFailure();
            String string2 = next;
            String string3 = State$.MODULE$.FailureWall();
            String string4 = repeat;
            state = State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(State$.MODULE$.stateOps(s).$colon$colon(string4)).$colon$colon(string3)).$colon$colon(string2)).$colon$colon(string)).put(this.ContinuousState(), newWatchState2)).put(this.ContinuousWatchService(), service);
        } else {
            while (System.in.available() > 0) {
                System.in.read();
            }
            service.close();
            state = State$.MODULE$.stateOps(State$.MODULE$.stateOps(s).remove(this.ContinuousState())).remove(this.ContinuousWatchService());
        }
        return state;
    }

    public AttributeKey<WatchState> ContinuousState() {
        return this.ContinuousState;
    }

    public AttributeKey<WatchService> ContinuousWatchService() {
        return this.ContinuousWatchService;
    }

    public AttributeKey<Watched> Configuration() {
        return this.Configuration;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public WatchService createWatchService() {
        String string;
        void var1_9;
        boolean bl = false;
        Some some = null;
        Option option = scala.sys.package$.MODULE$.props().get("sbt.watch.mode");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string2 = (String)some.value();
            if ("polling".equals(string2)) {
                PollingWatchService pollingWatchService = new PollingWatchService(this.PollDelay());
                return var1_9;
            }
        }
        if (bl && "nio".equals(string = (String)some.value())) {
            WatchService.WatchServiceAdapter watchServiceAdapter = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
            return var1_9;
        }
        if (Properties$.MODULE$.isMac()) {
            PollingWatchService pollingWatchService = new PollingWatchService(this.PollDelay());
            return var1_9;
        }
        WatchService.WatchServiceAdapter watchServiceAdapter = WatchService$.MODULE$.WatchServiceAdapter(FileSystems.getDefault().newWatchService());
        return var1_9;
    }

    private final boolean shouldTerminate$1(Watched watched$1) {
        boolean bl;
        block1: {
            while (System.in.available() > 0) {
                if (!watched$1.terminateWatch(System.in.read())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Tuple2 liftedTree1$1(Watched watched$1, State s$1, WatchState watchState$1) {
        Tuple2 tuple2;
        try {
            Tuple2 tuple22 = SourceModificationWatch$.MODULE$.watch(watched$1.pollInterval(), watchState$1, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.shouldTerminate$1(watched$1));
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            boolean triggered = tuple22._1$mcZ$sp();
            WatchState newWatchState = (WatchState)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)triggered), (Object)newWatchState);
            Tuple2 tuple24 = tuple23;
            boolean triggered2 = tuple24._1$mcZ$sp();
            WatchState newWatchState2 = (WatchState)tuple24._2();
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)triggered2), (Object)newWatchState2);
        }
        catch (Exception e) {
            Logger log = State$.MODULE$.stateOps(s$1).log();
            log.error((Function0 & Serializable & scala.Serializable)() -> "Error occurred obtaining files to watch.  Terminating continuous execution...");
            State$.MODULE$.handleException(e, s$1, log);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)watchState$1);
        }
        return tuple2;
    }

    private Watched$() {
        MODULE$ = this;
        this.defaultWatchingMessage = (Function1 & Serializable & scala.Serializable)x$1 -> x$1.count() + ". Waiting for source changes... (press enter to interrupt)";
        this.defaultTriggeredMessage = Types$.MODULE$.const((Object)"");
        this.clearWhenTriggered = Types$.MODULE$.const((Object)this.clearScreen());
        this.PollDelay = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.ContinuousState = AttributeKey$.MODULE$.apply("watch state", "Internal: tracks state for continuous execution.", ManifestFactory$.MODULE$.classType(WatchState.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.ContinuousWatchService = AttributeKey$.MODULE$.apply("watch service", "Internal: tracks watch service for continuous execution.", ManifestFactory$.MODULE$.classType(WatchService.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.Configuration = AttributeKey$.MODULE$.apply("watched-configuration", "Configures continuous execution.", ManifestFactory$.MODULE$.classType(Watched.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
    }
}

