/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;
import scala.xml.include.CircularIncludeException;
import scala.xml.include.UnavailableResourceException;
import scala.xml.include.sax.EncodingHeuristics$;
import scala.xml.package$;

public class XIncludeFilter
extends XMLFilterImpl {
    private final Stack<URL> bases = new Stack();
    private final Stack<Locator> locators = new Stack();
    private int level = 0;
    private int depth = 0;
    private boolean atRoot = false;

    public final String XINCLUDE_NAMESPACE() {
        return "http://www.w3.org/2001/XInclude";
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locators.push(locator);
        String base = locator.getSystemId();
        try {
            this.bases.push(new URL(base));
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnsupportedOperationException(new StringBuilder(24).append("Unrecognized SYSTEM ID: ").append(base).toString());
        }
        super.setDocumentLocator(locator);
    }

    public boolean insideIncludeElement() {
        return this.level != 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts1) {
        Attributes atts = atts1;
        if (this.level == 0) {
            URL parentBase;
            String base = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
            URL currentBase = parentBase = this.bases.peek();
            if (base != null) {
                try {
                    currentBase = new URL(parentBase, base);
                }
                catch (MalformedURLException e) {
                    throw new SAXException(new StringBuilder(20).append("Malformed base URL: ").append(currentBase).toString(), e);
                }
            }
            this.bases.push(currentBase);
            String string = uri;
            String string2 = this.XINCLUDE_NAMESPACE();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = localName;
                String string4 = "include";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String href = atts.getValue("href");
                    if (href == null) {
                        throw new SAXException("Missing href attribute");
                    }
                    String parse = atts.getValue("parse");
                    if (parse == null) {
                        parse = "xml";
                    }
                    String string5 = parse;
                    String string6 = "text";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        this.includeTextDocument(href, atts.getValue("encoding"));
                    } else {
                        String string7 = parse;
                        String string8 = "xml";
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            this.includeXMLDocument(href);
                        } else {
                            throw new SAXException(new StringBuilder(35).append("Illegal value for parse attribute: ").append(parse).toString());
                        }
                    }
                    ++this.level;
                    return;
                }
            }
            if (this.atRoot) {
                AttributesImpl attsImpl = new AttributesImpl(atts);
                attsImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "base", "xml:base", "CDATA", currentBase.toExternalForm());
                atts = attsImpl;
                this.atRoot = false;
            }
            super.startElement(uri, localName, qName, atts);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String string = uri;
        String string2 = this.XINCLUDE_NAMESPACE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = localName;
            String string4 = "include";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                --this.level;
                return;
            }
        }
        if (this.level == 0) {
            this.bases.pop();
            super.endElement(uri, localName, qName);
            return;
        }
    }

    @Override
    public void startDocument() {
        this.level = 0;
        if (this.depth == 0) {
            super.startDocument();
        }
        ++this.depth;
    }

    @Override
    public void endDocument() {
        this.locators.pop();
        this.bases.pop();
        --this.depth;
        if (this.depth == 0) {
            super.endDocument();
            return;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.level == 0) {
            super.startPrefixMapping(prefix, uri);
            return;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.level == 0) {
            super.endPrefixMapping(prefix);
            return;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.characters(ch, start, length);
            return;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.ignorableWhitespace(ch, start, length);
            return;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.level == 0) {
            super.processingInstruction(target, data);
            return;
        }
    }

    @Override
    public void skippedEntity(String name) {
        if (this.level == 0) {
            super.skippedEntity(name);
            return;
        }
    }

    private String getLocation() {
        String locationString = "";
        Locator locator = this.locators.peek();
        String publicID = "";
        String systemID = "";
        int column = -1;
        int line = -1;
        if (locator != null) {
            publicID = locator.getPublicId();
            systemID = locator.getSystemId();
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
        }
        locationString = new StringBuilder(49).append(" in document included from ").append(publicID).append(" at ").append(systemID).append(" at line ").append(line).append(", column ").append(column).toString();
        return locationString;
    }

    private void includeTextDocument(String url, String encoding1) {
        String encoding = encoding1;
        if (encoding == null || encoding.trim().isEmpty()) {
            encoding = "UTF-8";
        }
        URL source = null;
        try {
            URL base = this.bases.peek();
            source = new URL(base, url);
        }
        catch (MalformedURLException e) {
            UnavailableResourceException ex = new UnavailableResourceException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString());
            ex.setRootCause(e);
            throw new SAXException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString(), ex);
        }
        try {
            BufferedInputStream in;
            block11: {
                block12: {
                    String contentType;
                    block10: {
                        URLConnection uc = source.openConnection();
                        in = new BufferedInputStream(uc.getInputStream());
                        String encodingFromHeader = uc.getContentEncoding();
                        contentType = uc.getContentType();
                        if (encodingFromHeader == null) break block10;
                        encoding = encodingFromHeader;
                        break block11;
                    }
                    if (contentType == null) break block11;
                    String string = contentType = contentType.toLowerCase();
                    String string2 = "text/xml";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block12;
                    String string3 = contentType;
                    String string4 = "application/xml";
                    if ((string3 == null ? string4 != null : !string3.equals(string4)) && (!contentType.startsWith("text/") || !contentType.endsWith("+xml")) && (!contentType.startsWith("application/") || !contentType.endsWith("+xml"))) break block11;
                }
                encoding = EncodingHeuristics$.MODULE$.readEncodingFromStream(in);
            }
            InputStreamReader reader = new InputStreamReader((InputStream)in, encoding);
            char[] c = new char[1024];
            int charsRead = 0;
            do {
                if ((charsRead = reader.read(c, 0, 1024)) <= 0) continue;
                this.characters(c, 0, charsRead);
            } while (charsRead != -1);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(new StringBuilder(22).append("Unsupported encoding: ").append(encoding).append(this.getLocation()).toString(), e);
        }
        catch (IOException e) {
            throw new SAXException(new StringBuilder(20).append("Document not found: ").append(source.toExternalForm()).append(this.getLocation()).toString(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void includeXMLDocument(String url) {
        try {
            v0 = new URL(this.bases.peek(), url);
        }
        catch (MalformedURLException e) {
            ex = new UnavailableResourceException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString());
            ex.setRootCause(e);
            throw new SAXException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString(), ex);
        }
        source = v0;
        try {
            v1 = XMLReaderFactory.createXMLReader();
            ** GOTO lbl-1000
        }
        catch (SAXException v2) {
            try {
                v1 = XMLReaderFactory.createXMLReader(package$.MODULE$.XercesClassName());
            }
            catch (SAXException v3) {
                System.err.println("Could not find an XML parser");
                return;
            }
            try lbl-1000:
            // 2 sources

            {
                parser = v1;
                parser.setContentHandler(this);
                resolver = this.getEntityResolver();
                if (resolver != null) {
                    parser.setEntityResolver(resolver);
                }
                previousLevel = this.level;
                this.level = 0;
                if (this.bases.contains(source)) {
                    throw new SAXException("Circular XInclude Reference", new CircularIncludeException(new StringBuilder(31).append("Circular XInclude Reference to ").append(source).append(this.getLocation()).toString()));
                }
                this.bases.push(source);
                this.atRoot = true;
                parser.parse(source.toExternalForm());
                this.level = previousLevel;
                this.bases.pop();
            }
            catch (IOException e) {
                throw new SAXException(new StringBuilder(20).append("Document not found: ").append(source.toExternalForm()).append(this.getLocation()).toString(), e);
            }
        }
    }
}

