/*
 * Decompiled with CFR 0.152.
 */
package scala.compat.java8;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import scala.Tuple2;
import scala.collection.BitSet;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.compat.java8.collectionImpl.Accumulator;
import scala.compat.java8.collectionImpl.DoubleAccumulator;
import scala.compat.java8.collectionImpl.IntAccumulator;
import scala.compat.java8.collectionImpl.LongAccumulator;
import scala.compat.java8.converterImpl.RichBitSetCanStep;
import scala.compat.java8.converterImpl.StepperShape$;
import scala.compat.java8.converterImpl.StepsAnyDefaultHashTable;
import scala.compat.java8.converterImpl.StepsAnyDefaultHashTableValue;
import scala.compat.java8.converterImpl.StepsAnyFlatHashTable;
import scala.compat.java8.converterImpl.StepsAnyHashTableKey;
import scala.compat.java8.converterImpl.StepsAnyImmHashSet;
import scala.compat.java8.converterImpl.StepsAnyIndexedSeq;
import scala.compat.java8.converterImpl.StepsAnyIterator;
import scala.compat.java8.converterImpl.StepsAnyVector;
import scala.compat.java8.converterImpl.StepsDoubleDefaultHashTableValue;
import scala.compat.java8.converterImpl.StepsDoubleFlatHashTable;
import scala.compat.java8.converterImpl.StepsDoubleHashTableKey;
import scala.compat.java8.converterImpl.StepsDoubleImmHashSet;
import scala.compat.java8.converterImpl.StepsDoubleIndexedSeq;
import scala.compat.java8.converterImpl.StepsDoubleIterator;
import scala.compat.java8.converterImpl.StepsDoubleVector;
import scala.compat.java8.converterImpl.StepsIntDefaultHashTableValue;
import scala.compat.java8.converterImpl.StepsIntFlatHashTable;
import scala.compat.java8.converterImpl.StepsIntHashTableKey;
import scala.compat.java8.converterImpl.StepsIntImmHashSet;
import scala.compat.java8.converterImpl.StepsIntIndexedSeq;
import scala.compat.java8.converterImpl.StepsIntIterator;
import scala.compat.java8.converterImpl.StepsIntRange;
import scala.compat.java8.converterImpl.StepsIntVector;
import scala.compat.java8.converterImpl.StepsLongDefaultHashTableValue;
import scala.compat.java8.converterImpl.StepsLongFlatHashTable;
import scala.compat.java8.converterImpl.StepsLongHashTableKey;
import scala.compat.java8.converterImpl.StepsLongImmHashSet;
import scala.compat.java8.converterImpl.StepsLongIndexedSeq;
import scala.compat.java8.converterImpl.StepsLongIterator;
import scala.compat.java8.converterImpl.StepsLongVector;
import scala.compat.java8.runtime.CollectionInternals;

public class ScalaStreamSupport {
    public static <T> Stream<T> stream(IndexedSeq<T> indexedSeq) {
        return StreamSupport.stream(new StepsAnyIndexedSeq(indexedSeq, 0, indexedSeq.length()), false);
    }

    public static <T> Stream<T> stream(scala.collection.immutable.HashSet<T> hashSet) {
        return StreamSupport.stream(new StepsAnyImmHashSet(hashSet.iterator(), hashSet.size()), false);
    }

    public static <K> Stream<K> streamKeys(HashMap<K, ?> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.stream(new StepsAnyHashTableKey(objectArray, 0, objectArray.length), false);
    }

    public static <V> Stream<V> streamValues(HashMap<? super Object, V> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.stream(new StepsAnyDefaultHashTableValue(objectArray, 0, objectArray.length), false);
    }

    public static <K, V> Stream<Tuple2<K, V>> stream(HashMap<K, V> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.stream(new StepsAnyDefaultHashTable(objectArray, 0, objectArray.length), false);
    }

    public static <T> Stream<T> stream(HashSet<T> hashSet) {
        Object[] objectArray = CollectionInternals.getTable(hashSet);
        return StreamSupport.stream(new StepsAnyFlatHashTable(objectArray, 0, objectArray.length), false);
    }

    public static <T> Stream<T> stream(Vector<T> vector) {
        return StreamSupport.stream(new StepsAnyVector<T>(vector, 0, vector.length()), false);
    }

    public static <K> Stream<K> streamKeys(Map<K, ?> map) {
        return StreamSupport.stream(new StepsAnyIterator(map.keysIterator()), false);
    }

    public static <V> Stream<V> streamValues(Map<?, V> map) {
        return StreamSupport.stream(new StepsAnyIterator(map.valuesIterator()), false);
    }

    public static <K, V> Stream<Tuple2<K, V>> stream(Map<K, V> map) {
        return StreamSupport.stream(new StepsAnyIterator(map.iterator()), false);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(new StepsAnyIterator<T>(iterator), false);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(new StepsAnyIterator(iterable.iterator()), false);
    }

    public static <T> Stream<T> streamAccumulated(IterableOnce<T> iterableOnce) {
        Accumulator<T> accumulator = Accumulator.from(iterableOnce);
        return StreamSupport.stream(accumulator.spliterator(), false);
    }

    public static <K> Stream<K> streamAccumulatedKeys(Map<K, ?> map) {
        Accumulator accumulator = Accumulator.from(map.keysIterator());
        return StreamSupport.stream(accumulator.spliterator(), false);
    }

    public static <V> Stream<V> streamAccumulatedValues(Map<?, V> map) {
        Accumulator accumulator = Accumulator.from(map.valuesIterator());
        return StreamSupport.stream(accumulator.spliterator(), false);
    }

    public static DoubleStream doubleStream(IndexedSeq<Double> indexedSeq) {
        return StreamSupport.doubleStream(new StepsDoubleIndexedSeq<IndexedSeq<Double>>(indexedSeq, 0, indexedSeq.length()), false);
    }

    public static DoubleStream doubleStream(scala.collection.immutable.HashSet<Double> hashSet) {
        Iterator iterator = hashSet.iterator();
        return StreamSupport.doubleStream(new StepsDoubleImmHashSet((Iterator<Object>)iterator, hashSet.size()), false);
    }

    public static DoubleStream doubleStreamKeys(HashMap<Double, ?> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.doubleStream(new StepsDoubleHashTableKey(objectArray, 0, objectArray.length), false);
    }

    public static DoubleStream doubleStreamValues(HashMap<? super Object, Double> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.doubleStream(new StepsDoubleDefaultHashTableValue(objectArray, 0, objectArray.length), false);
    }

    public static DoubleStream doubleStream(HashSet<Double> hashSet) {
        Object[] objectArray = CollectionInternals.getTable(hashSet);
        return StreamSupport.doubleStream(new StepsDoubleFlatHashTable(objectArray, 0, objectArray.length), false);
    }

    public static DoubleStream doubleStream(Vector<Double> vector) {
        Vector<Double> vector2 = vector;
        return StreamSupport.doubleStream(new StepsDoubleVector(vector2, 0, vector.length()), false);
    }

    public static DoubleStream doubleStreamKeys(Map<Double, ?> map) {
        Iterator iterator = map.keysIterator();
        return StreamSupport.doubleStream(new StepsDoubleIterator((Iterator<Object>)iterator), false);
    }

    public static DoubleStream doubleStreamValues(Map<?, Double> map) {
        Iterator iterator = map.valuesIterator();
        return StreamSupport.doubleStream(new StepsDoubleIterator((Iterator<Object>)iterator), false);
    }

    public static DoubleStream doubleStream(Iterator<Double> iterator) {
        return StreamSupport.doubleStream(new StepsDoubleIterator((Iterator<Object>)iterator), false);
    }

    public static DoubleStream doubleStream(Iterable<Double> iterable) {
        Iterator iterator = iterable.iterator();
        return StreamSupport.doubleStream(new StepsDoubleIterator((Iterator<Object>)iterator), false);
    }

    public static DoubleStream doubleStreamAccumulated(IterableOnce<Double> iterableOnce) {
        DoubleAccumulator doubleAccumulator = DoubleAccumulator.from(iterableOnce);
        return StreamSupport.doubleStream(doubleAccumulator.spliterator(), false);
    }

    public static DoubleStream doubleStreamAccumulatedKeys(Map<Double, ?> map) {
        DoubleAccumulator doubleAccumulator = DoubleAccumulator.from((IterableOnce<Object>)map.keysIterator());
        return StreamSupport.doubleStream(doubleAccumulator.spliterator(), false);
    }

    public static DoubleStream doubleStreamAccumulatedValues(Map<?, Double> map) {
        DoubleAccumulator doubleAccumulator = DoubleAccumulator.from((IterableOnce<Object>)map.valuesIterator());
        return StreamSupport.doubleStream(doubleAccumulator.spliterator(), false);
    }

    public static IntStream intStream(BitSet bitSet) {
        RichBitSetCanStep richBitSetCanStep = new RichBitSetCanStep(bitSet);
        return StreamSupport.intStream(richBitSetCanStep.stepper(StepperShape$.MODULE$.intStepperShape()), false);
    }

    public static IntStream intStream(Range range) {
        return StreamSupport.intStream(new StepsIntRange(range, 0, range.length()), false);
    }

    public static IntStream intStream(IndexedSeq<Integer> indexedSeq) {
        return StreamSupport.intStream(new StepsIntIndexedSeq<IndexedSeq<Integer>>(indexedSeq, 0, indexedSeq.length()), false);
    }

    public static IntStream intStream(scala.collection.immutable.HashSet<Integer> hashSet) {
        Iterator iterator = hashSet.iterator();
        return StreamSupport.intStream(new StepsIntImmHashSet((Iterator<Object>)iterator, hashSet.size()), false);
    }

    public static IntStream intStreamKeys(HashMap<Integer, ?> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.intStream(new StepsIntHashTableKey(objectArray, 0, objectArray.length), false);
    }

    public static IntStream intStreamValues(HashMap<? super Object, Integer> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.intStream(new StepsIntDefaultHashTableValue(objectArray, 0, objectArray.length), false);
    }

    public static IntStream intStream(HashSet<Integer> hashSet) {
        Object[] objectArray = CollectionInternals.getTable(hashSet);
        return StreamSupport.intStream(new StepsIntFlatHashTable(objectArray, 0, objectArray.length), false);
    }

    public static IntStream intStream(Vector<Integer> vector) {
        Vector<Integer> vector2 = vector;
        return StreamSupport.intStream(new StepsIntVector(vector2, 0, vector.length()), false);
    }

    public static IntStream intStreamKeys(Map<Integer, ?> map) {
        Iterator iterator = map.keysIterator();
        return StreamSupport.intStream(new StepsIntIterator((Iterator<Object>)iterator), false);
    }

    public static IntStream intStreamValues(Map<?, Integer> map) {
        Iterator iterator = map.valuesIterator();
        return StreamSupport.intStream(new StepsIntIterator((Iterator<Object>)iterator), false);
    }

    public static IntStream intStream(Iterator<Integer> iterator) {
        return StreamSupport.intStream(new StepsIntIterator((Iterator<Object>)iterator), false);
    }

    public static IntStream intStream(Iterable<Integer> iterable) {
        Iterator iterator = iterable.iterator();
        return StreamSupport.intStream(new StepsIntIterator((Iterator<Object>)iterator), false);
    }

    public static IntStream intStreamAccumulated(IterableOnce<Integer> iterableOnce) {
        IntAccumulator intAccumulator = IntAccumulator.from(iterableOnce);
        return StreamSupport.intStream(intAccumulator.spliterator(), false);
    }

    public static IntStream intStreamAccumulatedKeys(Map<Integer, ?> map) {
        IntAccumulator intAccumulator = IntAccumulator.from((IterableOnce<Object>)map.keysIterator());
        return StreamSupport.intStream(intAccumulator.spliterator(), false);
    }

    public static IntStream intStreamAccumulatedValues(Map<?, Integer> map) {
        IntAccumulator intAccumulator = IntAccumulator.from((IterableOnce<Object>)map.valuesIterator());
        return StreamSupport.intStream(intAccumulator.spliterator(), false);
    }

    public static LongStream longStream(IndexedSeq<Long> indexedSeq) {
        return StreamSupport.longStream(new StepsLongIndexedSeq<IndexedSeq<Long>>(indexedSeq, 0, indexedSeq.length()), false);
    }

    public static LongStream longStream(scala.collection.immutable.HashSet<Long> hashSet) {
        Iterator iterator = hashSet.iterator();
        return StreamSupport.longStream(new StepsLongImmHashSet((Iterator<Object>)iterator, hashSet.size()), false);
    }

    public static LongStream longStreamKeys(HashMap<Long, ?> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.longStream(new StepsLongHashTableKey(objectArray, 0, objectArray.length), false);
    }

    public static LongStream longStreamValues(HashMap<? super Object, Long> hashMap) {
        Object[] objectArray = CollectionInternals.getTable(hashMap);
        return StreamSupport.longStream(new StepsLongDefaultHashTableValue(objectArray, 0, objectArray.length), false);
    }

    public static LongStream longStream(HashSet<Long> hashSet) {
        Object[] objectArray = CollectionInternals.getTable(hashSet);
        return StreamSupport.longStream(new StepsLongFlatHashTable(objectArray, 0, objectArray.length), false);
    }

    public static LongStream longStream(Vector<Long> vector) {
        Vector<Long> vector2 = vector;
        return StreamSupport.longStream(new StepsLongVector(vector2, 0, vector.length()), false);
    }

    public static LongStream longStreamKeys(Map<Long, ?> map) {
        Iterator iterator = map.keysIterator();
        return StreamSupport.longStream(new StepsLongIterator((Iterator<Object>)iterator), false);
    }

    public static LongStream longStreamValues(Map<?, Long> map) {
        Iterator iterator = map.valuesIterator();
        return StreamSupport.longStream(new StepsLongIterator((Iterator<Object>)iterator), false);
    }

    public static LongStream longStream(Iterator<Long> iterator) {
        return StreamSupport.longStream(new StepsLongIterator((Iterator<Object>)iterator), false);
    }

    public static LongStream longStream(Iterable<Long> iterable) {
        Iterator iterator = iterable.iterator();
        return StreamSupport.longStream(new StepsLongIterator((Iterator<Object>)iterator), false);
    }

    public static LongStream longStreamAccumulated(IterableOnce<Long> iterableOnce) {
        LongAccumulator longAccumulator = LongAccumulator.from(iterableOnce);
        return StreamSupport.longStream(longAccumulator.spliterator(), false);
    }

    public static LongStream longStreamAccumulatedKeys(Map<Long, ?> map) {
        LongAccumulator longAccumulator = LongAccumulator.from((IterableOnce<Object>)map.keysIterator());
        return StreamSupport.longStream(longAccumulator.spliterator(), false);
    }

    public static LongStream longStreamAccumulatedValues(Map<?, Long> map) {
        LongAccumulator longAccumulator = LongAccumulator.from((IterableOnce<Object>)map.valuesIterator());
        return StreamSupport.longStream(longAccumulator.spliterator(), false);
    }
}

