/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.ElementType;
import org.sakaiproject.metaobj.utils.xml.NormalizationException;
import org.sakaiproject.metaobj.utils.xml.SchemaFactory;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.ValidatedNode;
import org.sakaiproject.metaobj.utils.xml.impl.AttributeSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.ComplexSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.CustomTypeSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.RefAttributeSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.RefSchemaNodeImpl;
import org.sakaiproject.metaobj.utils.xml.impl.SimpleSchemaNodeImpl;

public class SchemaNodeImpl
implements SchemaNode {
    protected Namespace xsdNamespace = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
    private SchemaFactory factory = null;
    private Object path = null;
    private Element schemaElement;
    private GlobalMaps globalMaps;
    private Map globalElements;
    private Map globalCustomTypes;
    private Map documentAnnotations;
    private Map appAnnotations;
    private boolean documentNode = false;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private String elementName = "document";
    private Namespace targetNamespace;

    public SchemaNodeImpl(Element schemaElement, GlobalMaps globalMaps) throws SchemaInvalidException {
        this.globalElements = globalMaps.globalElements;
        this.globalCustomTypes = globalMaps.globalCustomTypes;
        this.globalMaps = globalMaps;
        this.schemaElement = schemaElement;
        this.elementName = schemaElement.getAttributeValue("name");
        try {
            new Element(this.elementName);
        }
        catch (Exception e) {
            throw new SchemaInvalidException("illegal element name", e);
        }
        this.setupNamespaces(schemaElement);
        this.initSchemaElement();
    }

    public SchemaNodeImpl(Document shemaDoc, SchemaFactory factory, Object path) throws SchemaInvalidException {
        Element rootElement;
        this.factory = factory;
        this.path = path;
        this.globalMaps = new GlobalMaps();
        this.globalElements = new Hashtable();
        this.globalMaps.globalElements = this.globalElements;
        this.globalCustomTypes = new Hashtable();
        this.globalMaps.globalCustomTypes = this.globalCustomTypes;
        this.documentNode = true;
        this.schemaElement = rootElement = shemaDoc.getRootElement();
        this.setupNamespaces(this.schemaElement);
        this.processAnnotations(rootElement.getChild("annotation", this.xsdNamespace));
        this.processIncludes(rootElement.getChildren("include", this.xsdNamespace));
        List rootSchemaElements = rootElement.getChildren("element", this.xsdNamespace);
        for (Element schemaElement : rootSchemaElements) {
            this.globalElements.put(schemaElement.getAttributeValue("name"), this.createNode(schemaElement));
        }
        rootSchemaElements = rootElement.getChildren("attribute", this.xsdNamespace);
        for (Element schemaElement : rootSchemaElements) {
            this.globalElements.put(schemaElement.getAttributeValue("name"), this.createNode(schemaElement, true));
        }
        rootSchemaElements = rootElement.getChildren("attributeGroup", this.xsdNamespace);
        for (Element schemaElement : rootSchemaElements) {
            this.processAttributeGroup(schemaElement);
        }
        List rootTypes = rootElement.getChildren("complexType", this.xsdNamespace);
        for (Element schemaElement : rootTypes) {
            this.globalCustomTypes.put(schemaElement.getAttributeValue("name"), this.createTypeNode(schemaElement));
        }
        rootTypes = rootElement.getChildren("simpleType", this.xsdNamespace);
        for (Element schemaElement : rootTypes) {
            this.globalCustomTypes.put(schemaElement.getAttributeValue("name"), this.createTypeNode(schemaElement));
        }
    }

    protected void setupNamespaces(Element schemaElement) {
        Element rootElement = null;
        rootElement = schemaElement.getDocument() == null ? schemaElement : schemaElement.getDocument().getRootElement();
        this.xsdNamespace = rootElement.getNamespace();
        this.targetNamespace = rootElement.getAttribute("targetNamespace") != null ? Namespace.getNamespace((String)rootElement.getAttributeValue("targetNamespace")) : Namespace.NO_NAMESPACE;
    }

    protected void processAttributeGroup(Element groupElement) {
        List attributes = groupElement.getChildren("attribute", this.xsdNamespace);
        SchemaNode[] attributeGroup = new SchemaNode[attributes.size()];
        for (int i = 0; i < attributeGroup.length; ++i) {
            attributeGroup[i] = this.createNode((Element)attributes.get(i), true);
        }
        this.getGlobalMaps().globalAttributeGroups.put(groupElement.getAttributeValue("name"), attributeGroup);
    }

    protected void processIncludes(List includes) {
        for (Element include : includes) {
            SchemaNodeImpl includedSchema = (SchemaNodeImpl)this.factory.getRelativeSchema(include.getAttributeValue("schemaLocation"), this.path);
            GlobalMaps maps = includedSchema.getGlobalMaps();
            this.getGlobalMaps().globalCustomTypes.putAll(maps.globalCustomTypes);
            this.getGlobalMaps().globalElements.putAll(maps.globalElements);
            this.getGlobalMaps().globalAttributeGroups.putAll(maps.globalAttributeGroups);
        }
    }

    protected SchemaNode createTypeNode(Element schemaElement) {
        Element fakeRoot = new Element("element", this.xsdNamespace);
        fakeRoot.setAttribute("name", schemaElement.getAttributeValue("name"));
        if (this.getTargetNamespace() != Namespace.NO_NAMESPACE) {
            fakeRoot.setAttribute("targetNamespace", this.getTargetNamespace().getURI());
        }
        fakeRoot.addContent((Content)((Element)schemaElement.clone()));
        if (schemaElement.getName().equals("complexType")) {
            return new ComplexSchemaNodeImpl(fakeRoot, this.globalMaps);
        }
        return new SimpleSchemaNodeImpl(fakeRoot, this.globalMaps, false);
    }

    protected void processAnnotations(Element child) {
        this.documentAnnotations = new Hashtable();
        this.appAnnotations = new Hashtable();
        if (child == null) {
            return;
        }
        this.processAnnotationList(this.appAnnotations, child.getChildren("appinfo", this.xsdNamespace));
        this.processAnnotationList(this.documentAnnotations, child.getChildren("documentation", this.xsdNamespace));
    }

    protected void processAnnotationList(Map annotationMap, List children) {
        for (Element elem : children) {
            if (elem.getAttribute("source") == null) continue;
            annotationMap.put(elem.getAttributeValue("source"), elem.getText());
        }
    }

    protected void initSchemaElement() {
        this.processAnnotations(this.schemaElement.getChild("annotation", this.xsdNamespace));
        if (this.schemaElement.getAttribute("maxOccurs") != null) {
            String maxOccursValue = this.schemaElement.getAttributeValue("maxOccurs");
            this.maxOccurs = maxOccursValue.equals("unbounded") ? -1 : Integer.parseInt(maxOccursValue);
        }
        if (this.schemaElement.getAttribute("minOccurs") != null) {
            String minOccursValue = this.schemaElement.getAttributeValue("minOccurs");
            this.minOccurs = Integer.parseInt(minOccursValue);
        }
    }

    protected SchemaNode createNode(Element schemaElement) {
        return this.createNode(schemaElement, false);
    }

    protected SchemaNode createNode(Element schemaElement, boolean isAttribute) {
        if (schemaElement.getAttribute("ref") != null) {
            if (isAttribute) {
                return new RefAttributeSchemaNodeImpl(schemaElement.getAttributeValue("ref"), schemaElement, this.globalMaps);
            }
            return new RefSchemaNodeImpl(schemaElement.getAttributeValue("ref"), schemaElement, this.globalMaps);
        }
        if (schemaElement.getAttribute("type") != null && !schemaElement.getAttributeValue("type").startsWith(this.xsdNamespace.getPrefix())) {
            return new CustomTypeSchemaNodeImpl(schemaElement, this.globalMaps, schemaElement.getAttributeValue("type"), isAttribute);
        }
        if (schemaElement.getChild("complexType", this.xsdNamespace) != null) {
            return new ComplexSchemaNodeImpl(schemaElement, this.globalMaps);
        }
        if (isAttribute) {
            return new AttributeSchemaNodeImpl(schemaElement, this.globalMaps, isAttribute);
        }
        return new SimpleSchemaNodeImpl(schemaElement, this.globalMaps, isAttribute);
    }

    public Namespace getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Namespace targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public ValidatedNode validateAndNormalize(Element node) {
        if (this.documentNode) {
            SchemaNode schemaNode = (SchemaNode)this.globalElements.get(node.getName());
            return schemaNode.validateAndNormalize(node);
        }
        throw new UnsupportedOperationException("Cannot call this without this being the document node.");
    }

    public ValidatedNode validateAndNormalize(Attribute node) {
        throw new UnsupportedOperationException("Cannot call this without this being an attribute node.");
    }

    public SchemaNode getChild(String elementName) {
        if (this.documentNode) {
            return (SchemaNode)this.globalElements.get(elementName);
        }
        return null;
    }

    public Collection getRootChildren() {
        if (this.documentNode) {
            return this.globalElements.keySet();
        }
        throw new UnsupportedOperationException("Cannot call this without this being the document node.");
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public String getSchemaNormalizedValue(Object value) throws NormalizationException {
        throw new UnsupportedOperationException("Cannot call this without this being the document node.");
    }

    public Object getActualNormalizedValue(String value) throws NormalizationException {
        throw new UnsupportedOperationException("Cannot call this without this being the document node.");
    }

    public String getName() {
        return this.elementName;
    }

    public Class getObjectType() {
        return Map.class;
    }

    public List getChildren() {
        return new ArrayList();
    }

    public String getDocumentAnnotation(String source) {
        return (String)this.getDocumentAnnotations().get(source);
    }

    public String getAppAnnotation(String source) {
        return (String)this.getAppAnnotations().get(source);
    }

    public Map getDocumentAnnotations() {
        return this.documentAnnotations;
    }

    public Map getAppAnnotations() {
        return this.appAnnotations;
    }

    public List getEnumeration() {
        return null;
    }

    public boolean hasEnumerations() {
        return this.getEnumeration() != null;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isDataNode() {
        return false;
    }

    public Element getSchemaElement() {
        return this.schemaElement;
    }

    public ElementType getType() {
        return null;
    }

    public String getLabel() {
        String label = null;
        label = this.getDocumentAnnotation("sakai.label");
        if (label == null) {
            label = this.getDocumentAnnotation("ospi.label");
        }
        if (label == null) {
            label = this.getName();
        }
        return label;
    }

    public GlobalMaps getGlobalMaps() {
        return this.globalMaps;
    }

    protected class GlobalMaps {
        public Map globalElements = new Hashtable();
        public Map globalCustomTypes = new Hashtable();
        public Map globalAttributeGroups = new Hashtable();

        protected GlobalMaps() {
        }
    }
}

