/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.xml.impl;

import org.jdom.Element;
import org.jdom.Namespace;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;
import org.sakaiproject.metaobj.utils.xml.impl.BaseElementType;
import org.sakaiproject.metaobj.utils.xml.impl.BooleanElementType;
import org.sakaiproject.metaobj.utils.xml.impl.DateFormatterElementType;
import org.sakaiproject.metaobj.utils.xml.impl.DecimalElementType;
import org.sakaiproject.metaobj.utils.xml.impl.NumberElementType;
import org.sakaiproject.metaobj.utils.xml.impl.UriElementType;

public class ElementTypeFactory {
    private static ElementTypeFactory instance = new ElementTypeFactory();
    private static final String INT_TYPES = "        xs:byte        xs:int        xs:integer        xs:long        xs:negativeInteger        xs:nonNegativeInteger        xs:nonPositiveInteger        xs:positiveInteger        xs:short        xs:unsignedLong        xs:unsignedInt        xs:unsignedShort        xs:unsignedByte";
    private static final String DECIMAL_TYPES = "        xs:decimal";
    private static final String BOOLEAN_TYPES = "        xs:boolean";
    private static final String DATE_TYPES = "        xs:date        xs:time        xs:dateTime";
    private static final String URI_TYPES = "        xs:anyURI";

    protected ElementTypeFactory() {
    }

    public static ElementTypeFactory getInstance() {
        return instance;
    }

    public BaseElementType createElementType(Element schemaElement, SchemaNode parentNode, Namespace xsdNamespace) {
        String typeName = "unknown";
        if (schemaElement.getAttributeValue("type") != null) {
            typeName = schemaElement.getAttributeValue("type");
        } else {
            Element simpleType = schemaElement.getChild("simpleType", xsdNamespace);
            if (simpleType == null) {
                simpleType = schemaElement.getChild("simpleContent", xsdNamespace);
            }
            if (simpleType != null) {
                Element restrictions = simpleType.getChild("restriction", xsdNamespace);
                typeName = restrictions != null ? restrictions.getAttributeValue("base") : simpleType.getChild("extension", xsdNamespace).getAttributeValue("base");
            }
        }
        if (INT_TYPES.indexOf(typeName) != -1) {
            return new NumberElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
        }
        if (DECIMAL_TYPES.indexOf(typeName) != -1) {
            return new DecimalElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
        }
        if (BOOLEAN_TYPES.indexOf(typeName) != -1) {
            return new BooleanElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
        }
        if (DATE_TYPES.indexOf(typeName) != -1) {
            return new DateFormatterElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
        }
        if (URI_TYPES.indexOf(typeName) != -1) {
            return new UriElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
        }
        return new BaseElementType(typeName, schemaElement, parentNode, xsdNamespace).postInit(xsdNamespace);
    }
}

