/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.utils.id.guid;

import java.io.Serializable;
import org.sakaiproject.metaobj.utils.id.guid.ByteOrder;
import org.sakaiproject.metaobj.utils.id.guid.RandomGUID;

public class Guid
implements Serializable {
    private static final int HEX_RADIX = 16;
    private static final short GUID_LEN = 16;
    private byte[] guid = new byte[16];
    public static final byte AUTOGEN_BY_DB = 1;
    public static final byte NO_AUTOGEN_BY_DB = 2;
    private String guidStr;
    private boolean dbAutoGen = true;

    public Guid() {
        boolean bSecureGuid = true;
        RandomGUID tmpGuid = new RandomGUID(bSecureGuid);
        this.guid = Guid.fromHexString(tmpGuid.valueAfterMD5);
        this.setGuid(this.guid);
        tmpGuid = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Guid)) {
            return false;
        }
        Guid guid = (Guid)o;
        return this.toString().equals(guid.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Guid(byte[] inGuid) {
        this.setGuid(inGuid);
    }

    public Guid(String sGuid) {
        if (sGuid == null || sGuid.length() != 32) {
            throw new IllegalArgumentException("sGuid is either null or the wrong length");
        }
        this.guid = Guid.fromHexString(sGuid);
        this.guidStr = this.internalToString();
    }

    public boolean isValidGuid() {
        return this.guid != null && this.guid.length == 16;
    }

    public void setGuid(byte[] inGuid) throws IllegalArgumentException {
        if (inGuid.length == 16) {
            for (int i = 0; i < 16; ++i) {
                this.guid[i] = inGuid[i];
            }
        } else {
            throw new IllegalArgumentException("GUID Passed in is not 16 bytes - it is " + inGuid.length + " bytes");
        }
        this.guidStr = this.internalToString();
    }

    public byte[] getGuid() {
        return (byte[])this.guid.clone();
    }

    public String getString() {
        return this.guidStr;
    }

    public String toString() {
        return this.guidStr;
    }

    private String internalToString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int val = ByteOrder.ubyte2int(this.guid[i]);
            String hexStr = Integer.toHexString(val);
            while (hexStr.length() < 2) {
                hexStr = "0" + hexStr;
            }
            buf.append(hexStr);
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] fromHexString(String sguid) throws IllegalArgumentException {
        byte[] bytes = new byte[16];
        try {
            for (int i = 0; i < 16; ++i) {
                bytes[i] = (byte)Integer.parseInt(sguid.substring(i * 2, i * 2 + 2), 16);
            }
            return bytes;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isValidGuidString(String sGuid) {
        return sGuid != null && sGuid.length() == 32;
    }

    public boolean isDbAutoGen() {
        return this.dbAutoGen;
    }

    public boolean getDbAutoGen() {
        return this.isDbAutoGen();
    }

    public void setAutoGen(boolean dbAutoGen) {
        this.dbAutoGen = dbAutoGen;
    }
}

