/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.model;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.metaobj.shared.model.ValidationError;
import org.sakaiproject.metaobj.utils.DateWidgetFormat;
import org.sakaiproject.metaobj.utils.mvc.intf.FieldValueWrapper;

public class DateBean
implements FieldValueWrapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String month = "";
    private String year = "";
    private String day = "";
    private String hour = "";
    private String minute = "";
    private String second = "";
    private String fullDate = null;
    boolean nullFlag = true;
    private Format dateFormat;
    private DateWidgetFormat dateFormatUtil = new DateWidgetFormat();

    public DateBean() {
        this.dateFormat = this.dateFormatUtil.getLocaleDateFormat();
    }

    public DateBean(Date date) {
        this.dateFormat = this.dateFormatUtil.getLocaleDateFormat();
        if (date != null) {
            this.setBackingDate(date);
        }
    }

    public void setBackingDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.setYear("" + cal.get(1));
        this.setMonth("" + (cal.get(2) + 1));
        this.setDay("" + cal.get(5));
        this.setHour("" + cal.get(10));
        this.setMinute("" + cal.get(12));
        this.setSecond("" + cal.get(13));
        this.nullFlag = false;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
        this.checkFlag(month);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
        this.checkFlag(year);
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
        this.checkFlag(day);
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
        this.checkFlag(hour);
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String minute) {
        this.minute = minute;
        this.checkFlag(minute);
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String second) {
        this.second = second;
        this.checkFlag(second);
    }

    public void setValue(Object value) {
        this.setBackingDate((Date)value);
        this.nullFlag = value == null;
    }

    public Object getValue() {
        return this.getDate();
    }

    public void validate(String fieldName, List errors, String label) {
        if (this.nullFlag) {
            return;
        }
        if (this.fullDate != null) {
            try {
                this.setValue(this.dateFormat.parseObject(this.getFullDate()));
            }
            catch (ParseException e) {
                errors.add(new ValidationError(label, fieldName, "DATE_INVALID_ERROR_CODE", new Object[]{this.getFullDate()}, MessageFormat.format("invalid date {0}", this.getFullDate())));
                this.nullFlag = true;
            }
            return;
        }
        try {
            Integer.parseInt(this.getYear());
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(label, fieldName + ".year", "invalid year {0}", new Object[]{this.getYear()}, MessageFormat.format("invalid year {0}", this.getYear())));
        }
        try {
            Integer.parseInt(this.getMonth());
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(label, fieldName + ".month", "invalid month {0}", new Object[]{this.getYear()}, MessageFormat.format("invalid month {0}", this.getYear())));
        }
        try {
            Integer.parseInt(this.getDay());
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationError(label, fieldName + ".day", "invalid day {0}", new Object[]{this.getYear()}, MessageFormat.format("invalid day {0}", this.getYear())));
        }
    }

    public Date getDate() {
        if (this.nullFlag) {
            return null;
        }
        return new GregorianCalendar(this.getValue(this.getYear()), this.getValue(this.getMonth()) - 1, this.getValue(this.getDay()), this.getValue(this.getHour()), this.getValue(this.getMinute()), this.getValue(this.getSecond())).getTime();
    }

    protected int getValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void checkFlag(String value) {
        this.nullFlag = value == null || value.length() == 0;
    }

    public String getFullDate() {
        return this.fullDate;
    }

    public void setFullDate(String fullDate) {
        this.fullDate = fullDate;
        this.checkFlag(fullDate);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

