/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.metaobj.shared.ArtifactFinder;
import org.sakaiproject.metaobj.shared.mgt.AgentManager;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.ContentResourceArtifact;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.MimeType;

public class FileArtifactFinder
implements ArtifactFinder {
    private ContentHostingService contentHostingService;
    private AgentManager agentManager;
    private IdManager idManager;
    private ReadableObjectHome contentResourceHome = null;

    public Collection findByOwnerAndType(Id owner, String type) {
        return this.findByOwnerAndType(owner, type, null);
    }

    public Collection findByOwnerAndType(Id owner, String type, MimeType mimeType) {
        String primaryMimeType = null;
        String subMimeType = null;
        if (mimeType != null) {
            primaryMimeType = mimeType.getPrimaryType();
            subMimeType = mimeType.getSubType();
        }
        List artifacts = this.getContentHostingService().findResources("fileResource", primaryMimeType, subMimeType);
        ArrayList<Artifact> returned = new ArrayList<Artifact>();
        for (ContentResource resource : artifacts) {
            Agent resourceOwner = this.getAgentManager().getAgent(resource.getProperties().getProperty("CHEF:creator"));
            if (owner != null && !owner.equals((Object)resourceOwner.getId())) continue;
            Artifact resourceArtifact = this.createArtifact(resource);
            returned.add(resourceArtifact);
        }
        return returned;
    }

    protected Artifact createArtifact(ContentResource resource, Id artifactId) {
        Agent resourceOwner = this.getAgentManager().getAgent(resource.getProperties().getProperty("CHEF:creator"));
        ContentResourceArtifact resourceArtifact = new ContentResourceArtifact(resource, artifactId, resourceOwner);
        resourceArtifact.setHome(this.getContentResourceHome());
        return resourceArtifact;
    }

    protected Artifact createArtifact(ContentResource resource) {
        Id artifactId = this.getIdManager().getId(this.getContentHostingService().getUuid(resource.getId()));
        return this.createArtifact(resource, artifactId);
    }

    public Collection findByOwner(Id owner) {
        return null;
    }

    public Collection findByWorksiteAndType(Id worksiteId, String type) {
        return null;
    }

    public Collection findByWorksite(Id worksiteId) {
        return null;
    }

    public Artifact load(Id artifactId) {
        String resourceId = this.getContentHostingService().resolveUuid(artifactId.getValue());
        if (resourceId == null) {
            return null;
        }
        try {
            ContentResource resource = this.getContentHostingService().getResource(resourceId);
            Artifact returned = this.createArtifact(resource, artifactId);
            return returned;
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
        catch (IdUnusedException e) {
            throw new RuntimeException(e);
        }
        catch (TypeException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection findByType(String type) {
        return null;
    }

    public boolean getLoadArtifacts() {
        return false;
    }

    public void setLoadArtifacts(boolean loadArtifacts) {
    }

    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public void setIdManager(IdManager idManager) {
        this.idManager = idManager;
    }

    public ReadableObjectHome getContentResourceHome() {
        return this.contentResourceHome;
    }

    public void setContentResourceHome(ReadableObjectHome contentResourceHome) {
        this.contentResourceHome = contentResourceHome;
    }
}

