/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.home;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Date;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.metaobj.shared.mgt.IdManager;
import org.sakaiproject.metaobj.shared.mgt.PresentableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.mgt.home.StructuredArtifactHome;
import org.sakaiproject.metaobj.shared.model.Agent;
import org.sakaiproject.metaobj.shared.model.Artifact;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.shared.model.StructuredArtifact;
import org.sakaiproject.metaobj.shared.model.StructuredArtifactDefinitionBean;
import org.sakaiproject.metaobj.shared.model.Type;
import org.sakaiproject.metaobj.utils.xml.SchemaFactory;
import org.sakaiproject.metaobj.utils.xml.SchemaInvalidException;
import org.sakaiproject.metaobj.utils.xml.SchemaNode;

public class StructuredArtifactDefinition
extends StructuredArtifactHome
implements Serializable {
    public static final int STATE_UNPUBLISHED = 0;
    public static final int STATE_WAITING_APPROVAL = 1;
    public static final int STATE_PUBLISHED = 2;
    private Id id;
    private String documentRoot;
    private Agent owner;
    private Date created = new Date();
    private Date modified = new Date();
    private transient String decoratedDescription;
    private boolean systemOnly = false;
    private String description;
    private boolean modifiable = true;
    private Id xslConversionFileId;
    private String schemaFileName;
    private String xslFileName;
    private SchemaNode schema;
    private Id alternateCreateXslt;
    private String alternateCreateXsltName;
    private Id alternateViewXslt;
    private String alternateViewXsltName;
    private int siteState;
    private int globalState;
    private boolean requiresXslFile = false;
    private Id schemaFile;
    private String action;

    public StructuredArtifactDefinition() {
    }

    public StructuredArtifactDefinition(StructuredArtifactDefinitionBean bean) {
        this.action = bean.getAction();
        this.created = bean.getCreated();
        this.description = bean.getDescription();
        this.documentRoot = bean.getDocumentRoot();
        this.globalState = bean.getGlobalState();
        this.id = bean.getId();
        this.modifiable = bean.isModifiable();
        this.modified = bean.getModified();
        this.owner = bean.getOwner();
        this.requiresXslFile = bean.getRequiresXslFile();
        if (bean.getSchema() != null) {
            SchemaFactory schemaFactory = SchemaFactory.getInstance();
            ByteArrayInputStream in = new ByteArrayInputStream(bean.getSchema());
            try {
                this.schema = schemaFactory.getSchema(in);
            }
            catch (Exception e) {
                throw new SchemaInvalidException(bean.getDescription(), e);
            }
        } else {
            this.schema = null;
        }
        this.schemaFile = bean.getSchemaFile();
        this.schemaFileName = bean.getSchemaFileName();
        this.siteState = bean.getSiteState();
        this.systemOnly = bean.isSystemOnly();
        this.xslConversionFileId = bean.getXslConversionFileId();
        this.xslFileName = bean.getXslFileName();
        this.setSiteId(bean.getSiteId());
        this.setExternalType(bean.getExternalType());
        this.setInstruction(bean.getInstruction());
        this.decoratedDescription = bean.getDecoratedDescription();
        this.alternateCreateXslt = bean.getAlternateCreateXslt();
        this.alternateViewXslt = bean.getAlternateViewXslt();
        this.alternateCreateXsltName = bean.getAlternateCreateXsltName();
        this.alternateViewXsltName = bean.getAlternateViewXsltName();
        if (this.getId() != null) {
            this.setTypeId(this.getId().getValue());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof StructuredArtifactDefinition)) {
            return false;
        }
        StructuredArtifactDefinition in = (StructuredArtifactDefinition)o;
        if (this.getId() == null && in.getId() == null) {
            return true;
        }
        if (this.getId() == null && in.getId() != null) {
            return false;
        }
        return this.getId().equals((Object)in.getId());
    }

    @Override
    public Artifact createInstance() {
        StructuredArtifact instance = new StructuredArtifact(this.documentRoot, this.getSchema().getChild(this.documentRoot));
        this.prepareInstance((Artifact)instance);
        return instance;
    }

    @Override
    public void prepareInstance(Artifact object) {
        object.setHome((ReadableObjectHome)this);
        StructuredArtifact xmlObject = (StructuredArtifact)object;
        xmlObject.getBaseElement().setName(this.documentRoot);
    }

    @Override
    public String getRootNode() {
        return this.documentRoot;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public void setDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Agent getOwner() {
        return this.owner;
    }

    public void setOwner(Agent owner) {
        this.owner = owner;
    }

    @Override
    public String getExternalType() {
        return super.getExternalType();
    }

    public void setExternalType(String newType) {
    }

    @Override
    public SchemaNode getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(SchemaNode schema) {
        this.schema = schema;
    }

    @Override
    public Type getType() {
        Type type = new Type();
        if (this.getId() != null) {
            type.setId(this.getId());
        }
        if (this.getDescription() != null) {
            type.setDescription(this.getDecoratedDescription());
        }
        type.setSystemOnly(this.isSystemOnly());
        return type;
    }

    @Override
    public boolean isSystemOnly() {
        return this.systemOnly;
    }

    public void setSystemOnly(boolean systemOnly) {
        this.systemOnly = systemOnly;
    }

    @Override
    public IdManager getIdManager() {
        return (IdManager)ComponentManager.getInstance().get("idManager");
    }

    @Override
    public PresentableObjectHome getRepositoryHelper() {
        return (PresentableObjectHome)ComponentManager.getInstance().get("repositoryHelper");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean getRequiresXslFile() {
        return this.requiresXslFile;
    }

    public void setRequiresXslFile(boolean requiresXslFile) {
        this.requiresXslFile = requiresXslFile;
    }

    public Id getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(Id schemaFile) {
        this.schemaFile = schemaFile;
    }

    public Id getXslConversionFileId() {
        return this.xslConversionFileId;
    }

    public void setXslConversionFileId(Id xslConversionFileId) {
        this.xslConversionFileId = xslConversionFileId;
    }

    @Override
    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    @Override
    public void setSchemaFileName(String schemaFileName) {
        this.schemaFileName = schemaFileName;
    }

    public String getXslFileName() {
        return this.xslFileName;
    }

    public void setXslFileName(String xslFileName) {
        this.xslFileName = xslFileName;
    }

    public int getSiteState() {
        return this.siteState;
    }

    public void setSiteState(int siteState) {
        this.siteState = siteState;
    }

    public int getGlobalState() {
        return this.globalState;
    }

    public void setGlobalState(int globalState) {
        this.globalState = globalState;
    }

    public boolean getCanPublish() {
        return this.siteState == 0 && this.globalState != 2;
    }

    public boolean getCanGlobalPublish() {
        return this.globalState == 0;
    }

    public boolean getCanSuggestGlobalPublish() {
        return this.globalState == 0;
    }

    public boolean getCanApproveGlobalPublish() {
        return this.globalState == 1;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDecoratedDescription() {
        return this.decoratedDescription;
    }

    public void setDecoratedDescription(String decoratedDescription) {
        this.decoratedDescription = decoratedDescription;
    }

    public Id getAlternateCreateXslt() {
        return this.alternateCreateXslt;
    }

    public void setAlternateCreateXslt(Id alternateCreateXslt) {
        this.alternateCreateXslt = alternateCreateXslt;
    }

    public String getAlternateCreateXsltName() {
        return this.alternateCreateXsltName;
    }

    public void setAlternateCreateXsltName(String alternateCreateXsltName) {
        this.alternateCreateXsltName = alternateCreateXsltName;
    }

    public Id getAlternateViewXslt() {
        return this.alternateViewXslt;
    }

    public void setAlternateViewXslt(Id alternateViewXslt) {
        this.alternateViewXslt = alternateViewXslt;
    }

    public String getAlternateViewXsltName() {
        return this.alternateViewXsltName;
    }

    public void setAlternateViewXsltName(String alternateViewXsltName) {
        this.alternateViewXsltName = alternateViewXsltName;
    }
}

