/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt.factories;

import java.util.Hashtable;
import java.util.Map;
import org.sakaiproject.metaobj.shared.mgt.HomeFactory;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.model.Id;

public abstract class HomeFactoryBase
implements HomeFactory {
    private Map homesByExternalId = null;
    private Object homesByExternalIdLock = new Object();

    public void reload() {
        if (this.homesByExternalId == null) {
            this.homesByExternalId = new Hashtable();
        }
        this.homesByExternalId.clear();
        for (ReadableObjectHome readableObjectHome : this.getHomes().entrySet()) {
            readableObjectHome.refresh();
            this.homesByExternalId.put(readableObjectHome.getExternalType(), readableObjectHome);
        }
    }

    public synchronized ReadableObjectHome findHomeByExternalId(String externalId, Id worksiteId) {
        if (this.homesByExternalId == null) {
            this.homesByExternalId = new Hashtable();
            for (Map.Entry entry : this.getHomes().entrySet()) {
                ReadableObjectHome home = (ReadableObjectHome)entry.getValue();
                this.homesByExternalId.put(home.getExternalType(), home);
            }
        }
        return (ReadableObjectHome)this.homesByExternalId.get(externalId);
    }

    protected void addHome(ReadableObjectHome newHome) {
        this.homesByExternalId.put(newHome.getExternalType(), newHome);
    }

    public Map getHomes(Class requiredHomeType) {
        Hashtable newMap = new Hashtable();
        Map homes = this.getHomes();
        for (Map.Entry entry : homes.entrySet()) {
            if (!requiredHomeType.isInstance(entry.getValue())) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    public Map getWorksiteHomes(Id worksiteId) {
        return this.getHomes();
    }

    public Map getWorksiteHomes(Id worksiteId, boolean includeHidden) {
        return this.getHomes();
    }

    public Map getWorksiteHomes(Id worksiteId, String currentUserId, boolean includeHidden) {
        return this.getHomes();
    }
}

