/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.metaobj.shared.mgt.HomeFactory;
import org.sakaiproject.metaobj.shared.mgt.ReadableObjectHome;
import org.sakaiproject.metaobj.shared.model.Id;
import org.sakaiproject.metaobj.utils.xml.SchemaFactory;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;

public class HomeFactoryImpl
implements HomeFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List homeFactories = null;

    public boolean handlesType(String objectType) {
        Iterator i = this.homeFactories.iterator();
        while (i.hasNext()) {
            if (!((HomeFactory)i.next()).handlesType(objectType)) continue;
            return true;
        }
        return false;
    }

    public ReadableObjectHome getHome(String objectType) {
        ReadableObjectHome cachedHome = (ReadableObjectHome)ThreadLocalManager.get((String)("HomeFactory.getHome@" + objectType));
        if (cachedHome != null) {
            return cachedHome;
        }
        for (HomeFactory testFactory : this.homeFactories) {
            if (!testFactory.handlesType(objectType)) continue;
            ReadableObjectHome home = testFactory.getHome(objectType);
            ThreadLocalManager.set((String)("HomeFactory.getHome@" + objectType), (Object)home);
            return home;
        }
        return null;
    }

    public ReadableObjectHome findHomeByExternalId(String externalId, Id worksiteId) {
        Iterator i = this.getHomeFactories().iterator();
        while (i.hasNext()) {
            ReadableObjectHome home = ((HomeFactory)i.next()).findHomeByExternalId(externalId, worksiteId);
            if (home == null) continue;
            return home;
        }
        return null;
    }

    public Map getHomes() {
        Hashtable homes = new Hashtable();
        Iterator i = this.getHomeFactories().iterator();
        while (i.hasNext()) {
            homes.putAll(((HomeFactory)i.next()).getHomes());
        }
        return homes;
    }

    public Map getWorksiteHomes(Id worksiteId) {
        return this.getWorksiteHomes(worksiteId, false);
    }

    public Map getWorksiteHomes(Id worksiteId, boolean includeHidden) {
        Hashtable homes = new Hashtable();
        Iterator i = this.getHomeFactories().iterator();
        while (i.hasNext()) {
            homes.putAll(((HomeFactory)i.next()).getWorksiteHomes(worksiteId, includeHidden));
        }
        return homes;
    }

    public Map getWorksiteHomes(Id worksiteId, String currentUserId, boolean includeHidden) {
        Hashtable homes = new Hashtable();
        Iterator i = this.getHomeFactories().iterator();
        while (i.hasNext()) {
            homes.putAll(((HomeFactory)i.next()).getWorksiteHomes(worksiteId, currentUserId, includeHidden));
        }
        return homes;
    }

    public Map getHomes(Class requiredHomeType) {
        Hashtable homes = new Hashtable();
        Iterator i = this.getHomeFactories().iterator();
        while (i.hasNext()) {
            homes.putAll(((HomeFactory)i.next()).getHomes(requiredHomeType));
        }
        return homes;
    }

    public void reload() {
        SchemaFactory.getInstance().reload();
        for (ReadableObjectHome home : this.getHomes().values()) {
            home.refresh();
        }
    }

    public List getHomeFactories() {
        return this.homeFactories;
    }

    public void setHomeFactories(List homeFactories) {
        this.homeFactories = homeFactories;
    }
}

