/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.metaobj.shared.mgt;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.metaobj.shared.mgt.ContentEntityWrapper;
import org.sakaiproject.metaobj.shared.mgt.ReferenceParser;
import org.sakaiproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EntityProducerBase
implements EntityProducer {
    private EntityManager entityManager;
    private HttpAccess httpAccess;

    public boolean willArchiveMerge() {
        return false;
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        return null;
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        if (reference.startsWith(this.getContext())) {
            String wrappedRef = reference.substring(this.getLabel().length() + 1);
            Reference wrapped = this.entityManager.newReference(wrappedRef);
            ref.set(this.getLabel(), null, wrapped.getId(), wrapped.getContainer(), wrapped.getContext());
            return true;
        }
        return false;
    }

    protected String getContext() {
        return "/" + this.getLabel() + "/";
    }

    public String getEntityDescription(Reference ref) {
        return ref.getId();
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        ContentEntityWrapper entity = this.getContentEntityWrapper(ref);
        return entity.getBase().getProperties();
    }

    protected ContentEntityWrapper getContentEntityWrapper(Reference ref) {
        String wholeRef = ref.getReference();
        ReferenceParser parser = this.parseReference(wholeRef);
        ContentResource base = (ContentResource)this.entityManager.newReference(parser.getRef()).getEntity();
        if (base == null) {
            parser = this.parseReference(ref.getReference());
            base = (ContentResource)this.entityManager.newReference(parser.getRef()).getEntity();
        }
        return new ContentEntityWrapper(base, wholeRef);
    }

    protected ReferenceParser parseReference(String wholeRef) {
        return new ReferenceParser(wholeRef, (EntityProducer)this);
    }

    public Entity getEntity(Reference ref) {
        return this.getContentEntityWrapper(ref);
    }

    public String getEntityUrl(Reference ref) {
        return ServerConfigurationService.getAccessUrl() + Validator.escapeUrl((String)ref.getReference());
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public HttpAccess getHttpAccess() {
        return this.httpAccess;
    }

    public void setHttpAccess(HttpAccess httpAccess) {
        this.httpAccess = httpAccess;
    }

    public void destroy() {
    }
}

