/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.i18n.InternationalizedMessages;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.util.DbResourceBundle;
import org.sakaiproject.util.DummyMap;

public class ResourceLoader
extends DummyMap
implements InternationalizedMessages {
    protected static final Log M_log = LogFactory.getLog(ResourceLoader.class);
    protected String baseName = null;
    protected ClassLoader classLoader = null;
    protected ConcurrentHashMap<Locale, ResourceBundle> bundles = new ConcurrentHashMap();
    protected ConcurrentHashMap<Locale, Date> bundlesTimestamp = new ConcurrentHashMap();
    protected String userId = null;
    protected final String LOCALE_SESSION_KEY = "sakai.locale.";
    protected final String DEBUG_LOCALE = "en_US_DEBUG";
    private final String DBG_PREFIX = "** ";
    private final String DBG_SUFFIX = " **";
    private static final Object LOCK = new Object();
    private static SessionManager sessionManager;
    private static PreferencesService preferencesService;

    public String getBaseName() {
        return this.baseName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SessionManager getSessionManager() {
        if (sessionManager == null) {
            Object object = LOCK;
            synchronized (object) {
                sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);
            }
        }
        return sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PreferencesService getPreferencesService() {
        if (preferencesService == null) {
            Object object = LOCK;
            synchronized (object) {
                preferencesService = (PreferencesService)ComponentManager.get(PreferencesService.class);
            }
        }
        return preferencesService;
    }

    public ResourceLoader() {
    }

    public ResourceLoader(String name) {
        this.baseName = name;
    }

    public ResourceLoader(String name, ClassLoader classLoader) {
        this.baseName = name;
        this.classLoader = classLoader;
    }

    public ResourceLoader(String userId, String name) {
        this.userId = userId;
        this.baseName = name;
    }

    @Override
    public Set entrySet() {
        return this.getBundleAsMap().entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.getString(key.toString());
    }

    public String getFormattedMessage(String key, Object ... args) {
        if (this.getLocale().toString().equals("en_US_DEBUG")) {
            return this.formatDebugPropertiesString(key);
        }
        String pattern = (String)this.get(key);
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("getFormattedMessage(key,args) bundle name=" + this.baseName + ", locale=" + this.getLocale().toString() + ", key=" + key + ", pattern=" + pattern));
        }
        return new MessageFormat(pattern, this.getLocale()).format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public int getInt(String key, int dflt) {
        String value = this.getString(key);
        int originalLength = value.length();
        if (originalLength == 0) {
            return dflt;
        }
        try {
            value = value.trim();
            if (originalLength != value.length()) {
                M_log.warn((Object)("getInt(key, dflt) bundle name=" + this.baseName + ", locale=" + this.getLocale() + ", key=" + key + ", dflt=" + dflt + ", Trailing whitespace trimmed."));
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("getInt(key, dflt) bundle name=" + this.baseName + ", locale=" + this.getLocale() + ", key=" + key + ", dflt=" + dflt + ", NumberFormatException"));
            }
            return dflt;
        }
    }

    public String getLocaleDisplayName(Locale loc) {
        Locale preferedLoc = this.getLocale();
        StringBuilder displayName = new StringBuilder(loc.getDisplayLanguage(loc));
        if (StringUtils.isNotBlank((String)loc.getDisplayCountry(loc))) {
            displayName.append(" - ").append(loc.getDisplayCountry(loc));
        }
        if (StringUtils.isNotBlank((String)loc.getVariant())) {
            displayName.append(" (").append(loc.getDisplayVariant(loc)).append(")");
        }
        displayName.append(" [").append(loc.toString()).append("] ");
        displayName.append(loc.getDisplayLanguage(preferedLoc));
        if (StringUtils.isNotBlank((String)loc.getDisplayCountry(preferedLoc))) {
            displayName.append(" - ").append(loc.getDisplayCountry(preferedLoc));
        }
        return displayName.toString();
    }

    public Locale getLocale() {
        Locale loc;
        if (this.userId != null) {
            loc = this.getLocale(this.userId);
        } else {
            block6: {
                try {
                    String sessionId = ResourceLoader.getSessionManager().getCurrentSession().getId();
                    M_log.debug((Object)("Retrieving locale for sessionId: " + sessionId));
                    loc = (Locale)ResourceLoader.getSessionManager().getCurrentSession().getAttribute("sakai.locale." + sessionId);
                }
                catch (NullPointerException e) {
                    loc = null;
                    if (!M_log.isWarnEnabled()) break block6;
                    M_log.warn((Object)"getLocale() swallowing NPE - caused by a null sessionmanager or null session, OK for tests, problem if production");
                }
            }
            if (loc == null) {
                loc = this.setContextLocale(null);
            }
        }
        if (loc == null) {
            M_log.info((Object)"getLocale() Locale not found in preferences or session, returning default");
            loc = Locale.getDefault();
        }
        M_log.debug((Object)("Locale: " + loc.toString()));
        return loc;
    }

    protected String formatDebugPropertiesString(String key) {
        return "** " + this.baseName + " " + key + " **";
    }

    public Locale getLocale(String userId) {
        return ResourceLoader.getPreferencesService().getLocale(userId);
    }

    public Locale setContextLocale(Locale loc) {
        block19: {
            block18: {
                block17: {
                    if (loc == null) {
                        try {
                            String userId = ResourceLoader.getSessionManager().getCurrentSessionUserId();
                            if (M_log.isDebugEnabled()) {
                                M_log.debug((Object)("setContextLocale(Locale), checking user preferences for userId: " + userId));
                            }
                            loc = this.getLocale(userId);
                        }
                        catch (Exception e) {
                            if (!M_log.isWarnEnabled()) break block17;
                            M_log.warn((Object)"setContextLocale(Locale) swallowing Exception");
                            e.printStackTrace();
                        }
                    }
                }
                if (loc == null) {
                    try {
                        if (M_log.isDebugEnabled()) {
                            M_log.debug((Object)"setContextLocale(Locale), checking browser session.");
                        }
                        loc = (Locale)ResourceLoader.getSessionManager().getCurrentSession().getAttribute("locale");
                    }
                    catch (NullPointerException e) {
                        if (!M_log.isWarnEnabled()) break block18;
                        M_log.warn((Object)"setContextLocale(Locale) swallowing NPE");
                        e.printStackTrace();
                    }
                }
            }
            if (loc == null) {
                loc = Locale.getDefault();
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)"setContextLocale(Locale), using default locale");
                }
            } else if (!Locale.getDefault().getLanguage().equals("en") && loc.getLanguage().equals("en") && !loc.toString().equals("en_US_DEBUG")) {
                loc = new Locale("");
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)"setContextLocale(Locale), Tweak for English");
                }
            }
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Locale is: " + loc.toString()));
            }
            try {
                String sessionId = ResourceLoader.getSessionManager().getCurrentSession().getId();
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)("Setting locale into session: " + sessionId));
                }
                ResourceLoader.getSessionManager().getCurrentSession().setAttribute("sakai.locale." + sessionId, (Object)loc);
            }
            catch (Exception e) {
                if (!M_log.isWarnEnabled()) break block19;
                M_log.warn((Object)"setContextLocale(Locale) swallowing Exception");
            }
        }
        return loc;
    }

    public boolean getIsValid(String key) {
        try {
            String value = this.getBundle().getString(key);
            return value != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof String)) {
            return false;
        }
        return this.getIsValid((String)key);
    }

    public String getString(String key) {
        if (this.getLocale().toString().equals("en_US_DEBUG")) {
            return this.formatDebugPropertiesString(key);
        }
        try {
            String value = this.getBundle().getString(key);
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("getString(key) bundle name=" + this.baseName + ", locale=" + this.getLocale().toString() + ", key=" + key + ", value=" + value));
            }
            return value;
        }
        catch (MissingResourceException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  missing key: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (mre): " + this.baseName + " " + key + "]";
        }
        catch (NullPointerException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  null pointer exception: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (npe): " + this.baseName + " " + key + "]";
        }
        catch (ClassCastException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  class cast exception: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (clc): " + this.baseName + " " + key + "]";
        }
    }

    public String getString(String key, String dflt) {
        if (this.getLocale().toString().equals("en_US_DEBUG")) {
            return this.formatDebugPropertiesString(key);
        }
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return dflt;
        }
        catch (NullPointerException e) {
            return dflt;
        }
        catch (ClassCastException e) {
            return dflt;
        }
    }

    public String[] getStrings(String key) {
        if (this.getLocale().toString().equals("en_US_DEBUG")) {
            return new String[]{this.formatDebugPropertiesString(key)};
        }
        int count = this.getInt(key + ".count", 0);
        if (count > 0) {
            String[] rv = new String[count];
            for (int i = 1; i <= count; ++i) {
                String value;
                block5: {
                    value = "";
                    try {
                        value = this.getBundle().getString(key + "." + i);
                    }
                    catch (MissingResourceException e) {
                        if (!M_log.isWarnEnabled()) break block5;
                        M_log.warn((Object)("getStrings(" + key + ") swallowing MissingResourceException for String " + i));
                        e.printStackTrace();
                    }
                }
                rv[i - 1] = value;
            }
            return rv;
        }
        return null;
    }

    @Override
    public Set keySet() {
        return this.getBundle().keySet();
    }

    public void purgeCache() {
        this.bundles = new ConcurrentHashMap();
        M_log.debug((Object)"purge bundle cache");
    }

    public void setBaseName(String name) {
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("set baseName=" + name));
        }
        this.baseName = name;
    }

    @Override
    public Collection values() {
        return this.getBundleAsMap().values();
    }

    @Override
    public int size() {
        return this.getBundle().keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getBundle().keySet().isEmpty();
    }

    protected ResourceBundle getBundle() {
        if (ServerConfigurationService.getBoolean((String)"load.bundles.from.db", (boolean)false)) {
            return this.getBundleFromDb();
        }
        Locale loc = this.getLocale();
        ResourceBundle bundle = this.bundles.get(loc);
        if (bundle == null) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Load bundle name=" + this.baseName + ", locale=" + this.getLocale().toString()));
            }
            bundle = this.loadBundle(loc);
        }
        return bundle;
    }

    protected ResourceBundle getBundleFromDb() {
        Locale loc = this.getLocale();
        ResourceBundle bundle = this.bundles.get(loc);
        Date timeStamp = this.bundlesTimestamp.get(loc);
        if (timeStamp == null || timeStamp.getTime() + (long)ServerConfigurationService.getInt((String)"load.bundles.from.db.timeout", (int)30000) < new Date().getTime()) {
            M_log.debug((Object)("Load bundle name=" + this.baseName + ", locale=" + this.getLocale().toString()));
            bundle = this.loadBundle(loc);
        }
        return bundle;
    }

    protected Map<Object, Object> getBundleAsMap() {
        ConcurrentHashMap<Object, Object> bundle = new ConcurrentHashMap<Object, Object>();
        Enumeration<String> e = this.getBundle().getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            bundle.put(key, this.getBundle().getObject(key));
        }
        return bundle;
    }

    protected ResourceBundle loadBundle(Locale loc) {
        if (ServerConfigurationService.getBoolean((String)"load.bundles.from.db", (boolean)false)) {
            return this.loadBundleFromDb(loc);
        }
        ResourceBundle newBundle = null;
        try {
            newBundle = this.classLoader == null ? ResourceBundle.getBundle(this.baseName, loc) : ResourceBundle.getBundle(this.baseName, loc, this.classLoader);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setBundle(loc, newBundle);
        return newBundle;
    }

    protected ResourceBundle loadBundleFromDb(Locale loc) {
        ResourceBundle newBundle;
        try {
            newBundle = DbResourceBundle.addResourceBundle(this.baseName, loc, this.classLoader);
        }
        catch (Exception e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("loadBundle " + this.baseName + " " + loc.toString()), (Throwable)e);
            }
            throw new MissingResourceException("ResourceLoader.loadBundle failed", "", "");
        }
        DbResourceBundle.indexResourceBundle(this.baseName, newBundle, loc, this.classLoader);
        this.setBundle(loc, newBundle);
        return newBundle;
    }

    protected void setBundle(Locale loc, ResourceBundle bundle) {
        if (loc == null || bundle == null) {
            return;
        }
        this.bundles.put(loc, bundle);
        this.bundlesTimestamp.put(loc, new Date());
    }

    public String toString() {
        return "ResourceLoader{base='" + this.baseName + '\'' + ", user='" + this.userId + '\'' + '}';
    }
}

