/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.content.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;

public class ZipContentUtil {
    protected static final Log LOG = LogFactory.getLog(ZipContentUtil.class);
    private static final String ZIP_EXTENSION = ".zip";
    private static final int BUFFER_SIZE = 32000;
    private static final MimetypesFileTypeMap mime = new MimetypesFileTypeMap();
    public static final String PREFIX = "resources.";
    public static final String REQUEST = "request.";
    private static final String STATE_HOME_COLLECTION_ID = "resources.request.collection_home";
    private static final String STATE_HOME_COLLECTION_DISPLAY_NAME = "resources.request.collection_home_display_name";
    public static final String STATE_MESSAGE = "message";
    public static final int MAX_ZIP_EXTRACT_FILES_DEFAULT = 1000;
    private static Integer MAX_ZIP_EXTRACT_FILES;

    public static int getMaxZipExtractFiles() {
        if (MAX_ZIP_EXTRACT_FILES == null) {
            MAX_ZIP_EXTRACT_FILES = ServerConfigurationService.getInt((String)"content.zip.expand.maxfiles", (int)1000);
        }
        if (MAX_ZIP_EXTRACT_FILES <= 0) {
            MAX_ZIP_EXTRACT_FILES = 1000;
            LOG.warn((Object)"content.zip.expand.maxfiles is set to a value less than or equal to 0, defaulting to 1000");
        }
        return MAX_ZIP_EXTRACT_FILES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressFolder(Reference reference) {
        File temp = null;
        FileInputStream fis = null;
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        try {
            ZipOutputStream out = null;
            try {
                temp = File.createTempFile("sakai_content-", ".tmp");
                ContentCollection collection = ContentHostingService.getCollection((String)reference.getId());
                out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(temp), 32000));
                this.storeContentCollection(reference.getId(), collection, out);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            String resourceId = reference.getId().substring(0, reference.getId().lastIndexOf("/"));
            String resourceName = this.extractName(resourceId);
            String homeCollectionId = (String)toolSession.getAttribute(STATE_HOME_COLLECTION_ID);
            if (homeCollectionId != null && homeCollectionId.equals(reference.getId())) {
                resourceId = reference.getId() + resourceName;
                String homeName = (String)toolSession.getAttribute(STATE_HOME_COLLECTION_DISPLAY_NAME);
                if (homeName != null) {
                    resourceName = homeName;
                }
            }
            int count = 0;
            ContentResourceEdit resourceEdit = null;
            while (true) {
                try {
                    String newResourceId = resourceId;
                    String newResourceName = resourceName;
                    if (++count > 1) {
                        newResourceId = newResourceId + "_" + count;
                        newResourceName = newResourceName + "_" + count;
                    }
                    newResourceId = newResourceId + ZIP_EXTENSION;
                    newResourceName = newResourceName + ZIP_EXTENSION;
                    resourceEdit = ContentHostingService.addResource((String)newResourceId);
                    resourceId = newResourceId;
                    resourceName = newResourceName;
                }
                catch (IdUsedException e) {
                    continue;
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
                break;
            }
            fis = new FileInputStream(temp);
            resourceEdit.setContent((InputStream)fis);
            resourceEdit.setContentType(mime.getContentType(resourceId));
            ResourcePropertiesEdit props = resourceEdit.getPropertiesEdit();
            props.addProperty("DAV:displayname", resourceName);
            ContentHostingService.commitResource((ContentResourceEdit)resourceEdit, (int)0);
        }
        catch (PermissionException pE) {
            this.addAlert(toolSession, "You do not have the proper permissions for compressing to zip archive");
            LOG.warn((Object)pE);
        }
        catch (Exception e) {
            this.addAlert(toolSession, "An error has occurred while compressing to zip archive");
            LOG.error((Object)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (temp != null && temp.exists() && !temp.delete()) {
                LOG.warn((Object)"failed to remove temp file");
            }
        }
    }

    private void addAlert(ToolSession toolSession, String alert) {
        String errorMessage = (String)toolSession.getAttribute(STATE_MESSAGE);
        errorMessage = errorMessage == null ? alert : errorMessage + "\n\n" + alert;
        toolSession.setAttribute(STATE_MESSAGE, (Object)errorMessage);
    }

    public void extractArchive(Reference reference) throws Exception {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        this.extractArchive(reference.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractArchive(String referenceId) throws Exception {
        ContentResource resource = ContentHostingService.getResource((String)referenceId);
        String rootCollectionId = this.extractZipCollectionPrefix(resource);
        ContentCollectionEdit rootCollection = ContentHostingService.addCollection((String)rootCollectionId);
        ResourcePropertiesEdit prop = rootCollection.getPropertiesEdit();
        prop.addProperty("DAV:displayname", this.extractZipCollectionName(resource));
        ContentHostingService.commitCollection((ContentCollectionEdit)rootCollection);
        File temp = null;
        try {
            temp = this.exportResourceToFile(resource);
            ZipFile zipFile = new ZipFile(temp, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextElement = entries.nextElement();
                if (nextElement.isDirectory()) {
                    this.createContentCollection(rootCollectionId, nextElement);
                    continue;
                }
                this.createContentResource(rootCollectionId, nextElement, zipFile);
            }
            zipFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            temp.delete();
        }
    }

    public Map<String, Long> getZipManifest(Reference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("reference cannot be null");
        }
        return this.getZipManifest(reference.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getZipManifest(String referenceId) {
        ContentResource resource;
        HashMap<String, Long> ret = new HashMap<String, Long>();
        try {
            resource = ContentHostingService.getResource((String)referenceId);
        }
        catch (PermissionException e1) {
            return null;
        }
        catch (IdUnusedException e1) {
            return null;
        }
        catch (TypeException e1) {
            return null;
        }
        File temp = null;
        try {
            temp = this.exportResourceToFile(resource);
            ZipFile zipFile = new ZipFile(temp, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            for (int i = 0; entries.hasMoreElements() && i <= ZipContentUtil.getMaxZipExtractFiles(); ++i) {
                ZipEntry nextElement = entries.nextElement();
                ret.put(nextElement.getName(), nextElement.getSize());
            }
            zipFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (temp.exists() && !temp.delete()) {
                LOG.warn((Object)"uanble to delete temp file!");
            }
        }
        return ret;
    }

    private void createContentResource(String rootCollectionId, ZipEntry nextElement, ZipFile zipFile) throws Exception {
        String resourceId = rootCollectionId + nextElement.getName();
        String resourceName = this.extractName(nextElement.getName());
        ContentResourceEdit resourceEdit = ContentHostingService.addResource((String)resourceId);
        resourceEdit.setContent(zipFile.getInputStream(nextElement));
        resourceEdit.setContentType(mime.getContentType(resourceName));
        ResourcePropertiesEdit props = resourceEdit.getPropertiesEdit();
        props.addProperty("DAV:displayname", resourceName);
        ContentHostingService.commitResource((ContentResourceEdit)resourceEdit, (int)0);
    }

    private void createContentCollection(String rootCollectionId, ZipEntry element) throws Exception {
        String resourceId = rootCollectionId + element.getName();
        String resourceName = this.extractName(element.getName());
        ContentCollectionEdit collection = ContentHostingService.addCollection((String)resourceId);
        ResourcePropertiesEdit props = collection.getPropertiesEdit();
        props.addProperty("DAV:displayname", resourceName);
        ContentHostingService.commitCollection((ContentCollectionEdit)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportResourceToFile(ContentResource resource) {
        File temp = null;
        FileOutputStream out = null;
        try {
            temp = File.createTempFile("sakai_content-", ".tmp");
            temp.deleteOnExit();
            out = new FileOutputStream(temp);
            IOUtils.copy((InputStream)resource.streamContent(), (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServerOverloadException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return temp;
    }

    private void storeContentCollection(String rootId, ContentCollection collection, ZipOutputStream out) throws Exception {
        List members = collection.getMembers();
        for (String memberId : members) {
            if (memberId.endsWith("/")) {
                ContentCollection memberCollection = ContentHostingService.getCollection((String)memberId);
                this.storeContentCollection(rootId, memberCollection, out);
                continue;
            }
            ContentResource resource = ContentHostingService.getResource((String)memberId);
            this.storeContentResource(rootId, resource, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeContentResource(String rootId, ContentResource resource, ZipOutputStream out) throws Exception {
        String filename = resource.getId().substring(rootId.length(), resource.getId().length());
        ZipEntry zipEntry = new ZipEntry(filename);
        zipEntry.setSize(resource.getContentLength());
        out.putNextEntry(zipEntry);
        InputStream contentStream = null;
        try {
            contentStream = resource.streamContent();
            IOUtils.copy((InputStream)contentStream, (OutputStream)out);
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
    }

    private String extractZipCollectionPrefix(ContentResource resource) {
        String idPrefix = resource.getContainingCollection().getId() + this.extractZipCollectionName(resource) + "/";
        return idPrefix;
    }

    private String extractName(String collectionName) {
        String[] tmp = collectionName.split("/");
        return tmp[tmp.length - 1];
    }

    private String extractZipCollectionName(ContentResource resource) {
        String tmp = this.extractName(resource.getId());
        return tmp.substring(0, tmp.lastIndexOf("."));
    }
}

