/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;

public class ResponseHeaderFilter
implements Filter {
    private static Log log = LogFactory.getLog(ResponseHeaderFilter.class);
    private Map<String, String> headerMap = new ConcurrentHashMap<String, String>();

    public Map<String, String> getHeaderMap() {
        return new HashMap<String, String>(this.headerMap);
    }

    public String addHeader(String name, String value) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("header name cannot be null or blank");
        }
        if (this.headerMap != null) {
            if (value == null) {
                return this.headerMap.remove(name);
            }
            return this.headerMap.put(name, value);
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String[] headerStrings;
        String webappName = filterConfig.getServletContext().getServletContextName();
        Enumeration paramNames = filterConfig.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = filterConfig.getInitParameter(paramName);
            if (paramName == null || paramValue == null) continue;
            this.headerMap.put(paramName, paramValue);
        }
        org.sakaiproject.component.api.ServerConfigurationService serverConfigurationService = ServerConfigurationService.getInstance();
        if (serverConfigurationService != null && (headerStrings = serverConfigurationService.getStrings("response.headers")) != null) {
            for (String headerString : headerStrings) {
                if (headerString == null || "".equals(headerString)) continue;
                int loc = headerString.indexOf("::");
                if (loc <= 0) {
                    log.warn((Object)("Invalid header string in sakai config (must contain '::', e.g. key::value): " + headerString));
                    continue;
                }
                String name = headerString.substring(0, loc);
                if (name == null || "".equals(name)) {
                    log.warn((Object)("Invalid header string in sakai config (name must not be empty): " + headerString));
                    continue;
                }
                String value = null;
                if (headerString.length() > loc + 2) {
                    value = headerString.substring(loc + 2);
                }
                this.addHeader(name, value);
                if (value == null) {
                    log.info((Object)("Removing header (" + name + ") from all responses for current webapp: " + webappName));
                    continue;
                }
                log.info((Object)("Adding header (" + name + " -> " + value + ") to all responses for current webapp: " + webappName));
            }
        }
        log.info((Object)("INIT: for webapp " + webappName));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (Map.Entry<String, String> headerEntry : this.headerMap.entrySet()) {
                httpResponse.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        if (this.headerMap != null) {
            this.headerMap.clear();
        }
        log.info((Object)"DESTROY");
    }
}

