/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.javax;

public class PagingPosition
implements Cloneable {
    protected int m_first = 1;
    protected int m_last = 1;
    protected boolean m_paging = true;

    public PagingPosition() {
        this.m_first = 1;
        this.m_last = 1;
    }

    public PagingPosition(int first, int last) {
        this.m_first = first;
        this.m_last = last;
        this.validate();
    }

    public void adjustPostition(int distance) {
        this.m_first += distance;
        this.m_last += distance;
        this.validate();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignore) {
            throw new RuntimeException("Assertion failure");
        }
    }

    public int getFirst() {
        return this.m_first;
    }

    public int getLast() {
        return this.m_last;
    }

    public boolean isPaging() {
        return this.m_paging;
    }

    public void setPaging(boolean paging) {
        this.m_paging = paging;
    }

    public void setPosition(int first, int last) {
        this.m_first = first;
        this.m_last = last;
        this.validate();
    }

    protected void validate() {
        if (this.m_first < 0) {
            this.m_first = 1;
        }
        if (this.m_last < this.m_first) {
            this.m_last = this.m_first;
        }
    }

    public void validate(int biggestLast) {
        if (this.m_first < 0) {
            this.m_first = 1;
        }
        if (this.m_last > biggestLast) {
            this.m_last = biggestLast;
        }
        if (this.m_last < this.m_first) {
            this.m_last = this.m_first;
        }
    }
}

