/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.content.api;

import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.sakaiproject.antivirus.api.VirusFoundException;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdLengthException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.time.api.Time;
import org.w3c.dom.Document;

public interface ContentHostingService
extends EntityProducer {
    public static final String APPLICATION_ID = "sakai:content";
    public static final String CONDITIONAL_ACCESS_LIST = "conditional_access_list";
    public static final String REFERENCE_ROOT = "/content";
    public static final String EVENT_RESOURCE_ADD = "content.new";
    public static final String EVENT_RESOURCE_READ = "content.read";
    public static final String EVENT_RESOURCE_WRITE = "content.revise";
    public static final String EVENT_RESOURCE_REMOVE = "content.delete";
    public static final String EVENT_RESOURCE_AVAILABLE = "content.available";
    public static final String EVENT_RESOURCE_UNAVAILABLE = "content.unavailable";
    public static final String EVENT_RESOURCE_UPD_VISIBILITY = "content.upd.visibility";
    public static final String EVENT_RESOURCE_UPD_ACCESS = "content.upd.access";
    public static final String EVENT_RESOURCE_UPD_TITLE = "content.upd.title";
    public static final String AUTH_RESOURCE_ADD = "content.new";
    public static final String AUTH_RESOURCE_READ = "content.read";
    public static final String AUTH_RESOURCE_WRITE_ANY = "content.revise.any";
    public static final String AUTH_RESOURCE_WRITE_OWN = "content.revise.own";
    public static final String AUTH_RESOURCE_REMOVE_ANY = "content.delete.any";
    public static final String AUTH_RESOURCE_REMOVE_OWN = "content.delete.own";
    public static final String AUTH_RESOURCE_ALL_GROUPS = "content.all.groups";
    public static final String AUTH_GROUP_RESOURCE_READ = "content.read_group_resources";
    public static final String AUTH_DROPBOX_OWN = "dropbox.own";
    public static final String AUTH_DROPBOX_MAINTAIN = "dropbox.maintain";
    public static final String AUTH_RESOURCE_HIDDEN = "content.hidden";
    public static final String PROP_ALTERNATE_REFERENCE = "sakai:reference-root";
    public static final String PROP_DROPBOX_CHANGE_TIMESTAMP = "sakai:dropbox_change_timestamp";
    public static final int MAXIMUM_RESOURCE_ID_LENGTH = 247;
    public static final int MAXIMUM_ATTEMPTS_FOR_UNIQUENESS = 100;
    public static final int MAXIMUM_PAGE_SIZE = 1028;
    public static final int CONTENT_RESOURCE_PRIORITY_OFFSET = 0xFFFFFFF;
    public static final String ATTACHMENTS_COLLECTION = "/attachment/";
    public static final String COLLECTION_USER = "/user/";
    public static final String COLLECTION_SITE = "/group/";
    public static final String COLLECTION_DROPBOX = "/group-user/";
    public static final String COLLECTION_PUBLIC = "/public/";
    public static final String COLLECTION_PRIVATE = "/private/";
    public static final String COLLECTION_MELETE_DOCS = "/meleteDocs/";
    public static final Set<String> ROOT_COLLECTIONS = new TreeSet<String>();
    public static final String RESOURCES_ZIP_ENABLE = "content.zip.enabled";
    public static final String RESOURCES_ZIP_EXPAND_MAX = "content.zip.expand.maxfiles";
    public static final String RESOURCES_ZIP_ENABLE_EXPAND = "content.zip.expand.enabled";
    public static final String RESOURCES_ZIP_ENABLE_COMPRESS = "content.zip.compress.enabled";
    public static final String ID_LENGTH_EXCEPTION = "id_length_exception";

    public String getUuid(String var1);

    public void setUuid(String var1, String var2) throws IdInvalidException;

    public String resolveUuid(String var1);

    public boolean allowAddCollection(String var1);

    public ContentCollection addCollection(String var1, ResourceProperties var2) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException;

    public ContentCollection addCollection(String var1, ResourceProperties var2, Collection<String> var3) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException;

    public ContentCollection addCollection(String var1, ResourceProperties var2, Collection<String> var3, boolean var4, Time var5, Time var6) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException;

    public ContentCollectionEdit addCollection(String var1) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException;

    public boolean allowGetCollection(String var1);

    public void checkCollection(String var1) throws IdUnusedException, TypeException, PermissionException;

    public ContentCollection getCollection(String var1) throws IdUnusedException, TypeException, PermissionException;

    public int getCollectionSize(String var1) throws IdUnusedException, TypeException, PermissionException;

    public List getAllEntities(String var1);

    public List<ContentResource> getAllResources(String var1);

    public List getAllDeletedResources(String var1);

    public boolean allowUpdateCollection(String var1);

    public ContentCollectionEdit editCollection(String var1) throws IdUnusedException, TypeException, PermissionException, InUseException;

    public boolean allowRemoveCollection(String var1);

    public void removeCollection(String var1) throws IdUnusedException, TypeException, PermissionException, InUseException, ServerOverloadException;

    public void removeCollection(ContentCollectionEdit var1) throws TypeException, PermissionException, InconsistentException, ServerOverloadException;

    public void commitCollection(ContentCollectionEdit var1);

    public void cancelCollection(ContentCollectionEdit var1);

    public boolean allowAddResource(String var1);

    public ContentResource addResource(String var1, String var2, byte[] var3, ResourceProperties var4, int var5) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, InputStream var3, ResourceProperties var4, int var5) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, int var3, String var4, byte[] var5, ResourceProperties var6, int var7) throws PermissionException, IdUniquenessException, IdLengthException, IdInvalidException, InconsistentException, IdLengthException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, byte[] var3, ResourceProperties var4, Collection<String> var5, int var6) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, InputStream var3, ResourceProperties var4, Collection var5, int var6) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, int var3, String var4, byte[] var5, ResourceProperties var6, Collection<String> var7, int var8) throws PermissionException, IdUniquenessException, IdLengthException, IdInvalidException, InconsistentException, IdLengthException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, int var3, String var4, byte[] var5, ResourceProperties var6, Collection<String> var7, boolean var8, Time var9, Time var10, int var11) throws PermissionException, IdUniquenessException, IdLengthException, IdInvalidException, InconsistentException, IdLengthException, OverQuotaException, ServerOverloadException;

    public ContentResource addResource(String var1, String var2, int var3, String var4, InputStream var5, ResourceProperties var6, Collection var7, boolean var8, Time var9, Time var10, int var11) throws PermissionException, IdUniquenessException, IdLengthException, IdInvalidException, InconsistentException, IdLengthException, OverQuotaException, ServerOverloadException;

    public ContentResourceEdit addResource(String var1) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, ServerOverloadException;

    public boolean allowAddAttachmentResource();

    public boolean isAttachmentResource(String var1);

    public ContentResource addAttachmentResource(String var1, String var2, byte[] var3, ResourceProperties var4) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, OverQuotaException, ServerOverloadException;

    public ContentResource addAttachmentResource(String var1, String var2, InputStream var3, ResourceProperties var4) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, OverQuotaException, ServerOverloadException;

    public ContentResource addAttachmentResource(String var1, String var2, String var3, String var4, byte[] var5, ResourceProperties var6) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, OverQuotaException, ServerOverloadException;

    public ContentResource addAttachmentResource(String var1, String var2, String var3, String var4, InputStream var5, ResourceProperties var6) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, OverQuotaException, ServerOverloadException;

    public ContentResourceEdit addAttachmentResource(String var1) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, ServerOverloadException;

    public boolean allowUpdateResource(String var1);

    public ContentResource updateResource(String var1, String var2, byte[] var3) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException, ServerOverloadException;

    public ContentResourceEdit editResource(String var1) throws PermissionException, IdUnusedException, TypeException, InUseException;

    public boolean allowGetResource(String var1);

    public void checkResource(String var1) throws PermissionException, IdUnusedException, TypeException;

    public ContentResource getResource(String var1) throws PermissionException, IdUnusedException, TypeException;

    public boolean allowRemoveResource(String var1);

    public void removeResource(String var1) throws PermissionException, IdUnusedException, TypeException, InUseException;

    public void removeResource(ContentResourceEdit var1) throws PermissionException;

    public boolean allowRename(String var1, String var2);

    public String rename(String var1, String var2) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException, InconsistentException, IdUsedException, ServerOverloadException;

    public boolean allowCopy(String var1, String var2);

    public String copy(String var1, String var2) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException, IdUsedException, ServerOverloadException;

    public String copyIntoFolder(String var1, String var2) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException, IdUsedException, ServerOverloadException, InconsistentException, IdLengthException, IdUniquenessException;

    public String moveIntoFolder(String var1, String var2) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException, IdUsedException, InconsistentException, ServerOverloadException;

    public void commitResource(ContentResourceEdit var1) throws OverQuotaException, ServerOverloadException, VirusFoundException;

    public void commitResource(ContentResourceEdit var1, int var2) throws OverQuotaException, ServerOverloadException, VirusFoundException;

    public void cancelResource(ContentResourceEdit var1);

    public boolean allowGetProperties(String var1);

    public ResourceProperties getProperties(String var1) throws PermissionException, IdUnusedException;

    public boolean allowAddProperty(String var1);

    public ResourceProperties addProperty(String var1, String var2, String var3) throws PermissionException, IdUnusedException, TypeException, InUseException, ServerOverloadException;

    public boolean allowRemoveProperty(String var1);

    public ResourceProperties removeProperty(String var1, String var2) throws PermissionException, IdUnusedException, TypeException, InUseException, ServerOverloadException;

    public String getUrl(String var1);

    public String getUrl(String var1, String var2);

    public String getReference(String var1);

    public String getContainingCollectionId(String var1);

    public int getDepth(String var1, String var2);

    public boolean isRootCollection(String var1);

    public ResourcePropertiesEdit newResourceProperties();

    public String getSiteCollection(String var1);

    public String archiveResources(List var1, Document var2, Stack var3, String var4);

    public Collection getLocks(String var1);

    public void lockObject(String var1, String var2, String var3, boolean var4);

    public void removeLock(String var1, String var2);

    public boolean isLocked(String var1);

    public boolean containsLockedNode(String var1);

    public void removeAllLocks(String var1);

    public boolean isPubView(String var1);

    public boolean isInheritingPubView(String var1);

    public void setPubView(String var1, boolean var2);

    public List<ContentResource> findResources(String var1, String var2, String var3, Set<String> var4);

    public List<ContentResource> findResources(String var1, String var2, String var3);

    public Map<String, String> getCollectionMap();

    public void eliminateDuplicates(Collection<String> var1);

    public void createDropboxCollection();

    public void createDropboxCollection(String var1);

    public String getDropboxCollection();

    public void createIndividualDropbox(String var1);

    public String getDropboxCollection(String var1);

    public boolean isDropboxMaintainer();

    public boolean isDropboxMaintainer(String var1);

    public String getDropboxDisplayName();

    public String getDropboxDisplayName(String var1);

    public boolean isInDropbox(String var1);

    public Comparator newContentHostingComparator(String var1, boolean var2);

    public Collection getGroupsWithReadAccess(String var1);

    public Collection getGroupsWithAddPermission(String var1);

    public Collection getGroupsWithRemovePermission(String var1);

    public boolean isShortRefs();

    public boolean isAvailabilityEnabled();

    public boolean isAvailable(String var1);

    public boolean isSortByPriorityEnabled();

    public boolean usingResourceTypeRegistry();

    public boolean isCollection(String var1);

    public ContentResourceEdit addResource(String var1, String var2, String var3, int var4) throws PermissionException, IdUniquenessException, IdLengthException, IdInvalidException, IdUnusedException, OverQuotaException, ServerOverloadException;

    public ContentCollectionEdit addCollection(String var1, String var2) throws PermissionException, IdUnusedException, IdUsedException, IdLengthException, IdInvalidException, TypeException;

    public long getQuota(ContentCollection var1);

    public boolean isContentHostingHandlersEnabled();

    public String getIndividualDropboxId(String var1);

    public Collection<ContentResource> getResourcesOfType(String var1, int var2, int var3);

    public Collection<ContentResource> getContextResourcesOfType(String var1, Set<String> var2);

    public void restoreResource(String var1) throws PermissionException, IdUsedException, IdUnusedException, IdInvalidException, InconsistentException, OverQuotaException, ServerOverloadException, TypeException, InUseException;

    public void removeDeletedResource(String var1) throws PermissionException, IdUnusedException, TypeException, InUseException;

    public void expandZippedResource(String var1) throws Exception;
}

