/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;

public class SakaiPoolableConnectionFactory
extends PoolableConnectionFactory {
    protected boolean m_rollbackOnReturn = false;
    protected static final Log M_log = LogFactory.getLog(SakaiPoolableConnectionFactory.class);

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, defaultTransactionIsolation);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, config);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, AbandonedConfig config, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, defaultTransactionIsolation, config);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, defaultTransactionIsolation, defaultCatalog, config);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public SakaiPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config, boolean rollbackOnReturn) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, defaultTransactionIsolation, defaultCatalog, config);
        this.m_rollbackOnReturn = rollbackOnReturn;
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (this.m_rollbackOnReturn && !conn.getAutoCommit() && !conn.isReadOnly()) {
                RuntimeException e = new RuntimeException("Automatic Transaction Rollback");
                M_log.error((Object)"Transaction RolledBack!", (Throwable)e);
                conn.rollback();
            }
            conn.clearWarnings();
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public void activateObject(Object obj) throws Exception {
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).activate();
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (conn.getAutoCommit() != this._defaultAutoCommit) {
                conn.setAutoCommit(this._defaultAutoCommit);
            }
            if (this._defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this._defaultTransactionIsolation) {
                conn.setTransactionIsolation(this._defaultTransactionIsolation);
            }
            if (this._defaultReadOnly != null && conn.isReadOnly() != this._defaultReadOnly.booleanValue()) {
                conn.setReadOnly(this._defaultReadOnly);
            }
            if (this._defaultCatalog != null && !this._defaultCatalog.equals(conn.getCatalog())) {
                conn.setCatalog(this._defaultCatalog);
            }
        }
    }
}

