/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.Rythm;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;

public class RenderInheritedParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RENDER_INHERITED;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String section;
                Regex r = RenderInheritedParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @inherited statement. Correct usage: @inherited()", new Object[0]);
                }
                if (null == (section = ctx.currentSection())) {
                    this.raiseParseException("@inherited() shall be used only within a @section context", new Object[0]);
                }
                String matched = r.stringMatched();
                this.step(matched.length());
                return new RenderInheritedToken(section, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))\\s*)";
    }

    public static void main(String[] args) {
        Regex r = new RenderInheritedParser().reg(Rythm.INSTANCE);
        if (r.search("@renderBody(ab: 1, foo.bar())")) {
            // empty if block
        }
        RenderInheritedParser.p(r, 6);
    }

    private static class RenderInheritedToken
    extends CodeToken {
        private String section;

        RenderInheritedToken(String section, IContext ctx) {
            super("", ctx);
            this.section = section;
        }

        @Override
        public void output() {
            this.p2t("__pLayoutSectionInherited(\"").p(this.section).p("\");\n");
        }
    }
}

