/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import com.stevesoft.pat.Regex;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IExpressionProcessor;
import org.rythmengine.internal.IJavaExtension;
import org.rythmengine.internal.parser.build_in.BlockToken;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class Token
extends TextBuilder {
    public static final Token EMPTY_TOKEN = new Token();
    public static final Token EMPTY_TOKEN2 = new Token();
    protected static final ILogger logger = Logger.get(Token.class);
    protected String s;
    protected IContext ctx;
    protected int line;
    protected boolean disableCompactMode = false;
    public boolean removeNextLineBreak = false;
    private RythmEngine engine = null;
    private Iterable<IJavaExtension> javaExtensions = null;
    private boolean transformEnabled = true;
    private boolean ok = true;
    private static final Regex R_ = new Regex("^\\s*(?@())\\s*$");
    private static final Pattern P_ELVIS = Pattern.compile("(.*)(\\s*\\?\\s*:\\s*.*)");
    private boolean dynaExp = false;
    private static final Pattern P_C1 = Pattern.compile("\\n+", 32);
    private static final Pattern P_C2 = Pattern.compile("[ \\t\\x0B\\f]+", 32);
    private static final Pattern P_C3 = Pattern.compile("[ \\t\\x0B\\f]+\\n", 32);
    private static final Pattern P_C4 = Pattern.compile("\\n[ \\t\\x0B\\f]+", 32);

    private Token() {
    }

    public boolean removeLeadingLineBreak() {
        return false;
    }

    protected boolean compactMode() {
        if (this.disableCompactMode) {
            return false;
        }
        return null == this.ctx ? true : this.ctx.compactMode();
    }

    protected final void fail() {
        this.ok = false;
    }

    protected Token(String s, TextBuilder caller) {
        this(s, caller, false);
    }

    protected Token(String s, TextBuilder caller, boolean disableCompactMode) {
        super(caller);
        this.s = this.checkDynaExp(s);
        this.line = -1;
        this.disableCompactMode = disableCompactMode;
        this.engine = Rythm.engine();
        this.javaExtensions = this.engine.extensionManager().javaExtensions();
        RythmConfiguration conf = this.engine.conf();
        this.transformEnabled = conf.transformEnabled();
    }

    public Token(String s, IContext context) {
        this(s, context, false);
    }

    public Token(String s, IContext context, boolean disableCompactMode) {
        super(null == context ? null : context.getCodeBuilder());
        this.s = s;
        this.ctx = context;
        this.line = null == context ? -1 : context.currentLine();
        this.engine = null == this.ctx ? Rythm.engine() : this.ctx.getEngine();
        this.javaExtensions = this.engine.extensionManager().javaExtensions();
        this.disableCompactMode = disableCompactMode;
        RythmConfiguration conf = this.engine.conf();
        this.transformEnabled = conf.transformEnabled();
    }

    public boolean test(String line) {
        return true;
    }

    public boolean isOk() {
        return this.ok;
    }

    @Override
    public final Token build() {
        if (this.ok) {
            this.output();
        } else {
            this.pp(this.s);
        }
        return this;
    }

    public final Token build(IContext includeCtx) {
        IContext ctx0 = this.ctx;
        this.ctx = includeCtx;
        try {
            this.build();
        }
        finally {
            this.ctx = ctx0;
        }
        return this;
    }

    protected void output() {
        if (null == this.s || "".equals(this.s)) {
            return;
        }
        this.pp(this.s);
    }

    private static String stripOuterBrackets(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        if (R_.search(s)) {
            s = R_.stringMatched();
            s = s.substring(1);
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String[] stripElvis(String s) {
        if (S.isEmpty(s)) {
            return new String[]{"", ""};
        }
        Matcher m = P_ELVIS.matcher(s = Token.stripOuterBrackets(s));
        if (m.matches()) {
            String s0 = m.group(1);
            String s1 = m.group(2);
            return new String[]{s0, s1};
        }
        return new String[]{s, ""};
    }

    private static String processElvis(String s) {
        if (S.isEmpty(s)) {
            return s;
        }
        String[] sa = Token.stripElvis(s);
        s = sa[0];
        String elvis = sa[1];
        if (S.isEmpty(elvis)) {
            return s;
        }
        elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
        return String.format("((__isDefVal(%1$s)) ? %2$s : %1$s)", s, elvis);
    }

    protected final void outputExpression(List<String> nullValueTester) {
        int size = nullValueTester.size();
        for (String s : nullValueTester) {
            this.p("if (null != ").p(s).p(") {\n\t");
        }
        this.outputExpression();
        this.pn();
        for (int i = 0; i < size; ++i) {
            this.pn("}");
        }
    }

    protected final void outputExpression() {
        this.outputExpression(true);
    }

    protected final void outputExpression(boolean needsPrint) {
        if (S.isEmpty(this.s)) {
            return;
        }
        String s = this.processExtensions(false);
        if (needsPrint) {
            this.p("\ntry{pe(").p(s).p(");} catch (RuntimeException e) {__handleTemplateExecutionException(e);} ");
        } else {
            this.p("\ntry{").p(s).p(";} catch (RuntimeException e) {__handleTemplateExecutionException(e);} ");
        }
        this.pline();
    }

    private String evalStr(String s) {
        if (!this.dynaExp) {
            return s;
        }
        return "__eval(\"" + S.escapeJava(s) + "\")";
    }

    private String checkDynaExp(String s) {
        if (S.empty(s)) {
            return s;
        }
        boolean b = s.endsWith("@");
        if (b) {
            this.dynaExp = true;
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String processExtensions(boolean stripExtensions) {
        boolean hasJavaExtension;
        boolean matched;
        if (!this.transformEnabled) {
            return this.evalStr(this.s);
        }
        RythmEngine engine = this.engine;
        String s0 = this.s;
        this.s = Token.stripOuterBrackets(this.s);
        this.s = this.checkDynaExp(this.s);
        boolean outerBracketsStripped = this.s != s0;
        class Pair {
            IJavaExtension extension;
            String signature;

            Pair(IJavaExtension e, String s) {
                this.extension = e;
                this.signature = s;
            }
        }
        Stack<Pair> allMatched = new Stack<Pair>();
        do {
            matched = false;
            for (IJavaExtension e : this.javaExtensions) {
                Pattern p = e.pattern1();
                Matcher m = p.matcher(this.s);
                if (!m.matches()) continue;
                matched = true;
                String signature = null;
                if (!(e instanceof IJavaExtension.VoidParameterExtension) && null == (signature = m.group(1))) {
                    signature = m.group(2);
                }
                m = e.pattern2().matcher(this.s);
                this.s = m.replaceAll("");
                allMatched.push(new Pair(e, signature));
            }
        } while (matched);
        boolean bl = hasJavaExtension = !allMatched.empty();
        if (hasJavaExtension) {
            this.s = Token.processElvis(this.s);
            this.s = this.evalStr(this.s);
            while (!allMatched.empty()) {
                Pair p = (Pair)allMatched.pop();
                if (stripExtensions) continue;
                this.s = p.extension.extend(this.s, p.signature);
            }
        } else {
            boolean matched2;
            String[] sa = Token.stripElvis(this.s);
            this.s = sa[0];
            String elvis = sa[1];
            do {
                matched2 = false;
                for (IJavaExtension e : this.javaExtensions) {
                    Pattern p = e.pattern1();
                    Matcher m = p.matcher(this.s);
                    if (!m.matches()) continue;
                    matched2 = true;
                    String signature = e instanceof IJavaExtension.VoidParameterExtension ? null : m.group(1);
                    m = e.pattern2().matcher(this.s);
                    this.s = m.replaceAll("");
                    allMatched.push(new Pair(e, signature));
                }
            } while (matched2);
            this.s = this.evalStr(this.s);
            while (!stripExtensions && !allMatched.empty()) {
                this.s = Token.processElvis(this.s);
                Pair p = (Pair)allMatched.pop();
                this.s = p.extension.extend(this.s, p.signature);
            }
            if (!S.isEmpty(elvis)) {
                elvis = elvis.replaceFirst("^\\s*\\?\\s*:\\s*", "");
                this.s = String.format("((__isDefVal(%1$s)) ? %2$s : %1$s)", this.s, elvis);
            }
        }
        if (outerBracketsStripped) {
            this.s = String.format("(%s)", this.s);
        }
        this.s = this.compact(this.s);
        for (IExpressionProcessor p : engine.extensionManager().expressionProcessors()) {
            String result = p.process(this.s, this);
            if (null == result) continue;
            return S.removeAllLineBreaks(result);
        }
        return this.s;
    }

    public Token ptline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t").p(s);
        this.pline();
        return this;
    }

    public Token p2tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p3tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p4tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token p5tline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p("\t\t\t\t\t").p(s);
        this.pline();
        return this;
    }

    public Token pline(String msg, Object ... args) {
        String s = String.format(msg, args);
        this.p(s);
        this.pline();
        return this;
    }

    public Token pline() {
        this.p(" //line: ").pn(this.line);
        return this;
    }

    protected void pp(String s) {
        s = this.compact(s);
        s = this.compactMode() ? s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"") : s.replaceAll("(\\r?\\n)", "\\\\n").replaceAll("\"", "\\\\\"");
        this.p("p(\"").p(s).p("\");");
        this.pline();
    }

    @Override
    public Token clone(TextBuilder caller) {
        return (Token)super.clone(caller);
    }

    private static String compact_(String s) {
        if (s.matches("(\\n\\r|\\r\\n|[\\r\\n])+")) {
            return "\n";
        }
        Matcher m = P_C1.matcher(s);
        s = m.replaceAll("\n");
        m = P_C2.matcher(s);
        s = m.replaceAll(" ");
        m = P_C3.matcher(s);
        s = m.replaceAll("\n");
        m = P_C4.matcher(s);
        s = m.replaceAll("\n");
        return s;
    }

    private static String processLineBreaks_(String s) {
        return s;
    }

    public void compact() {
        this.s = this.compact(this.s);
    }

    protected String compact(String s) {
        return this.compactMode() ? Token.compact_(s) : Token.processLineBreaks_(s);
    }

    public static String processRythmExpression(String s, IContext ctx) {
        Token token = new Token(s, ctx);
        return token.processExtensions(false);
    }

    public static String stripJavaExtension(String s, IContext ctx) {
        Token token = new Token(s, ctx);
        return token.processExtensions(true);
    }

    public static class StringToken
    extends Token {
        public String constId = null;

        public StringToken(String s, IContext ctx) {
            super(s, ctx);
        }

        public StringToken(String s, IContext context, boolean disableCompactMode) {
            super(s, context, disableCompactMode);
        }

        public StringToken mergeWith(BlockToken.LiteralBlock block) {
            StringToken merged = new StringToken(this.s, this.ctx, this.disableCompactMode);
            merged.line = block.line;
            merged.s = merged.s + "{";
            return merged;
        }

        public StringToken mergeWith(StringToken st) {
            StringToken merged = new StringToken(this.s, this.ctx, this.disableCompactMode);
            merged.line = st.line;
            String s = st.s;
            s = st.compact(s);
            merged.s = merged.s + s;
            return merged;
        }

        @Override
        public boolean removeLeadingLineBreak() {
            this.s = this.s.replaceFirst("^[ \\t\\x0B\\f]*\\n", "");
            return true;
        }

        public int getLineNo() {
            return this.line;
        }

        public String s() {
            return this.s;
        }

        @Override
        public String toString() {
            return this.s;
        }

        @Override
        protected void output() {
            RythmEngine.OutputMode mode = RythmEngine.outputMode();
            if (mode.writeOutput()) {
                if (null == this.constId) {
                    return;
                }
                this.p("p(").p(this.constId).p(");");
                this.pline();
            } else {
                super.output();
            }
        }

        public int hashCode() {
            return this.s.hashCode() + (this.compactMode() ? 1 : -1);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof StringToken) {
                StringToken st = (StringToken)obj;
                return st.compactMode() == this.compactMode() && st.s.equals(this.s);
            }
            return false;
        }

        public boolean empty() {
            return S.empty(this.s);
        }
    }
}

