/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.cache;

import java.io.Serializable;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.rythmengine.extension.ICacheService;
import org.rythmengine.internal.RythmThreadFactory;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.HashCode;
import org.rythmengine.utils.S;

public class SimpleCacheService
implements ICacheService {
    private static final ILogger logger = Logger.get(SimpleCacheService.class);
    public static final SimpleCacheService INSTANCE = new SimpleCacheService();
    private ScheduledExecutorService scheduler = null;
    private ConcurrentHashMap<String, Item> cache_ = new ConcurrentHashMap();
    private Queue<Item> items_ = new PriorityQueue<Item>();
    private int defaultTTL = 60;

    private SimpleCacheService() {
        this.startup();
    }

    @Override
    public void put(String key, Serializable value, int ttl) {
        Item item;
        if (null == key) {
            throw new NullPointerException();
        }
        if (0 >= ttl) {
            ttl = this.defaultTTL;
        }
        if (null == (item = this.cache_.get(key))) {
            Item newItem = new Item(key, value, ttl);
            item = this.cache_.putIfAbsent(key, newItem);
            if (null != item) {
                item.value = value;
                item.ttl = ttl;
            } else if (!this.items_.offer(newItem)) {
                throw new RuntimeException("oops, something is wrong");
            }
        } else {
            item.value = value;
            item.ttl = ttl;
        }
    }

    @Override
    public void put(String key, Serializable value) {
        this.put(key, value, this.defaultTTL);
    }

    @Override
    public Serializable remove(String key) {
        Item item = this.cache_.remove(key);
        return null == item ? null : item.value;
    }

    @Override
    public void evict(String key) {
        this.cache_.remove(key);
    }

    @Override
    public void clear() {
        this.cache_.clear();
        this.items_.clear();
    }

    @Override
    public Serializable get(String key) {
        Item item = this.cache_.get(key);
        return null == item ? null : item.value;
    }

    @Override
    public boolean contains(String key) {
        return this.cache_.containsKey(key);
    }

    @Override
    public void setDefaultTTL(int ttl) {
        if (ttl == 0) {
            throw new IllegalArgumentException("time to live value couldn't be zero");
        }
        this.defaultTTL = ttl;
    }

    @Override
    public void shutdown() {
        this.clear();
        if (null != this.scheduler) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    @Override
    public void startup() {
        if (null == this.scheduler) {
            this.scheduler = new ScheduledThreadPoolExecutor(1, new TimerThreadFactory());
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Item item;
                    if (SimpleCacheService.this.items_.isEmpty()) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (logger.isTraceEnabled()) {
                        logger.trace(">>>>now:%s", now);
                    }
                    while (null != (item = (Item)SimpleCacheService.this.items_.peek())) {
                        long ts = item.ts + (long)item.ttl * 1000L;
                        if (ts < now + 50L) {
                            SimpleCacheService.this.items_.poll();
                            SimpleCacheService.this.cache_.remove(item.key);
                            if (!Logger.isTraceEnabled()) continue;
                            logger.trace("- %s at %s", item.key, ts);
                            continue;
                        }
                        if (!Logger.isTraceEnabled()) break;
                        logger.trace(">>>>ts:  %s", ts);
                        break;
                    }
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    private static class Item
    implements Comparable<Item> {
        String key;
        Serializable value;
        long ts;
        int ttl;

        Item(String key, Serializable value, int ttl) {
            this.key = key;
            this.value = value;
            this.ttl = ttl;
            this.ts = System.currentTimeMillis();
        }

        public int hashCode() {
            return HashCode.hc(this.ttl, this.key, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Item) {
                Item that = (Item)obj;
                if (that.ttl != this.ttl) {
                    return false;
                }
                String thisKey = this.key;
                String thatKey = that.key;
                if (!S.isEqual(thisKey, thatKey)) {
                    return false;
                }
                Serializable thatVal = that.value;
                Serializable thisVal = this.value;
                if (null == thatVal && null == thisVal) {
                    return true;
                }
                return null != thisVal ? thisVal.equals(thatVal) : thatVal.equals(thisVal);
            }
            return false;
        }

        @Override
        public int compareTo(Item that) {
            return this.ttl - that.ttl;
        }
    }

    private static class TimerThreadFactory
    extends RythmThreadFactory {
        private TimerThreadFactory() {
            super("rythm-timer");
        }
    }
}

