/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.query;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.rundeck.api.domain.RundeckExecution;

public class ExecutionQuery {
    private RundeckExecution.ExecutionStatus status;
    private String abortedby;
    private List<String> jobList;
    private List<String> jobIdList;
    private List<String> excludeJobList;
    private List<String> excludeJobIdList;
    private Date begin;
    private Date end;
    private String recent;
    private String job;
    private String jobExact;
    private String excludeJob;
    private String excludeJobExact;
    private String project;
    private String groupPath;
    private String groupPathExact;
    private String excludeGroupPath;
    private String excludeGroupPathExact;
    private String user;
    private String description;
    private Boolean adhoc;

    private ExecutionQuery() {
    }

    private ExecutionQuery(ExecutionQuery query) {
        this.status = query.getStatus();
        this.abortedby = query.getAbortedby();
        this.jobList = query.getJobList();
        this.jobIdList = query.getJobIdList();
        this.excludeJobList = query.getExcludeJobList();
        this.excludeJobIdList = query.getExcludeJobIdList();
        this.begin = query.getBegin();
        this.end = query.getEnd();
        this.recent = query.getRecent();
        this.job = query.getJob();
        this.jobExact = query.getJobExact();
        this.excludeJob = query.getExcludeJob();
        this.excludeJobExact = query.getExcludeJobExact();
        this.project = query.getProject();
        this.groupPath = query.getGroupPath();
        this.groupPathExact = query.getGroupPathExact();
        this.excludeGroupPath = query.getExcludeGroupPath();
        this.excludeGroupPathExact = query.getExcludeGroupPathExact();
        this.description = query.getDescription();
        this.user = query.getUser();
        this.adhoc = query.getAdhoc();
    }

    public boolean notBlank() {
        return null != this.status || !StringUtils.isBlank((String)this.abortedby) || !StringUtils.isBlank((String)this.recent) || !StringUtils.isBlank((String)this.job) || !StringUtils.isBlank((String)this.jobExact) || !StringUtils.isBlank((String)this.excludeJob) || !StringUtils.isBlank((String)this.excludeJobExact) || !StringUtils.isBlank((String)this.groupPath) || !StringUtils.isBlank((String)this.groupPathExact) || !StringUtils.isBlank((String)this.excludeGroupPath) || !StringUtils.isBlank((String)this.excludeGroupPathExact) || !StringUtils.isBlank((String)this.description) || null != this.adhoc || null != this.jobList && this.jobList.size() > 0 || null != this.jobIdList && this.jobIdList.size() > 0 || null != this.excludeJobList && this.excludeJobList.size() > 0 || null != this.excludeJobIdList && this.excludeJobIdList.size() > 0 || null != this.begin || null != this.end;
    }

    public RundeckExecution.ExecutionStatus getStatus() {
        return this.status;
    }

    public String getAbortedby() {
        return this.abortedby;
    }

    public List<String> getJobList() {
        return this.jobList;
    }

    public List<String> getExcludeJobList() {
        return this.excludeJobList;
    }

    public List<String> getExcludeJobIdList() {
        return this.excludeJobIdList;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public String getRecent() {
        return this.recent;
    }

    public String getJob() {
        return this.job;
    }

    public String getJobExact() {
        return this.jobExact;
    }

    public String getProject() {
        return this.project;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    public String getGroupPathExact() {
        return this.groupPathExact;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getJobIdList() {
        return this.jobIdList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUser() {
        return this.user;
    }

    public Boolean getAdhoc() {
        return this.adhoc;
    }

    public String getExcludeJob() {
        return this.excludeJob;
    }

    public String getExcludeJobExact() {
        return this.excludeJobExact;
    }

    public String getExcludeGroupPath() {
        return this.excludeGroupPath;
    }

    public String getExcludeGroupPathExact() {
        return this.excludeGroupPathExact;
    }

    public static class Builder {
        ExecutionQuery query = new ExecutionQuery();

        public Builder status(RundeckExecution.ExecutionStatus status) {
            this.query.status = status;
            return this;
        }

        public Builder abortedby(String abortedby) {
            this.query.abortedby = abortedby;
            return this;
        }

        public Builder jobList(List<String> list) {
            this.query.jobList = list;
            return this;
        }

        public Builder jobIdList(List<String> list) {
            this.query.jobIdList = list;
            return this;
        }

        public Builder excludeJobList(List<String> list) {
            this.query.excludeJobList = list;
            return this;
        }

        public Builder excludeJobIdList(List<String> list) {
            this.query.excludeJobIdList = list;
            return this;
        }

        public Builder begin(Date begin) {
            this.query.begin = begin;
            return this;
        }

        public Builder end(Date end) {
            this.query.end = end;
            return this;
        }

        public Builder recent(String recent) {
            this.query.recent = recent;
            return this;
        }

        public Builder job(String job) {
            this.query.job = job;
            return this;
        }

        public Builder jobExact(String exact) {
            this.query.jobExact = exact;
            return this;
        }

        public Builder excludeJob(String job) {
            this.query.excludeJob = job;
            return this;
        }

        public Builder excludeJobExact(String exact) {
            this.query.excludeJobExact = exact;
            return this;
        }

        public Builder project(String project) {
            this.query.project = project;
            return this;
        }

        public Builder groupPath(String path) {
            this.query.groupPath = path;
            return this;
        }

        public Builder groupPathExact(String exact) {
            this.query.groupPathExact = exact;
            return this;
        }

        public Builder excludeGroupPath(String excludeGroupPath) {
            this.query.excludeGroupPath = excludeGroupPath;
            return this;
        }

        public Builder excludeGroupPathExact(String excludeGroupPathExact) {
            this.query.excludeGroupPathExact = excludeGroupPathExact;
            return this;
        }

        public Builder description(String description) {
            this.query.description = description;
            return this;
        }

        public Builder user(String user) {
            this.query.user = user;
            return this;
        }

        public Builder adhoc(Boolean adhoc) {
            this.query.adhoc = adhoc;
            return this;
        }

        public ExecutionQuery build() {
            return new ExecutionQuery(this.query);
        }
    }
}

