/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.List;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckJobsImportResult;
import org.rundeck.api.parser.BaseXpathParser;
import org.rundeck.api.parser.JobParser;

public class JobsImportResultParser
extends BaseXpathParser<RundeckJobsImportResult> {
    public JobsImportResultParser(String xpath) {
        super(xpath);
    }

    @Override
    public RundeckJobsImportResult parse(Node resultNode) {
        List failedJobsNodes;
        List skippedJobsNodes;
        RundeckJobsImportResult result = new RundeckJobsImportResult();
        List succeededJobsNodes = resultNode.selectNodes("succeeded/job");
        if (succeededJobsNodes != null) {
            for (Node succeededJobNode : succeededJobsNodes) {
                RundeckJob job = (RundeckJob)new JobParser().parseXmlNode(succeededJobNode);
                result.addSucceededJob(job);
            }
        }
        if ((skippedJobsNodes = resultNode.selectNodes("skipped/job")) != null) {
            for (Node skippedJobNode : skippedJobsNodes) {
                RundeckJob job = (RundeckJob)new JobParser().parseXmlNode(skippedJobNode);
                result.addSkippedJob(job);
            }
        }
        if ((failedJobsNodes = resultNode.selectNodes("failed/job")) != null) {
            for (Node failedJobNode : failedJobsNodes) {
                RundeckJob job = (RundeckJob)new JobParser().parseXmlNode(failedJobNode);
                result.addFailedJob(job, failedJobNode.valueOf("error"));
            }
        }
        return result;
    }
}

