/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckJobDelete;
import org.rundeck.api.domain.RundeckJobDeleteBulk;
import org.rundeck.api.parser.BaseXpathParser;
import org.rundeck.api.parser.DeleteParser;

public class BulkDeleteParser
extends BaseXpathParser<RundeckJobDeleteBulk> {
    public BulkDeleteParser(String xpath) {
        super(xpath);
    }

    @Override
    public RundeckJobDeleteBulk parse(Node subnode) {
        ArrayList<RundeckJobDelete> deletes = new ArrayList<RundeckJobDelete>();
        List results = subnode.selectNodes("(succeeded|failed)/deleteJobResult");
        DeleteParser parser = new DeleteParser();
        if (null != results && results.size() > 0) {
            for (Object o : results) {
                deletes.add((RundeckJobDelete)parser.parseXmlNode((Node)o));
            }
        }
        String requestcount = StringUtils.trimToNull((String)subnode.valueOf("@requestCount"));
        String allsuccessString = StringUtils.trimToNull((String)subnode.valueOf("@allsuccessful"));
        int count = 0;
        boolean allsuccess = false;
        if (null != requestcount) {
            try {
                count = Integer.parseInt(requestcount);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (null != allsuccessString) {
            allsuccess = Boolean.parseBoolean(allsuccessString);
        }
        return new RundeckJobDeleteBulk(deletes, count, allsuccess);
    }
}

