/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.robolectric.util.Logger;
import org.robolectric.util.OsUtil;

public class TempDirectory {
    private static final int DELETE_THREAD_POOL_SIZE = 5;
    private static final String TEMP_DIR_PREFIX = "robolectric-";
    static final String OBSOLETE_MARKER_FILE_NAME = ".obsolete";
    private static final Set<TempDirectory> tempDirectoriesToDelete = new HashSet<TempDirectory>();
    private static final Set<Path> obsoleteTempDirectoriesToDelete = Collections.synchronizedSet(new HashSet());
    private final Path basePath;

    public TempDirectory() {
        this("test-dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempDirectory(String name) {
        try {
            this.basePath = Files.createTempDirectory(TEMP_DIR_PREFIX + name, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set<TempDirectory> set = tempDirectoriesToDelete;
        synchronized (set) {
            if (tempDirectoriesToDelete.isEmpty()) {
                Runtime.getRuntime().addShutdownHook(new Thread(TempDirectory::clearAllDirectories));
            }
            tempDirectoriesToDelete.add(this);
        }
    }

    public Path getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearAllDirectories() {
        ExecutorService deletionExecutorService = Executors.newFixedThreadPool(5);
        Set<Object> set = tempDirectoriesToDelete;
        synchronized (set) {
            for (TempDirectory undeletedDirectory : tempDirectoriesToDelete) {
                deletionExecutorService.execute(undeletedDirectory::destroy);
            }
        }
        if (OsUtil.isWindows()) {
            set = obsoleteTempDirectoriesToDelete;
            synchronized (set) {
                for (Path obsoletePath : obsoleteTempDirectoriesToDelete) {
                    deletionExecutorService.execute(() -> TempDirectory.destroyObsoleteTempDirectory(obsoletePath));
                }
            }
        }
        deletionExecutorService.shutdown();
        try {
            deletionExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            deletionExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Path createFile(String name, String contents) {
        Path path = this.basePath.resolve(name);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            out.write(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("failed writing to " + name, e);
        }
        return path;
    }

    public Path create(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public Path createIfNotExists(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public void destroy() {
        try {
            TempDirectory.clearDirectory(this.basePath);
            Files.delete(this.basePath);
        }
        catch (IOException e) {
            if (OsUtil.isWindows()) {
                this.createFile(OBSOLETE_MARKER_FILE_NAME, "");
            }
            Logger.error("Failed to destroy temp directory", e);
        }
    }

    private static void clearDirectory(final Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @Nonnull
            public FileVisitResult visitFile(Path file, @Nonnull BasicFileAttributes attrs) throws IOException {
                if (!OsUtil.isWindows() || !file.getFileName().toString().equals(TempDirectory.OBSOLETE_MARKER_FILE_NAME)) {
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            @Nonnull
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void findObsoleteWindowsTempDirectoriesInBackground() {
        Thread thread = new Thread(TempDirectory::collectObsoleteWindowsTempDirectories);
        thread.setDaemon(true);
        thread.start();
    }

    @VisibleForTesting
    static void collectObsoleteWindowsTempDirectories() {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpDir, "robolectric-*");){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0]) || !Files.exists(entry.resolve(OBSOLETE_MARKER_FILE_NAME), new LinkOption[0])) continue;
                obsoleteTempDirectoriesToDelete.add(entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void destroyObsoleteTempDirectory(Path basePath) {
        try {
            TempDirectory.clearDirectory(basePath);
            Files.deleteIfExists(basePath.resolve(OBSOLETE_MARKER_FILE_NAME));
            Files.delete(basePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        if (OsUtil.isWindows()) {
            TempDirectory.findObsoleteWindowsTempDirectoriesInBackground();
        }
    }
}

