/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.util.Clock;

public class PerfStatsCollector {
    private static final PerfStatsCollector INSTANCE = new PerfStatsCollector();
    private final Clock clock;
    private final Map<Class<?>, Object> metadata = new HashMap();
    private final Map<MetricKey, Metric> metricMap = new HashMap<MetricKey, Metric>();
    private boolean enabled = true;

    public PerfStatsCollector() {
        this(System::nanoTime);
    }

    PerfStatsCollector(Clock clock) {
        this.clock = clock;
    }

    public static PerfStatsCollector getInstance() {
        return INSTANCE;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public Event startEvent(String eventName) {
        return new Event(eventName);
    }

    public <T, E extends Exception> T measure(String eventName, ThrowingSupplier<T, E> supplier) throws E {
        boolean success = true;
        Event event = this.startEvent(eventName);
        try {
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            event.finished(success);
        }
    }

    public <E extends Exception> void measure(String eventName, ThrowingRunnable<E> runnable) throws E {
        boolean success = true;
        Event event = this.startEvent(eventName);
        try {
            runnable.run();
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            event.finished(success);
        }
    }

    public synchronized Collection<Metric> getMetrics() {
        return new ArrayList<Metric>(this.metricMap.values());
    }

    public synchronized <T> void putMetadata(Class<T> metadataClass, T metadata) {
        if (!this.enabled) {
            return;
        }
        this.metadata.put(metadataClass, metadata);
    }

    public synchronized Metadata getMetadata() {
        return new Metadata(this.metadata);
    }

    public void reset() {
        this.metadata.clear();
        this.metricMap.clear();
    }

    public static class Metadata {
        private final Map<Class<?>, Object> metadata;

        Metadata(Map<Class<?>, Object> metadata) {
            this.metadata = new HashMap(metadata);
        }

        public <T> T get(Class<T> metadataClass) {
            return metadataClass.cast(this.metadata.get(metadataClass));
        }
    }

    private static class MetricKey {
        private final String name;
        private final boolean success;

        MetricKey(String name, boolean success) {
            this.name = name;
            this.success = success;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricKey metricKey = (MetricKey)o;
            if (this.success != metricKey.success) {
                return false;
            }
            return this.name != null ? this.name.equals(metricKey.name) : metricKey.name == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.success ? 1 : 0);
            return result;
        }
    }

    public static class Metric {
        private final String name;
        private int count;
        private long elapsedNs;
        private final boolean success;

        public Metric(String name, int count, int elapsedNs, boolean success) {
            this.name = name;
            this.count = count;
            this.elapsedNs = elapsedNs;
            this.success = success;
        }

        public Metric(String name, boolean success) {
            this(name, 0, 0, success);
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public long getElapsedNs() {
            return this.elapsedNs;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metric metric = (Metric)o;
            if (this.count != metric.count) {
                return false;
            }
            if (this.elapsedNs != metric.elapsedNs) {
                return false;
            }
            if (this.success != metric.success) {
                return false;
            }
            return this.name != null ? this.name.equals(metric.name) : metric.name == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.count;
            result = 31 * result + (int)(this.elapsedNs ^ this.elapsedNs >>> 32);
            result = 31 * result + (this.success ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Metric{name='" + this.name + '\'' + ", count=" + this.count + ", elapsedNs=" + this.elapsedNs + ", success=" + this.success + '}';
        }
    }

    public class Event {
        private final String name;
        private final long startTimeNs;

        Event(String name) {
            this.name = name;
            this.startTimeNs = PerfStatsCollector.this.clock.nanoTime();
        }

        public void finished() {
            this.finished(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(boolean success) {
            if (!PerfStatsCollector.this.enabled) {
                return;
            }
            PerfStatsCollector perfStatsCollector = PerfStatsCollector.this;
            synchronized (perfStatsCollector) {
                MetricKey key = new MetricKey(this.name, success);
                Metric metric = (Metric)PerfStatsCollector.this.metricMap.get(key);
                if (metric == null) {
                    metric = new Metric(key.name, key.success);
                    PerfStatsCollector.this.metricMap.put(key, metric);
                }
                metric.count++;
                metric.elapsedNs += PerfStatsCollector.this.clock.nanoTime() - this.startTimeNs;
            }
        }
    }

    public static interface ThrowingRunnable<F extends Exception> {
        public void run() throws F;
    }

    public static interface ThrowingSupplier<T, F extends Exception> {
        public T get() throws F;
    }
}

