/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=WindowManagerGlobal.class, isInAndroidSdk=false, minSdk=17, looseSignatures=true)
public class ShadowWindowManagerGlobal {
    @Resetter
    public static void reset() {
        ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setDefaultWindowManager(null);
    }

    @Implementation(minSdk=18)
    public static Object getWindowSession() {
        return null;
    }

    @Implementation(maxSdk=17)
    public static Object getWindowSession(Looper looper) {
        return null;
    }

    @Implementation
    public static Object getWindowManagerService() throws RemoteException {
        IWindowManager service = ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).getWindowManagerService();
        if (service == null) {
            service = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
            ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setWindowManagerService(service);
            if (Build.VERSION.SDK_INT >= 30) {
                ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setUseBlastAdapter(service.useBLAST());
            }
        }
        return service;
    }

    @ForType(value=WindowManagerGlobal.class)
    static interface WindowManagerGlobalReflector {
        @Accessor(value="sDefaultWindowManager")
        @Static
        public void setDefaultWindowManager(WindowManagerGlobal var1);

        @Static
        @Accessor(value="sWindowManagerService")
        public IWindowManager getWindowManagerService();

        @Static
        @Accessor(value="sWindowManagerService")
        public void setWindowManagerService(IWindowManager var1);

        @Static
        @Accessor(value="sUseBLASTAdapter")
        public void setUseBlastAdapter(boolean var1);
    }
}

