/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Parcel;
import android.util.ArraySet;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.TimeUnit;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowUsageStatsManager_AppUsageObserver;
import org.robolectric.shadows.AutoValue_ShadowUsageStatsManager_UsageSessionObserver;

@Implements(value=UsageStatsManager.class, minSdk=21)
public class ShadowUsageStatsManager {
    private static int currentAppStandbyBucket = 10;
    private static int currentUsageSource = 1;
    private static final NavigableMap<Long, List<UsageEvents.Event>> eventsByTimeStamp = Maps.synchronizedNavigableMap((NavigableMap)Maps.newTreeMap());
    private SetMultimap<Integer, UsageStats> usageStatsByIntervalType = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private static final Map<String, Integer> appStandbyBuckets = Maps.newConcurrentMap();
    private static final Map<Integer, AppUsageObserver> appUsageObserversById = Maps.newConcurrentMap();
    protected static final Map<Integer, UsageSessionObserver> usageSessionObserversById = new LinkedHashMap<Integer, UsageSessionObserver>();
    private static final Map<Integer, AppUsageLimitObserver> appUsageLimitObserversById = Maps.newConcurrentMap();

    @Implementation
    protected UsageEvents queryEvents(long beginTime, long endTime) {
        ImmutableList results = ImmutableList.copyOf((Iterable)Iterables.concat(eventsByTimeStamp.subMap(beginTime, endTime).values()));
        return ShadowUsageStatsManager.createUsageEvents((List<UsageEvents.Event>)results);
    }

    private static UsageEvents createUsageEvents(List<UsageEvents.Event> results) {
        ArraySet names = new ArraySet();
        for (UsageEvents.Event result : results) {
            if (result.mPackage != null) {
                names.add((Object)result.mPackage);
            }
            if (result.mClass == null) continue;
            names.add((Object)result.mClass);
        }
        Object[] table = (String[])names.toArray((Object[])new String[0]);
        Arrays.sort(table);
        UsageEvents usageEvents = new UsageEvents(results, (String[])table);
        Parcel parcel = Parcel.obtain();
        usageEvents.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return new UsageEvents(parcel);
    }

    @Implementation(minSdk=28)
    protected UsageEvents queryEventsForSelf(long beginTime, long endTime) {
        String packageName = RuntimeEnvironment.getApplication().getOpPackageName();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (UsageEvents.Event event : Iterables.concat(eventsByTimeStamp.subMap(beginTime, endTime).values())) {
            if (!packageName.equals(event.getPackageName())) continue;
            listBuilder.add((Object)event);
        }
        return ShadowUsageStatsManager.createUsageEvents((List<UsageEvents.Event>)listBuilder.build());
    }

    @Deprecated
    public void addEvent(String packageName, long timeStamp, int eventType) {
        EventBuilder eventBuilder = EventBuilder.buildEvent().setPackage(packageName).setTimeStamp(timeStamp).setEventType(eventType);
        if (eventType == 5) {
            eventBuilder.setConfiguration(new Configuration());
        }
        this.addEvent(eventBuilder.build());
    }

    public void addEvent(UsageEvents.Event event) {
        ArrayList<UsageEvents.Event> eventsAtTime = (ArrayList<UsageEvents.Event>)eventsByTimeStamp.get(event.getTimeStamp());
        if (eventsAtTime == null) {
            eventsAtTime = new ArrayList<UsageEvents.Event>(1);
            eventsByTimeStamp.put(event.getTimeStamp(), eventsAtTime);
        }
        eventsAtTime.add(event);
    }

    public void simulateTimeChange(long offsetToAddInMillis) {
        ImmutableList oldEvents = ImmutableList.copyOf((Iterable)Iterables.concat(eventsByTimeStamp.values()));
        eventsByTimeStamp.clear();
        for (UsageEvents.Event event : oldEvents) {
            long newTimestamp = event.getTimeStamp() + offsetToAddInMillis;
            this.addEvent(EventBuilder.fromEvent(event).setTimeStamp(newTimestamp).build());
        }
    }

    @Implementation
    protected List<UsageStats> queryUsageStats(int intervalType, long beginTime, long endTime) {
        ArrayList<UsageStats> results = new ArrayList<UsageStats>();
        Range queryRange = Range.closed((Comparable)Long.valueOf(beginTime), (Comparable)Long.valueOf(endTime));
        for (UsageStats stats : this.usageStatsByIntervalType.get((Object)intervalType)) {
            Range statsRange = Range.closed((Comparable)Long.valueOf(stats.getFirstTimeStamp()), (Comparable)Long.valueOf(stats.getLastTimeStamp()));
            if (!queryRange.isConnected(statsRange)) continue;
            results.add(stats);
        }
        return results;
    }

    public void addUsageStats(int intervalType, UsageStats stats) {
        this.usageStatsByIntervalType.put((Object)intervalType, (Object)stats);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public int getAppStandbyBucket(String packageName) {
        Integer bucket = appStandbyBuckets.get(packageName);
        return bucket == null ? 10 : bucket;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public Map<String, Integer> getAppStandbyBuckets() {
        return new HashMap<String, Integer>(appStandbyBuckets);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public void setAppStandbyBucket(String packageName, int bucket) {
        appStandbyBuckets.put(packageName, bucket);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public void setAppStandbyBuckets(Map<String, Integer> appBuckets) {
        appStandbyBuckets.putAll(appBuckets);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void registerAppUsageObserver(int observerId, String[] packages, long timeLimit, TimeUnit timeUnit, PendingIntent callbackIntent) {
        appUsageObserversById.put(observerId, AppUsageObserver.build(observerId, (Collection<String>)ImmutableList.copyOf((Object[])packages), timeLimit, timeUnit, callbackIntent));
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void unregisterAppUsageObserver(int observerId) {
        appUsageObserversById.remove(observerId);
    }

    public Collection<AppUsageObserver> getRegisteredAppUsageObservers() {
        return ImmutableList.copyOf(appUsageObserversById.values());
    }

    public void triggerRegisteredAppUsageObserver(int observerId, long timeUsedInMillis) {
        AppUsageObserver observer = appUsageObserversById.remove(observerId);
        long timeLimitInMillis = observer.getTimeUnit().toMillis(observer.getTimeLimit());
        Intent intent = new Intent().putExtra("android.app.usage.extra.OBSERVER_ID", observerId).putExtra("android.app.usage.extra.TIME_LIMIT", timeLimitInMillis).putExtra("android.app.usage.extra.TIME_USED", timeUsedInMillis);
        try {
            observer.getCallbackIntent().send((Context)RuntimeEnvironment.getApplication(), 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation(minSdk=29)
    protected void registerUsageSessionObserver(int observerId, String[] packages, Duration sessionStepDuration, Duration thresholdTimeDuration, PendingIntent sessionStepTriggeredIntent, PendingIntent sessionEndedIntent) {
        usageSessionObserversById.put(observerId, UsageSessionObserver.build(observerId, (List<String>)ImmutableList.copyOf((Object[])packages), sessionStepDuration, thresholdTimeDuration, sessionStepTriggeredIntent, sessionEndedIntent));
    }

    @Implementation(minSdk=29)
    protected void unregisterUsageSessionObserver(int observerId) {
        usageSessionObserversById.remove(observerId);
    }

    public List<UsageSessionObserver> getRegisteredUsageSessionObservers() {
        return ImmutableList.copyOf(usageSessionObserversById.values());
    }

    public void triggerRegisteredSessionStepObserver(int observerId, long timeUsedInMillis) {
        UsageSessionObserver observer = usageSessionObserversById.get(observerId);
        long sessionStepTimeInMillis = observer.getSessionStepDuration().toMillis();
        Intent intent = new Intent().putExtra("android.app.usage.extra.OBSERVER_ID", observerId).putExtra("android.app.usage.extra.TIME_LIMIT", sessionStepTimeInMillis).putExtra("android.app.usage.extra.TIME_USED", timeUsedInMillis);
        try {
            observer.getSessionStepTriggeredIntent().send((Context)RuntimeEnvironment.getApplication(), 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    public void triggerRegisteredSessionEndedObserver(int observerId) {
        UsageSessionObserver observer = usageSessionObserversById.get(observerId);
        Intent intent = new Intent().putExtra("android.app.usage.extra.OBSERVER_ID", observerId);
        try {
            observer.getSessionEndedIntent().send((Context)RuntimeEnvironment.getApplication(), 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected void registerAppUsageLimitObserver(int observerId, String[] observedEntities, Duration timeLimit, Duration timeUsed, PendingIntent callbackIntent) {
        appUsageLimitObserversById.put(observerId, new AppUsageLimitObserver(observerId, (List<String>)ImmutableList.copyOf((Object[])observedEntities), timeLimit, timeUsed, callbackIntent));
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected void unregisterAppUsageLimitObserver(int observerId) {
        appUsageLimitObserversById.remove(observerId);
    }

    public ImmutableList<AppUsageLimitObserver> getRegisteredAppUsageLimitObservers() {
        return ImmutableList.copyOf(appUsageLimitObserversById.values());
    }

    public void triggerRegisteredAppUsageLimitObserver(int observerId, Duration timeUsed) {
        AppUsageLimitObserver observer = appUsageLimitObserversById.get(observerId);
        Intent intent = new Intent().putExtra("android.app.usage.extra.OBSERVER_ID", observerId).putExtra("android.app.usage.extra.TIME_LIMIT", observer.timeLimit.toMillis()).putExtra("android.app.usage.extra.TIME_USED", timeUsed.toMillis());
        try {
            observer.callbackIntent.send((Context)RuntimeEnvironment.getApplication(), 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation(minSdk=28)
    protected int getAppStandbyBucket() {
        return currentAppStandbyBucket;
    }

    public void setCurrentAppStandbyBucket(int bucket) {
        currentAppStandbyBucket = bucket;
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected int getUsageSource() {
        return currentUsageSource;
    }

    @TargetApi(value=29)
    public void setUsageSource(int usageSource) {
        currentUsageSource = usageSource;
    }

    @Resetter
    public static void reset() {
        currentAppStandbyBucket = 10;
        currentUsageSource = 1;
        eventsByTimeStamp.clear();
        appStandbyBuckets.clear();
        appUsageObserversById.clear();
        usageSessionObserversById.clear();
        appUsageLimitObserversById.clear();
    }

    public static class EventBuilder {
        private UsageEvents.Event event = new UsageEvents.Event();

        private EventBuilder() {
        }

        public static EventBuilder fromEvent(UsageEvents.Event event) {
            EventBuilder eventBuilder = new EventBuilder().setPackage(event.mPackage).setClass(event.mClass).setTimeStamp(event.mTimeStamp).setEventType(event.mEventType).setConfiguration(event.mConfiguration);
            if (event.mEventType == 5) {
                eventBuilder.setConfiguration(new Configuration());
            }
            return eventBuilder;
        }

        public static EventBuilder buildEvent() {
            return new EventBuilder();
        }

        public UsageEvents.Event build() {
            return this.event;
        }

        public EventBuilder setPackage(String packageName) {
            this.event.mPackage = packageName;
            return this;
        }

        public EventBuilder setClass(String className) {
            this.event.mClass = className;
            return this;
        }

        public EventBuilder setTimeStamp(long timeStamp) {
            this.event.mTimeStamp = timeStamp;
            return this;
        }

        public EventBuilder setEventType(int eventType) {
            this.event.mEventType = eventType;
            return this;
        }

        public EventBuilder setConfiguration(Configuration configuration) {
            this.event.mConfiguration = configuration;
            return this;
        }

        public EventBuilder setShortcutId(String shortcutId) {
            this.event.mShortcutId = shortcutId;
            return this;
        }

        @TargetApi(value=29)
        public EventBuilder setInstanceId(int instanceId) {
            this.event.mInstanceId = instanceId;
            return this;
        }

        @TargetApi(value=29)
        public EventBuilder setTaskRootPackage(String taskRootPackage) {
            this.event.mTaskRootPackage = taskRootPackage;
            return this;
        }

        @TargetApi(value=29)
        public EventBuilder setTaskRootClass(String taskRootClass) {
            this.event.mTaskRootClass = taskRootClass;
            return this;
        }

        @TargetApi(value=28)
        public EventBuilder setAppStandbyBucket(int bucket) {
            this.event.mBucketAndReason &= 0xFFFF;
            this.event.mBucketAndReason |= bucket << 16;
            return this;
        }
    }

    public static class UsageStatsBuilder {
        private UsageStats usageStats = new UsageStats();

        private UsageStatsBuilder() {
        }

        public static UsageStatsBuilder newBuilder() {
            return new UsageStatsBuilder();
        }

        public UsageStats build() {
            return this.usageStats;
        }

        public UsageStatsBuilder setPackageName(String packageName) {
            this.usageStats.mPackageName = packageName;
            return this;
        }

        public UsageStatsBuilder setFirstTimeStamp(long firstTimeStamp) {
            this.usageStats.mBeginTimeStamp = firstTimeStamp;
            return this;
        }

        public UsageStatsBuilder setLastTimeStamp(long lastTimeStamp) {
            this.usageStats.mEndTimeStamp = lastTimeStamp;
            return this;
        }

        public UsageStatsBuilder setTotalTimeInForeground(long totalTimeInForeground) {
            this.usageStats.mTotalTimeInForeground = totalTimeInForeground;
            return this;
        }

        public UsageStatsBuilder setLastTimeUsed(long lastTimeUsed) {
            this.usageStats.mLastTimeUsed = lastTimeUsed;
            return this;
        }
    }

    public static final class AppUsageLimitObserver {
        private final int observerId;
        private final ImmutableList<String> packageNames;
        private final Duration timeLimit;
        private final Duration timeUsed;
        private final PendingIntent callbackIntent;

        public AppUsageLimitObserver(int observerId, List<String> packageNames, Duration timeLimit, Duration timeUsed, PendingIntent callbackIntent) {
            this.observerId = observerId;
            this.packageNames = ImmutableList.copyOf(packageNames);
            this.timeLimit = (Duration)Preconditions.checkNotNull((Object)timeLimit);
            this.timeUsed = (Duration)Preconditions.checkNotNull((Object)timeUsed);
            this.callbackIntent = (PendingIntent)Preconditions.checkNotNull((Object)callbackIntent);
        }

        public int getObserverId() {
            return this.observerId;
        }

        public ImmutableList<String> getPackageNames() {
            return this.packageNames;
        }

        public Duration getTimeLimit() {
            return this.timeLimit;
        }

        public Duration getTimeUsed() {
            return this.timeUsed;
        }

        public PendingIntent getCallbackIntent() {
            return this.callbackIntent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppUsageLimitObserver that = (AppUsageLimitObserver)o;
            return this.observerId == that.observerId && this.packageNames.equals(that.packageNames) && this.timeLimit.equals(that.timeLimit) && this.timeUsed.equals(that.timeUsed) && this.callbackIntent.equals((Object)that.callbackIntent);
        }

        public int hashCode() {
            int result = this.observerId;
            result = 31 * result + this.packageNames.hashCode();
            result = 31 * result + this.timeLimit.hashCode();
            result = 31 * result + this.timeUsed.hashCode();
            result = 31 * result + this.callbackIntent.hashCode();
            return result;
        }
    }

    @AutoValue
    public static abstract class UsageSessionObserver {
        public static UsageSessionObserver build(int observerId, List<String> packageNames, Duration sessionStepDuration, Duration thresholdDuration, PendingIntent sessionStepTriggeredIntent, PendingIntent sessionEndedIntent) {
            return new AutoValue_ShadowUsageStatsManager_UsageSessionObserver(observerId, (ImmutableList<String>)ImmutableList.copyOf(packageNames), sessionStepDuration, thresholdDuration, sessionStepTriggeredIntent, sessionEndedIntent);
        }

        public abstract int getObserverId();

        public abstract ImmutableList<String> getPackageNames();

        public abstract Duration getSessionStepDuration();

        public abstract Duration getThresholdDuration();

        public abstract PendingIntent getSessionStepTriggeredIntent();

        public abstract PendingIntent getSessionEndedIntent();
    }

    @AutoValue
    public static abstract class AppUsageObserver {
        public static AppUsageObserver build(int observerId, Collection<String> packageNames, long timeLimit, TimeUnit timeUnit, PendingIntent callbackIntent) {
            return new AutoValue_ShadowUsageStatsManager_AppUsageObserver(observerId, (ImmutableList<String>)ImmutableList.copyOf(packageNames), timeLimit, timeUnit, callbackIntent);
        }

        public abstract int getObserverId();

        public abstract ImmutableList<String> getPackageNames();

        public abstract long getTimeLimit();

        public abstract TimeUnit getTimeUnit();

        public abstract PendingIntent getCallbackIntent();
    }
}

