/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.util.UUID;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ParcelFileDescriptor.class)
@SuppressLint(value={"NewApi"})
public class ShadowParcelFileDescriptor {
    private static final String PIPE_TMP_DIR = "ShadowParcelFileDescriptor";
    private static final String PIPE_FILE_NAME = "pipe";
    private RandomAccessFile file;
    @RealObject
    ParcelFileDescriptor realParcelFd;
    @RealObject
    private ParcelFileDescriptor realObject;

    @Implementation
    protected void __constructor__(ParcelFileDescriptor wrapped) {
        Shadow.invokeConstructor(ParcelFileDescriptor.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ParcelFileDescriptor.class, (Object)wrapped)});
        if (wrapped != null) {
            ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)wrapped);
            this.file = shadowParcelFileDescriptor.file;
        }
    }

    @Implementation
    protected static ParcelFileDescriptor open(File file, int mode) throws FileNotFoundException {
        ParcelFileDescriptor pfd;
        try {
            Constructor constructor = ParcelFileDescriptor.class.getDeclaredConstructor(FileDescriptor.class);
            pfd = (ParcelFileDescriptor)constructor.newInstance(new FileDescriptor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)pfd);
        shadowParcelFileDescriptor.file = new RandomAccessFile(file, ShadowParcelFileDescriptor.getFileMode(mode));
        if ((mode & 0x4000000) != 0) {
            try {
                shadowParcelFileDescriptor.file.setLength(0L);
            }
            catch (IOException ioe) {
                FileNotFoundException fnfe = new FileNotFoundException("Unable to truncate");
                fnfe.initCause(ioe);
                throw fnfe;
            }
        }
        if ((mode & 0x2000000) != 0) {
            try {
                shadowParcelFileDescriptor.file.seek(shadowParcelFileDescriptor.file.length());
            }
            catch (IOException ioe) {
                FileNotFoundException fnfe = new FileNotFoundException("Unable to append");
                fnfe.initCause(ioe);
                throw fnfe;
            }
        }
        return pfd;
    }

    private static String getFileMode(int mode) {
        if ((mode & 0x8000000) != 0) {
            return "rw";
        }
        switch (mode & 0x30000000) {
            case 0x10000000: {
                return "r";
            }
            case 0x20000000: 
            case 0x30000000: {
                return "rw";
            }
        }
        return "rw";
    }

    @Implementation
    protected static ParcelFileDescriptor[] createPipe() throws IOException {
        String string2 = String.valueOf(UUID.randomUUID());
        File file = new File(RuntimeEnvironment.getTempDirectory().createIfNotExists(PIPE_TMP_DIR).toFile(), new StringBuilder(5 + String.valueOf(string2).length()).append("pipe-").append(string2).toString());
        if (!file.createNewFile()) {
            String string3 = String.valueOf(file.getAbsolutePath());
            throw new IOException(string3.length() != 0 ? "Cannot create pipe file: ".concat(string3) : new String("Cannot create pipe file: "));
        }
        ParcelFileDescriptor readSide = ShadowParcelFileDescriptor.open(file, 0x10000000);
        ParcelFileDescriptor writeSide = ShadowParcelFileDescriptor.open(file, 0x30000000);
        file.deleteOnExit();
        return new ParcelFileDescriptor[]{readSide, writeSide};
    }

    @Implementation(minSdk=19)
    protected static ParcelFileDescriptor[] createReliablePipe() throws IOException {
        return ShadowParcelFileDescriptor.createPipe();
    }

    @Implementation
    protected FileDescriptor getFileDescriptor() {
        try {
            return this.file.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected long getStatSize() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Implementation
    protected int getFd() {
        try {
            return (Integer)ReflectionHelpers.getField((Object)this.file.getFD(), (String)"fd");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected void close() throws IOException {
        this.file.close();
        ((ParcelFileDescriptorReflector)Reflector.reflector(ParcelFileDescriptorReflector.class, (Object)this.realParcelFd)).close();
    }

    @ForType(value=ParcelFileDescriptor.class)
    static interface ParcelFileDescriptorReflector {
        @Direct
        public void close();
    }
}

