/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.os.Handler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaSessionManager.class, minSdk=21)
public class ShadowMediaSessionManager {
    private final List<MediaController> controllers = new CopyOnWriteArrayList<MediaController>();
    private final Set<MediaSessionManager.OnActiveSessionsChangedListener> listeners = new CopyOnWriteArraySet<MediaSessionManager.OnActiveSessionsChangedListener>();
    @RealObject
    MediaSessionManager realMediaSessionManager;

    @Implementation(minSdk=31)
    protected void __constructor__(Context context) {
        ((MediaSessionManagerReflector)Reflector.reflector(MediaSessionManagerReflector.class, (Object)this.realMediaSessionManager)).setContext(context);
        ((MediaSessionManagerReflector)Reflector.reflector(MediaSessionManagerReflector.class, (Object)this.realMediaSessionManager)).setService((ISessionManager)ReflectionHelpers.createDeepProxy(ISessionManager.class));
    }

    @Implementation
    protected List<MediaController> getActiveSessions(ComponentName ignoredNotificationListener) {
        return ImmutableList.copyOf(this.controllers);
    }

    @Implementation
    protected void addOnActiveSessionsChangedListener(MediaSessionManager.OnActiveSessionsChangedListener listener, ComponentName ignoredNotificationListener) {
        this.listeners.add(listener);
    }

    @Implementation
    protected void addOnActiveSessionsChangedListener(MediaSessionManager.OnActiveSessionsChangedListener listener, ComponentName ignoredNotificationListener, Handler ignoreHandler) {
        this.listeners.add(listener);
    }

    @Implementation
    protected void removeOnActiveSessionsChangedListener(MediaSessionManager.OnActiveSessionsChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void addController(MediaController controller) {
        this.controllers.add(controller);
        for (MediaSessionManager.OnActiveSessionsChangedListener listener : this.listeners) {
            listener.onActiveSessionsChanged(this.controllers);
        }
    }

    public void clearControllers() {
        this.controllers.clear();
    }

    @ForType(value=MediaSessionManager.class)
    static interface MediaSessionManagerReflector {
        @Accessor(value="mContext")
        public void setContext(Context var1);

        @Accessor(value="mService")
        public void setService(ISessionManager var1);
    }
}

