/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.SparseArray;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=InputMethodManager.class)
public class ShadowInputMethodManager {
    private boolean softInputVisible;
    private Optional<SoftInputVisibilityChangeHandler> visibilityChangeHandler = Optional.absent();
    private Optional<PrivateCommandListener> privateCommandListener = Optional.absent();
    private List<InputMethodInfo> inputMethodInfoList = ImmutableList.of();
    private List<InputMethodInfo> enabledInputMethodInfoList = ImmutableList.of();
    private Optional<InputMethodSubtype> inputMethodSubtype = Optional.absent();

    @Implementation
    protected boolean showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    @Implementation(maxSdk=30)
    protected boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.setSoftInputVisibility(true);
        return true;
    }

    @Implementation(minSdk=31)
    protected boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver, int ignoredReason) {
        return this.showSoftInput(view, flags, resultReceiver);
    }

    @Implementation(minSdk=31)
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver, int ignoredReason) {
        return this.hideSoftInputFromWindow(windowToken, flags, resultReceiver);
    }

    @Implementation(maxSdk=30)
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    @Implementation
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        int resultCode;
        if (this.isSoftInputVisible()) {
            this.setSoftInputVisibility(false);
            resultCode = 3;
        } else {
            resultCode = 1;
        }
        if (resultReceiver != null) {
            resultReceiver.send(resultCode, null);
        }
        return true;
    }

    @Implementation
    protected void toggleSoftInput(int showFlags, int hideFlags) {
        this.setSoftInputVisibility(!this.isSoftInputVisible());
    }

    public boolean isSoftInputVisible() {
        return this.softInputVisible;
    }

    public void setSoftInputVisibilityHandler(SoftInputVisibilityChangeHandler visibilityChangeHandler) {
        this.visibilityChangeHandler = Optional.of((Object)visibilityChangeHandler);
    }

    private void setSoftInputVisibility(boolean visible) {
        if (visible == this.softInputVisible) {
            return;
        }
        this.softInputVisible = visible;
        if (this.visibilityChangeHandler.isPresent()) {
            ((SoftInputVisibilityChangeHandler)this.visibilityChangeHandler.get()).handleSoftInputVisibilityChange(this.softInputVisible);
        }
    }

    @Implementation(minSdk=31)
    protected void closeCurrentInput() {
    }

    @Implementation
    protected List<InputMethodInfo> getInputMethodList() {
        return this.inputMethodInfoList;
    }

    public void setInputMethodInfoList(List<InputMethodInfo> inputMethodInfoList) {
        this.inputMethodInfoList = inputMethodInfoList;
    }

    @Implementation
    protected InputMethodSubtype getCurrentInputMethodSubtype() {
        return (InputMethodSubtype)this.inputMethodSubtype.orNull();
    }

    public void setCurrentInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        this.inputMethodSubtype = Optional.of((Object)inputMethodSubtype);
    }

    @Implementation
    protected List<InputMethodInfo> getEnabledInputMethodList() {
        return this.enabledInputMethodInfoList;
    }

    public void setEnabledInputMethodInfoList(List<InputMethodInfo> inputMethodInfoList) {
        this.enabledInputMethodInfoList = inputMethodInfoList;
    }

    @Implementation
    protected void restartInput(View view) {
    }

    @Implementation
    protected boolean isActive(View view) {
        return false;
    }

    @Implementation
    protected boolean isActive() {
        return false;
    }

    @Implementation
    protected boolean isFullscreenMode() {
        return false;
    }

    @Implementation(maxSdk=29)
    protected void focusIn(View view) {
    }

    @Implementation(minSdk=23, maxSdk=29)
    protected void onViewDetachedFromWindow(View view) {
    }

    @Implementation
    protected void displayCompletions(View view, CompletionInfo[] completions) {
    }

    @Implementation(maxSdk=22)
    protected static InputMethodManager peekInstance() {
        if (RuntimeEnvironment.getApiLevel() <= 17) {
            return (InputMethodManager)ReflectionHelpers.callStaticMethod(InputMethodManager.class, (String)"getInstance", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Looper.class, (Object)Looper.getMainLooper())});
        }
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            return InputMethodManager.getInstance();
        }
        return ((_InputMethodManager_)Reflector.reflector(_InputMethodManager_.class)).peekInstance();
    }

    @Implementation(minSdk=24)
    protected boolean startInputInner(int startInputReason, IBinder windowGainingFocus, int startInputFlags, int softInputMode, int windowFlags) {
        return true;
    }

    @Implementation(minSdk=23)
    protected void sendAppPrivateCommand(View view, String action, Bundle data) {
        if (this.privateCommandListener.isPresent()) {
            ((PrivateCommandListener)this.privateCommandListener.get()).onPrivateCommand(view, action, data);
        }
    }

    public void setAppPrivateCommandListener(PrivateCommandListener listener) {
        this.privateCommandListener = Optional.of((Object)listener);
    }

    @Resetter
    public static void reset() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        _InputMethodManager_ _reflector = (_InputMethodManager_)Reflector.reflector(_InputMethodManager_.class);
        if (apiLevel <= 17) {
            _reflector.setMInstance(null);
        } else if (apiLevel <= 28) {
            _reflector.setInstance(null);
        } else {
            _reflector.getInstanceMap().clear();
        }
    }

    @ForType(value=InputMethodManager.class)
    static interface _InputMethodManager_ {
        @Static
        @Direct
        public InputMethodManager peekInstance();

        @Static
        @Accessor(value="mInstance")
        public void setMInstance(InputMethodManager var1);

        @Static
        @Accessor(value="sInstance")
        public void setInstance(InputMethodManager var1);

        @Static
        @Accessor(value="sInstanceMap")
        public SparseArray<InputMethodManager> getInstanceMap();
    }

    public static interface PrivateCommandListener {
        public void onPrivateCommand(View var1, String var2, Bundle var3);
    }

    public static interface SoftInputVisibilityChangeHandler {
        public void handleSoftInputVisibilityChange(boolean var1);
    }
}

