/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Point;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.WifiDisplayStatus;
import android.os.RemoteException;
import android.util.SparseArray;
import android.view.DisplayInfo;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.robolectric.android.Bootstrap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=DisplayManagerGlobal.class, isInAndroidSdk=false, minSdk=17, looseSignatures=true)
public class ShadowDisplayManagerGlobal {
    private static DisplayManagerGlobal instance;
    private float saturationLevel = 1.0f;
    private final SparseArray<BrightnessConfiguration> brightnessConfiguration = new SparseArray();
    private final List<BrightnessChangeEvent> brightnessChangeEvents = new ArrayList<BrightnessChangeEvent>();
    private Object defaultBrightnessConfiguration;
    private MyDisplayManager mDm;

    @Resetter
    public static void reset() {
        instance = null;
    }

    @Implementation
    public static synchronized DisplayManagerGlobal getInstance() {
        if (instance == null) {
            MyDisplayManager myIDisplayManager = new MyDisplayManager();
            IDisplayManager proxy = (IDisplayManager)ReflectionHelpers.createDelegatingProxy(IDisplayManager.class, (Object)myIDisplayManager);
            instance = (DisplayManagerGlobal)ReflectionHelpers.callConstructor(DisplayManagerGlobal.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IDisplayManager.class, (Object)proxy)});
            ShadowDisplayManagerGlobal shadow = (ShadowDisplayManagerGlobal)Shadow.extract((Object)instance);
            shadow.mDm = myIDisplayManager;
            Bootstrap.setUpDisplay();
        }
        return instance;
    }

    @VisibleForTesting
    static DisplayManagerGlobal getGlobalInstance() {
        return instance;
    }

    @Implementation
    protected WifiDisplayStatus getWifiDisplayStatus() {
        return new WifiDisplayStatus();
    }

    @Implementation(minSdk=27)
    public Point getStableDisplaySize() throws RemoteException {
        DisplayInfo defaultDisplayInfo = this.mDm.getDisplayInfo(0);
        return new Point(defaultDisplayInfo.getNaturalWidth(), defaultDisplayInfo.getNaturalHeight());
    }

    int addDisplay(DisplayInfo displayInfo) {
        this.fixNominalDimens(displayInfo);
        return this.mDm.addDisplay(displayInfo);
    }

    private void fixNominalDimens(DisplayInfo displayInfo) {
        int min = Math.min(displayInfo.appWidth, displayInfo.appHeight);
        int max = Math.max(displayInfo.appWidth, displayInfo.appHeight);
        displayInfo.smallestNominalAppHeight = displayInfo.smallestNominalAppWidth = min;
        displayInfo.largestNominalAppHeight = displayInfo.largestNominalAppWidth = max;
    }

    void changeDisplay(int displayId, DisplayInfo displayInfo) {
        this.mDm.changeDisplay(displayId, displayInfo);
    }

    void removeDisplay(int displayId) {
        this.mDm.removeDisplay(displayId);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected void setSaturationLevel(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("Saturation level must be between 0 and 1");
        }
        this.saturationLevel = level;
    }

    float getSaturationLevel() {
        return this.saturationLevel;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void setBrightnessConfigurationForUser(Object configObject, int userId, String packageName) {
        BrightnessConfiguration config = (BrightnessConfiguration)configObject;
        this.brightnessConfiguration.put(userId, (Object)config);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object getBrightnessConfigurationForUser(int userId) {
        BrightnessConfiguration config = (BrightnessConfiguration)this.brightnessConfiguration.get(userId);
        if (config != null) {
            return config;
        }
        return this.getDefaultBrightnessConfiguration();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object getDefaultBrightnessConfiguration() {
        return this.defaultBrightnessConfiguration;
    }

    void setDefaultBrightnessConfiguration(@Nullable Object configObject) {
        BrightnessConfiguration config = (BrightnessConfiguration)configObject;
        this.defaultBrightnessConfiguration = config;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected List<BrightnessChangeEvent> getBrightnessEvents(String callingPackage) {
        return this.brightnessChangeEvents;
    }

    void setBrightnessEvents(List<BrightnessChangeEvent> events) {
        this.brightnessChangeEvents.clear();
        this.brightnessChangeEvents.addAll(events);
    }

    private static class MyDisplayManager {
        private final TreeMap<Integer, DisplayInfo> displayInfos = new TreeMap();
        private int nextDisplayId = 0;
        private final List<IDisplayManagerCallback> callbacks = new ArrayList<IDisplayManagerCallback>();

        private MyDisplayManager() {
        }

        public DisplayInfo getDisplayInfo(int i) throws RemoteException {
            DisplayInfo displayInfo = this.displayInfos.get(i);
            return displayInfo == null ? null : new DisplayInfo(displayInfo);
        }

        public int[] getDisplayIds() throws RemoteException {
            int[] ids = new int[this.displayInfos.size()];
            int i = 0;
            for (Integer displayId : this.displayInfos.keySet()) {
                ids[i++] = displayId;
            }
            return ids;
        }

        public void registerCallback(IDisplayManagerCallback iDisplayManagerCallback) throws RemoteException {
            this.callbacks.add(iDisplayManagerCallback);
        }

        public void registerCallbackWithEventMask(IDisplayManagerCallback iDisplayManagerCallback, long ignoredEventsMask) throws RemoteException {
            this.registerCallback(iDisplayManagerCallback);
        }

        private synchronized int addDisplay(DisplayInfo displayInfo) {
            int nextId = this.nextDisplayId++;
            this.displayInfos.put(nextId, displayInfo);
            this.notifyListeners(nextId, 1);
            return nextId;
        }

        private synchronized void changeDisplay(int displayId, DisplayInfo displayInfo) {
            if (!this.displayInfos.containsKey(displayId)) {
                throw new IllegalStateException(new StringBuilder(22).append("no display ").append(displayId).toString());
            }
            this.displayInfos.put(displayId, displayInfo);
            this.notifyListeners(displayId, 2);
        }

        private synchronized void removeDisplay(int displayId) {
            if (!this.displayInfos.containsKey(displayId)) {
                throw new IllegalStateException(new StringBuilder(22).append("no display ").append(displayId).toString());
            }
            this.displayInfos.remove(displayId);
            this.notifyListeners(displayId, 3);
        }

        private void notifyListeners(int nextId, int event) {
            for (IDisplayManagerCallback callback : this.callbacks) {
                try {
                    callback.onDisplayEvent(nextId, event);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

