/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.appwidget.AppWidgetHost;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAppWidgetHostView;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AppWidgetHost.class)
public class ShadowAppWidgetHost {
    @RealObject
    private AppWidgetHost realAppWidgetHost;
    private Context context;
    private int hostId;
    private int appWidgetIdToAllocate;

    @Implementation
    protected void __constructor__(Context context, int hostId) {
        this.context = context;
        this.hostId = hostId;
    }

    public Context getContext() {
        return this.context;
    }

    public int getHostId() {
        return this.hostId;
    }

    public void setAppWidgetIdToAllocate(int idToAllocate) {
        this.appWidgetIdToAllocate = idToAllocate;
    }

    @Implementation
    protected int allocateAppWidgetId() {
        return this.appWidgetIdToAllocate;
    }

    @Implementation
    protected AppWidgetHostView createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostView hostView = (AppWidgetHostView)ReflectionHelpers.callInstanceMethod(AppWidgetHost.class, (Object)this.realAppWidgetHost, (String)"onCreateView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)appWidgetId), ReflectionHelpers.ClassParameter.from(AppWidgetProviderInfo.class, (Object)appWidget)});
        hostView.setAppWidget(appWidgetId, appWidget);
        ShadowAppWidgetHostView shadowAppWidgetHostView = (ShadowAppWidgetHostView)Shadow.extract((Object)hostView);
        shadowAppWidgetHostView.setHost(this.realAppWidgetHost);
        return hostView;
    }
}

