/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class PreLPointers {
    static final Map<Integer, Long> preLPointers = new ConcurrentHashMap<Integer, Long>();
    private static final AtomicInteger nextPreLPointer = new AtomicInteger(1);

    private PreLPointers() {
    }

    static int register(long realPtr) {
        int nextPtr = nextPreLPointer.incrementAndGet();
        preLPointers.put(nextPtr, realPtr);
        return nextPtr;
    }

    static long get(int fakePtr) {
        return preLPointers.computeIfAbsent(fakePtr, integer -> {
            throw new AssertionError((Object)new StringBuilder(33).append("Missing pre-L pointer ").append(fakePtr).toString());
        });
    }

    static void remove(int fakePtr) {
        if (!preLPointers.containsKey(fakePtr)) {
            throw new AssertionError((Object)new StringBuilder(33).append("Missing pre-L pointer ").append(fakePtr).toString());
        }
        preLPointers.remove(fakePtr);
    }
}

