/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Point;
import com.google.auto.value.AutoValue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.robolectric.Shadows;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ImageUtil_RobolectricBufferedImage;
import org.robolectric.shadows.ShadowBitmap;

public class ImageUtil {
    private static final String FORMAT_NAME_JPEG = "jpg";
    private static final String FORMAT_NAME_PNG = "png";
    private static boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Point getImageSizeFromStream(InputStream is) {
        if (!initialized) {
            ImageIO.setUseCache(false);
            initialized = true;
        }
        ImageInputStream imageStream = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        try {
            reader.setInput(imageStream);
            Point point = new Point(reader.getWidth(0), reader.getHeight(0));
            reader.dispose();
            return point;
        }
        catch (Throwable throwable) {
            try {
                reader.dispose();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RobolectricBufferedImage getImageFromStream(InputStream is) {
        if (!initialized) {
            ImageIO.setUseCache(false);
            initialized = true;
        }
        ImageInputStream imageStream = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        try {
            reader.setInput(imageStream);
            String format = reader.getFormatName();
            int minIndex = reader.getMinIndex();
            BufferedImage image = reader.read(minIndex);
            String string = String.valueOf(format);
            RobolectricBufferedImage robolectricBufferedImage = RobolectricBufferedImage.create(image, (string.length() != 0 ? "image/".concat(string) : new String("image/")).toLowerCase());
            reader.dispose();
            return robolectricBufferedImage;
        }
        catch (Throwable throwable) {
            try {
                reader.dispose();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static boolean scaledBitmap(Bitmap src, Bitmap dst, boolean filter) {
        if (src == null || dst == null) {
            return false;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        if (srcWidth <= 0 || srcHeight <= 0 || dstWidth <= 0 || dstHeight <= 0) {
            return false;
        }
        BufferedImage before = ((ShadowBitmap)Shadow.extract((Object)src)).getBufferedImage();
        if (before == null || before.getColorModel() == null) {
            return false;
        }
        int imageType = ImageUtil.getBufferedImageType(src.getConfig(), before.getColorModel().hasAlpha());
        BufferedImage after = new BufferedImage(dstWidth, dstHeight, imageType);
        Graphics2D graphics2D = after.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, filter ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage(before, 0, 0, dstWidth, dstHeight, 0, 0, srcWidth, srcHeight, null);
        graphics2D.dispose();
        ((ShadowBitmap)Shadow.extract((Object)dst)).setBufferedImage(after);
        return true;
    }

    public static boolean writeToStream(Bitmap realBitmap, Bitmap.CompressFormat format, int quality, OutputStream stream) {
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("Quality out of bounds!");
        }
        try {
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(ImageUtil.getFormatName(format));
            if (iter.hasNext()) {
                writer = iter.next();
            }
            if (writer == null) {
                return false;
            }
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(stream);){
                int outputImageType;
                writer.setOutput(ios);
                ImageWriteParam iwparam = writer.getDefaultWriteParam();
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality((float)quality / 100.0f);
                int width = realBitmap.getWidth();
                int height = realBitmap.getHeight();
                boolean needAlphaChannel = ImageUtil.needAlphaChannel(format);
                BufferedImage bufferedImage = Shadows.shadowOf(realBitmap).getBufferedImage();
                if (bufferedImage == null) {
                    bufferedImage = new BufferedImage(realBitmap.getWidth(), realBitmap.getHeight(), 2);
                }
                if ((outputImageType = ImageUtil.getBufferedImageType(realBitmap.getConfig(), needAlphaChannel)) != 2) {
                    BufferedImage outputBufferedImage = new BufferedImage(width, height, outputImageType);
                    Graphics2D g = outputBufferedImage.createGraphics();
                    g.drawImage((Image)bufferedImage, 0, 0, null);
                    g.dispose();
                    bufferedImage = outputBufferedImage;
                }
                writer.write(null, new IIOImage(bufferedImage, null, null), iwparam);
                ios.flush();
                writer.dispose();
            }
        }
        catch (IOException ignore) {
            return false;
        }
        return true;
    }

    private static String getFormatName(Bitmap.CompressFormat compressFormat) {
        switch (compressFormat) {
            case JPEG: {
                return FORMAT_NAME_JPEG;
            }
            case WEBP: 
            case WEBP_LOSSY: 
            case WEBP_LOSSLESS: 
            case PNG: {
                return FORMAT_NAME_PNG;
            }
        }
        String string = String.valueOf(compressFormat);
        throw new UnsupportedOperationException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot convert format: ").append(string).toString());
    }

    private static boolean needAlphaChannel(Bitmap.CompressFormat compressFormat) {
        return !FORMAT_NAME_JPEG.equals(ImageUtil.getFormatName(compressFormat));
    }

    private static int getBufferedImageType(Bitmap.Config config, boolean needAlphaChannel) {
        if (config == null) {
            return needAlphaChannel ? 2 : 1;
        }
        switch (config) {
            case RGB_565: {
                return 8;
            }
            case RGBA_F16: {
                return needAlphaChannel ? 3 : 1;
            }
        }
        return needAlphaChannel ? 2 : 1;
    }

    @AutoValue
    static abstract class RobolectricBufferedImage {
        RobolectricBufferedImage() {
        }

        abstract BufferedImage getBufferedImage();

        abstract String getMimeType();

        public Point getWidthAndHeight() {
            return new Point(this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight());
        }

        static RobolectricBufferedImage create(BufferedImage bufferedImage, String mimeType) {
            return new AutoValue_ImageUtil_RobolectricBufferedImage(bufferedImage, mimeType);
        }
    }
}

