/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.io.PrintStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ViewGroup.class)
public class ShadowViewGroup
extends ShadowView {
    @RealObject
    protected ViewGroup realViewGroup;
    private boolean disallowInterceptTouchEvent = false;
    private MotionEvent interceptedTouchEvent;

    @Implementation
    protected void addView(View child, int index, ViewGroup.LayoutParams params) {
        Runnable addViewRunnable = () -> ((ViewGroupReflector)Reflector.reflector(ViewGroupReflector.class, (Object)this.realViewGroup)).addView(child, index, params);
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            addViewRunnable.run();
        } else {
            ShadowLooper.shadowMainLooper().runPaused(addViewRunnable);
        }
    }

    @Override
    public String innerText() {
        StringBuilder innerText = new StringBuilder();
        String delimiter = "";
        for (int i = 0; i < this.realViewGroup.getChildCount(); ++i) {
            View child = this.realViewGroup.getChildAt(i);
            ShadowView shadowView = (ShadowView)Shadow.extract((Object)child);
            String childText = shadowView.innerText();
            if (childText.length() > 0) {
                innerText.append(delimiter);
                delimiter = " ";
            }
            innerText.append(childText);
        }
        return innerText.toString();
    }

    @Override
    @Deprecated
    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        if (this.realViewGroup.getChildCount() > 0) {
            out.println(">");
            for (int i = 0; i < this.realViewGroup.getChildCount(); ++i) {
                View child = this.realViewGroup.getChildAt(i);
                ShadowView shadowChild = (ShadowView)Shadow.extract((Object)child);
                shadowChild.dump(out, indent + 2);
            }
            this.dumpIndent(out, indent);
            String string2 = this.realView.getClass().getSimpleName();
            out.println(new StringBuilder(3 + String.valueOf(string2).length()).append("</").append(string2).append(">").toString());
        } else {
            out.println("/>");
        }
    }

    @Implementation
    protected void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.disallowInterceptTouchEvent = disallowIntercept;
    }

    public boolean getDisallowInterceptTouchEvent() {
        return this.disallowInterceptTouchEvent;
    }

    protected void removedChild(View child) {
        if (this.isAttachedToWindow()) {
            ShadowView shadowView = (ShadowView)Shadow.extract((Object)child);
            shadowView.callOnDetachedFromWindow();
        }
    }

    public MotionEvent getInterceptedTouchEvent() {
        return this.interceptedTouchEvent;
    }

    @Implementation
    protected boolean onInterceptTouchEvent(MotionEvent ev) {
        this.interceptedTouchEvent = ev;
        return false;
    }

    @ForType(value=ViewGroup.class)
    static interface ViewGroupReflector {
        @Direct
        public void addView(View var1, int var2, ViewGroup.LayoutParams var3);
    }
}

