/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.res.Fs;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=PackageParser.class, isInAndroidSdk=false)
public class ShadowPackageParser {
    public static PackageParser.Package callParsePackage(Path apkFile) {
        PackageParser packageParser = new PackageParser();
        int flags = 2;
        try {
            PackageParser.Package thePackage;
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                if (RuntimeEnvironment.getApiLevel() >= 29) {
                    QHelper.setCallback(packageParser);
                }
                thePackage = packageParser.parsePackage(apkFile.toFile(), flags);
            } else {
                thePackage = ((_PackageParser_)Reflector.reflector(_PackageParser_.class, (Object)packageParser)).parsePackage(apkFile.toFile(), Fs.externalize((Path)apkFile), new DisplayMetrics(), flags);
            }
            if (thePackage == null) {
                ImmutableList<ShadowLog.LogItem> logItems = ShadowLog.getLogsForTag("PackageParser");
                if (logItems.isEmpty()) {
                    String string = String.valueOf(apkFile);
                    throw new RuntimeException(new StringBuilder(24 + String.valueOf(string).length()).append("Failed to parse package ").append(string).toString());
                }
                ShadowLog.LogItem logItem = (ShadowLog.LogItem)logItems.get(0);
                String string = String.valueOf(apkFile);
                String string2 = logItem.msg;
                throw new RuntimeException(new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failed to parse package ").append(string).append(": ").append(string2).toString(), logItem.throwable);
            }
            return thePackage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ForType(value=PackageParser.Package.class)
    public static interface _Package_ {
        @Accessor(value="mPath")
        public String getPath();
    }

    @ForType(value=PackageParser.class)
    static interface _PackageParser_ {
        @Static
        public PackageInfo generatePackageInfo(PackageParser.Package var1, int[] var2, int var3, long var4, long var6, HashSet<String> var8);

        @Static
        public PackageInfo generatePackageInfo(PackageParser.Package var1, int[] var2, int var3, long var4, long var6, HashSet<String> var8, @WithType(value="android.content.pm.PackageUserState") Object var9);

        @Static
        public PackageInfo generatePackageInfo(PackageParser.Package var1, int[] var2, int var3, long var4, long var6, ArraySet<String> var8, @WithType(value="android.content.pm.PackageUserState") Object var9);

        default public PackageInfo generatePackageInfo(PackageParser.Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime) {
            int apiLevel = RuntimeEnvironment.getApiLevel();
            if (apiLevel <= 16) {
                return this.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, new HashSet<String>());
            }
            if (apiLevel <= 21) {
                return this.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, new HashSet<String>(), (Object)new PackageUserState());
            }
            if (apiLevel <= 22) {
                return this.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, (ArraySet<String>)new ArraySet(), (Object)new PackageUserState());
            }
            return PackageParser.generatePackageInfo((PackageParser.Package)p, (int[])gids, (int)flags, (long)firstInstallTime, (long)lastUpdateTime, new HashSet(), (PackageUserState)new PackageUserState());
        }

        public PackageParser.Package parsePackage(File var1, String var2, DisplayMetrics var3, int var4);
    }

    private static class QHelper {
        private QHelper() {
        }

        private static void setCallback(PackageParser packageParser) {
            packageParser.setCallback(new PackageParser.Callback(){

                public boolean hasFeature(String s) {
                    return false;
                }

                public String[] getOverlayPaths(String s, String s1) {
                    return null;
                }

                public String[] getOverlayApks(String s) {
                    return null;
                }
            });
        }
    }
}

