/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.FileObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=FileObserver.class)
public class ShadowFileObserver {
    @RealObject
    private FileObserver realFileObserver;
    private final WatchService watchService;
    private final Map<String, WatchedDirectory> watchedDirectories = new HashMap<String, WatchedDirectory>();
    private final Map<WatchKey, Path> watchedKeys = new HashMap<WatchKey, Path>();
    private WatchEvent.Kind<?>[] watchEvents = new WatchEvent.Kind[0];
    @GuardedBy(value="this")
    private WatcherRunnable watcherRunnable = null;

    public ShadowFileObserver() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void finalize() throws Throwable {
        this.stopWatching();
    }

    private void setMask(int mask) {
        HashSet<WatchEvent.Kind<Path>> watchEventsSet = new HashSet<WatchEvent.Kind<Path>>();
        if ((mask & 2) != 0) {
            watchEventsSet.add(StandardWatchEventKinds.ENTRY_MODIFY);
        }
        if ((mask & 0x200) != 0) {
            watchEventsSet.add(StandardWatchEventKinds.ENTRY_DELETE);
        }
        if ((mask & 0x100) != 0) {
            watchEventsSet.add(StandardWatchEventKinds.ENTRY_CREATE);
        }
        this.watchEvents = watchEventsSet.toArray(new WatchEvent.Kind[0]);
    }

    private void addFile(File file) {
        ArrayList<File> list = new ArrayList<File>(1);
        list.add(file);
        this.addFiles(list);
    }

    private void addFiles(List<File> files) {
        for (File file : files) {
            Path path = file.toPath();
            if (Files.isDirectory(path, new LinkOption[0])) {
                WatchedDirectory watchedDirectory = new WatchedDirectory(path);
                this.watchedDirectories.put(path.toString(), watchedDirectory);
                continue;
            }
            Path directory = path.getParent();
            String filename = path.getFileName().toString();
            WatchedDirectory watchedDirectory = this.watchedDirectories.get(directory.toString());
            if (watchedDirectory == null) {
                watchedDirectory = new WatchedDirectory(directory);
            }
            watchedDirectory.addFile(filename);
            this.watchedDirectories.put(directory.toString(), watchedDirectory);
        }
    }

    @Implementation
    protected void __constructor__(String path, int mask) {
        this.setMask(mask);
        this.addFile(new File(path));
    }

    @Implementation(minSdk=29)
    protected void __constructor__(List<File> files, int mask) {
        this.setMask(mask);
        this.addFiles(files);
    }

    @Implementation
    protected synchronized void startWatching() throws IOException {
        if (this.watcherRunnable != null) {
            return;
        }
        if (this.watchEvents.length == 0) {
            return;
        }
        for (WatchedDirectory watchedDirectory : this.watchedDirectories.values()) {
            watchedDirectory.register();
        }
        this.watcherRunnable = new WatcherRunnable(this.realFileObserver, this.watchedDirectories, this.watchedKeys, this.watchService);
        Thread thread = new Thread((Runnable)this.watcherRunnable, "ShadowFileObserver");
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void stopWatching() {
        for (WatchedDirectory watchedDirectory : this.watchedDirectories.values()) {
            watchedDirectory.unregister();
        }
        ShadowFileObserver shadowFileObserver = this;
        synchronized (shadowFileObserver) {
            if (this.watcherRunnable != null) {
                this.watcherRunnable.stop();
                this.watcherRunnable = null;
            }
        }
    }

    private static int fileObserverEventFromWatcherEvent(WatchEvent.Kind<?> kind) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            return 256;
        }
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            return 512;
        }
        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            return 2;
        }
        return 0;
    }

    private static class WatcherRunnable
    implements Runnable {
        @GuardedBy(value="this")
        private boolean shouldStop = false;
        private final FileObserver realFileObserver;
        private final Map<String, WatchedDirectory> watchedDirectories;
        private final Map<WatchKey, Path> watchedKeys;
        private final WatchService watchService;

        public WatcherRunnable(FileObserver realFileObserver, Map<String, WatchedDirectory> watchedDirectories, Map<WatchKey, Path> watchedKeys, WatchService watchService) {
            this.realFileObserver = realFileObserver;
            this.watchedDirectories = watchedDirectories;
            this.watchedKeys = watchedKeys;
            this.watchService = watchService;
        }

        public synchronized void stop() {
            this.shouldStop = true;
        }

        public synchronized boolean shouldContinue() {
            return !this.shouldStop;
        }

        private WatchEvent<Path> castToPathWatchEvent(WatchEvent<?> untypedWatchEvent) {
            return untypedWatchEvent;
        }

        @Override
        public void run() {
            while (this.shouldContinue()) {
                boolean valid;
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                Path dir = this.watchedKeys.get(key);
                if (dir != null) {
                    WatchedDirectory watchedDirectory = this.watchedDirectories.get(dir.toString());
                    List<WatchEvent<?>> events = key.pollEvents();
                    for (WatchEvent<?> event : events) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<Path> ev = this.castToPathWatchEvent(event);
                        Path fileName = ev.context().getFileName();
                        if (watchedDirectory.watchedFiles.isEmpty()) {
                            this.realFileObserver.onEvent(ShadowFileObserver.fileObserverEventFromWatcherEvent(kind), fileName.toString());
                            continue;
                        }
                        for (String watchedFile : watchedDirectory.watchedFiles) {
                            if (!fileName.toString().equals(watchedFile)) continue;
                            this.realFileObserver.onEvent(ShadowFileObserver.fileObserverEventFromWatcherEvent(kind), fileName.toString());
                        }
                    }
                }
                if (valid = key.reset()) continue;
                return;
            }
        }
    }

    private class WatchedDirectory {
        @GuardedBy(value="this")
        private WatchKey watchKey = null;
        private final Path dirPath;
        private final Set<String> watchedFiles = new HashSet<String>();

        WatchedDirectory(Path dirPath) {
            this.dirPath = dirPath;
        }

        void addFile(String filename) {
            this.watchedFiles.add(filename);
        }

        synchronized void register() throws IOException {
            this.unregister();
            this.watchKey = this.dirPath.register(ShadowFileObserver.this.watchService, ShadowFileObserver.this.watchEvents);
            ShadowFileObserver.this.watchedKeys.put(this.watchKey, this.dirPath);
        }

        synchronized void unregister() {
            if (this.watchKey != null) {
                ShadowFileObserver.this.watchedKeys.remove(this.watchKey);
                this.watchKey.cancel();
                this.watchKey = null;
            }
        }
    }
}

