/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=EGL14.class, minSdk=21)
public class ShadowEGL14 {
    private static final long UNUSED_HANDLE_ID = 43L;

    @Implementation
    protected static EGLDisplay eglGetDisplay(int displayId) {
        return ShadowEGL14.createEglDisplay();
    }

    @Implementation
    protected static boolean eglInitialize(EGLDisplay dpy, int[] major, int majorOffset, int[] minor, int minorOffset) {
        return true;
    }

    @Implementation
    protected static boolean eglChooseConfig(EGLDisplay dpy, int[] attribList, int attribListOffset, EGLConfig[] configs, int configsOffset, int configSize, int[] numConfig, int numConfigOffset) {
        configs[configsOffset] = ShadowEGL14.createEglConfig();
        numConfig[numConfigOffset] = 1;
        return true;
    }

    @Implementation
    protected static EGLContext eglCreateContext(EGLDisplay dpy, EGLConfig config, EGLContext shareContext, int[] attribList, int offset) {
        int majorVersion = ShadowEGL14.getAttribValue(attribList, 12440);
        switch (majorVersion) {
            case 2: 
            case 3: {
                return ShadowEGL14.createEglContext(majorVersion);
            }
        }
        return EGL14.EGL_NO_CONTEXT;
    }

    @Implementation
    protected static boolean eglQueryContext(EGLDisplay dpy, EGLContext ctx, int attribute, int[] value, int offset) {
        value[offset] = 0;
        switch (attribute) {
            case 12440: {
                value[offset] = (int)ctx.getNativeHandle();
                break;
            }
        }
        return true;
    }

    @Implementation
    protected static EGLSurface eglCreatePbufferSurface(EGLDisplay dpy, EGLConfig config, int[] attribList, int offset) {
        return ShadowEGL14.createEglSurface();
    }

    @Implementation
    protected static EGLSurface eglCreateWindowSurface(EGLDisplay dpy, EGLConfig config, Object win, int[] attribList, int offset) {
        return ShadowEGL14.createEglSurface();
    }

    @Implementation
    protected static boolean eglMakeCurrent(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx) {
        return true;
    }

    @Implementation
    protected static boolean eglSwapBuffers(EGLDisplay dpy, EGLSurface surface) {
        return true;
    }

    @Implementation
    protected static int eglGetError() {
        return 12288;
    }

    private static EGLDisplay createEglDisplay() {
        return (EGLDisplay)ReflectionHelpers.callConstructor(EGLDisplay.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)43L)});
    }

    private static EGLConfig createEglConfig() {
        return (EGLConfig)ReflectionHelpers.callConstructor(EGLConfig.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)43L)});
    }

    private static EGLContext createEglContext(int version) {
        return (EGLContext)ReflectionHelpers.callConstructor(EGLContext.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)version)});
    }

    private static EGLSurface createEglSurface() {
        return (EGLSurface)ReflectionHelpers.callConstructor(EGLSurface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)43L)});
    }

    private static int getAttribValue(int[] attribList, int attribute) {
        int attribValue = 0;
        for (int i = 0; i < attribList.length; i += 2) {
            if (attribList[i] != attribute) continue;
            attribValue = attribList[i + 1];
        }
        return attribValue;
    }
}

