

package org.robolectric.shadows;

import android.annotation.NonNull;
import android.app.PendingIntent;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ShadowUsageStatsManager_AppUsageObserver extends ShadowUsageStatsManager.AppUsageObserver {

  private final int observerId;

  private final ImmutableList<String> packageNames;

  private final long timeLimit;

  private final TimeUnit timeUnit;

  private final PendingIntent callbackIntent;

  AutoValue_ShadowUsageStatsManager_AppUsageObserver(
      int observerId,
      ImmutableList<String> packageNames,
      long timeLimit,
      TimeUnit timeUnit,
      PendingIntent callbackIntent) {
    this.observerId = observerId;
    if (packageNames == null) {
      throw new NullPointerException("Null packageNames");
    }
    this.packageNames = packageNames;
    this.timeLimit = timeLimit;
    if (timeUnit == null) {
      throw new NullPointerException("Null timeUnit");
    }
    this.timeUnit = timeUnit;
    if (callbackIntent == null) {
      throw new NullPointerException("Null callbackIntent");
    }
    this.callbackIntent = callbackIntent;
  }

  @Override
  public int getObserverId() {
    return observerId;
  }

  @NonNull
  @Override
  public ImmutableList<String> getPackageNames() {
    return packageNames;
  }

  @Override
  public long getTimeLimit() {
    return timeLimit;
  }

  @NonNull
  @Override
  public TimeUnit getTimeUnit() {
    return timeUnit;
  }

  @NonNull
  @Override
  public PendingIntent getCallbackIntent() {
    return callbackIntent;
  }

  @Override
  public String toString() {
    return "AppUsageObserver{"
         + "observerId=" + observerId + ", "
         + "packageNames=" + packageNames + ", "
         + "timeLimit=" + timeLimit + ", "
         + "timeUnit=" + timeUnit + ", "
         + "callbackIntent=" + callbackIntent
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ShadowUsageStatsManager.AppUsageObserver) {
      ShadowUsageStatsManager.AppUsageObserver that = (ShadowUsageStatsManager.AppUsageObserver) o;
      return (this.observerId == that.getObserverId())
           && (this.packageNames.equals(that.getPackageNames()))
           && (this.timeLimit == that.getTimeLimit())
           && (this.timeUnit.equals(that.getTimeUnit()))
           && (this.callbackIntent.equals(that.getCallbackIntent()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= observerId;
    h$ *= 1000003;
    h$ ^= packageNames.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((timeLimit >>> 32) ^ timeLimit);
    h$ *= 1000003;
    h$ ^= timeUnit.hashCode();
    h$ *= 1000003;
    h$ ^= callbackIntent.hashCode();
    return h$;
  }

}
