/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.animation.RenderNodeAnimator;
import android.view.Choreographer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=RenderNodeAnimator.class, minSdk=30, isInAndroidSdk=false)
public class ShadowRenderNodeAnimatorR {
    private static final int STATE_FINISHED = 3;
    @RealObject
    RenderNodeAnimator realObject;
    private boolean scheduled = false;
    private long startTime = -1L;
    private boolean isEnding = false;
    private final Choreographer.FrameCallback frameCallback = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            ShadowRenderNodeAnimatorR.this.scheduled = false;
            if (ShadowRenderNodeAnimatorR.this.startTime == -1L) {
                ShadowRenderNodeAnimatorR.this.startTime = frameTimeNanos;
            }
            long duration = ShadowRenderNodeAnimatorR.this.realObject.getDuration();
            long curTime = frameTimeNanos - ShadowRenderNodeAnimatorR.this.startTime;
            if (curTime >= duration) {
                Shadow.directlyOn((Object)ShadowRenderNodeAnimatorR.this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            } else {
                ShadowRenderNodeAnimatorR.this.schedule();
            }
        }
    };

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(RenderNodeAnimator.class, (String)"sAnimationHelper", new ThreadLocal());
    }

    public void moveToRunningState() {
        Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"moveToRunningState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (!this.isEnding) {
            this.schedule();
        }
    }

    @Implementation
    public void doStart() {
        Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"doStart", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.schedule();
    }

    @Implementation
    public void cancel() {
        ((RenderNodeAnimator)Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class)).cancel();
        int state = (Integer)ReflectionHelpers.getField((Object)this.realObject, (String)"mState");
        if (state != 3) {
            Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    @Implementation
    public void end() {
        this.isEnding = true;
        ((RenderNodeAnimator)Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class)).end();
        this.isEnding = false;
        this.unschedule();
        int state = (Integer)ReflectionHelpers.getField((Object)this.realObject, (String)"mState");
        if (state != 3) {
            Shadow.directlyOn((Object)this.realObject, RenderNodeAnimator.class, (String)"onFinished", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    private void schedule() {
        if (!this.scheduled) {
            this.scheduled = true;
            Choreographer.getInstance().postFrameCallback(this.frameCallback);
        }
    }

    private void unschedule() {
        if (this.scheduled) {
            Choreographer.getInstance().removeFrameCallback(this.frameCallback);
            this.scheduled = false;
        }
    }
}

