/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.Phone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInCallAdapter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Phone.class, isInAndroidSdk=false)
public class ShadowPhone {
    @RealObject
    private Phone phone;
    private final List<Call> calls = new ArrayList<Call>();

    @Implementation(minSdk=23)
    protected final List<Call> getCalls() {
        return Collections.unmodifiableList(this.calls);
    }

    @Implementation(minSdk=23)
    protected final CallAudioState getCallAudioState() {
        InCallAdapter inCallAdapter = (InCallAdapter)ReflectionHelpers.getField((Object)this.phone, (String)"mInCallAdapter");
        int audioRoute = ((ShadowInCallAdapter)Shadow.extract((Object)inCallAdapter)).getAudioRoute();
        return new CallAudioState(false, audioRoute, 9);
    }

    public void addCall(Call call) {
        this.calls.add(call);
    }
}

