/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(className="libcore.io.OsConstants", maxSdk=20, isInAndroidSdk=false)
public final class ShadowLibcoreOsConstants {
    private static final Pattern ERRNO_PATTERN = Pattern.compile("E[A-Z0-9]+");

    @Implementation
    protected static void initConstants() {
        int errnos = 1;
        try {
            for (Field field : Class.forName("libcore.io.OsConstants").getDeclaredFields()) {
                if (ERRNO_PATTERN.matcher(field.getName()).matches() && field.getType() == Integer.TYPE) {
                    field.setInt(null, errnos++);
                }
                if (field.getName().equals("S_IFMT")) {
                    field.setInt(null, 0x170000);
                    continue;
                }
                if (field.getName().equals("S_IFDIR")) {
                    field.setInt(null, 262144);
                    continue;
                }
                if (field.getName().equals("S_IFREG")) {
                    field.setInt(null, 0x100000);
                    continue;
                }
                if (!field.getName().equals("S_IFLNK")) continue;
                field.setInt(null, 0x120000);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

