/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Debug;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Debug.class)
public class ShadowDebug {
    private static boolean tracingStarted = false;
    private static String tracingFilename;

    @Implementation
    protected static void __staticInitializer__() {
    }

    @Implementation
    protected static long getNativeHeapAllocatedSize() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Implementation(minSdk=23)
    protected static Map<String, String> getRuntimeStats() {
        return ImmutableMap.builder().build();
    }

    @Implementation
    protected static void startMethodTracing() {
        ShadowDebug.internalStartTracing(ShadowDebug.fixTracePath(null));
    }

    @Implementation
    protected static void startMethodTracing(String tracePath, int bufferSize, int flags) {
        ShadowDebug.internalStartTracing(ShadowDebug.fixTracePath(tracePath));
    }

    @Implementation
    protected static void startMethodTracing(String tracePath) {
        ShadowDebug.internalStartTracing(ShadowDebug.fixTracePath(tracePath));
    }

    @Implementation
    protected static void startMethodTracing(String tracePath, int bufferSize) {
        ShadowDebug.internalStartTracing(ShadowDebug.fixTracePath(tracePath));
    }

    @Implementation(minSdk=21)
    protected static void startMethodTracingSampling(String tracePath, int bufferSize, int intervalUs) {
        ShadowDebug.internalStartTracing(ShadowDebug.fixTracePath(tracePath));
    }

    @Implementation
    protected static void stopMethodTracing() {
        if (!tracingStarted) {
            throw new RuntimeException("Tracing is not started.");
        }
        try {
            Files.asCharSink((File)new File(tracingFilename), (Charset)Charset.forName("UTF-8"), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"trace data");
        }
        catch (IOException e) {
            throw new RuntimeException("Writing trace file failed", e);
        }
        tracingStarted = false;
        tracingFilename = null;
    }

    private static void internalStartTracing(String tracePath) {
        if (tracingStarted) {
            throw new RuntimeException("Tracing is already started.");
        }
        tracingStarted = true;
        tracingFilename = tracePath;
    }

    @Resetter
    public static void reset() {
        tracingStarted = false;
        tracingFilename = null;
    }

    private static String fixTracePath(String tracePath) {
        String defaultTraceBody = "dmtrace";
        String defaultTraceExtension = ".trace";
        if (tracePath == null || tracePath.charAt(0) != '/') {
            File dir = RuntimeEnvironment.application.getExternalFilesDir(null);
            tracePath = tracePath == null ? new File(dir, defaultTraceBody).getAbsolutePath() : new File(dir, tracePath).getAbsolutePath();
        }
        if (!tracePath.endsWith(defaultTraceExtension)) {
            String string2 = String.valueOf(tracePath);
            String string3 = String.valueOf(defaultTraceExtension);
            tracePath = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return tracePath;
    }
}

