/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import android.provider.Settings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowBluetoothLeScanner;
import org.robolectric.shadows.ShadowBluetoothServerSocket;

@Implements(value=BluetoothAdapter.class)
public class ShadowBluetoothAdapter {
    @RealObject
    private BluetoothAdapter realAdapter;
    private static final int ADDRESS_LENGTH = 17;
    private static boolean isBluetoothSupported = true;
    private static BluetoothLeScanner bluetoothLeScanner = null;
    private static BluetoothLeAdvertiser bluetoothLeAdvertiser = null;
    private Set<BluetoothDevice> bondedDevices = new HashSet<BluetoothDevice>();
    private Set<BluetoothAdapter.LeScanCallback> leScanCallbacks = new HashSet<BluetoothAdapter.LeScanCallback>();
    private boolean isDiscovering;
    private String address;
    private boolean enabled;
    private int state;
    private String name = "DefaultBluetoothDeviceName";
    private int scanMode = 20;
    private int discoverableTimeout = 0;
    private boolean isBleScanAlwaysAvailable = true;
    private boolean isMultipleAdvertisementSupported = true;
    private boolean isLeExtendedAdvertisingSupported = true;
    private boolean isOverridingProxyBehavior;
    private final Map<Integer, Integer> profileConnectionStateData = new HashMap<Integer, Integer>();
    private final Map<Integer, BluetoothProfile> profileProxies = new HashMap<Integer, BluetoothProfile>();

    @Resetter
    public static void reset() {
        ShadowBluetoothAdapter.setIsBluetoothSupported(true);
        bluetoothLeScanner = null;
        bluetoothLeAdvertiser = null;
    }

    @Implementation
    protected static BluetoothAdapter getDefaultAdapter() {
        return (BluetoothAdapter)(isBluetoothSupported ? ShadowApplication.getInstance().getBluetoothAdapter() : null);
    }

    public static void setIsBluetoothSupported(boolean supported) {
        isBluetoothSupported = supported;
    }

    @Implementation(minSdk=21)
    protected BluetoothLeScanner getBluetoothLeScanner() {
        if (Build.VERSION.SDK_INT >= 23 && !this.realAdapter.isLeEnabled()) {
            return null;
        }
        if (bluetoothLeScanner == null) {
            bluetoothLeScanner = ShadowBluetoothLeScanner.getInstance();
        }
        return bluetoothLeScanner;
    }

    @Implementation(minSdk=21)
    protected BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        return bluetoothLeAdvertiser;
    }

    public void setBluetoothLeAdvertiser(BluetoothLeAdvertiser advertiser) {
        bluetoothLeAdvertiser = advertiser;
    }

    @Implementation
    protected Set<BluetoothDevice> getBondedDevices() {
        return Collections.unmodifiableSet(this.bondedDevices);
    }

    public void setBondedDevices(Set<BluetoothDevice> bluetoothDevices) {
        this.bondedDevices = bluetoothDevices;
    }

    @Implementation
    protected BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String serviceName, UUID uuid) {
        return ShadowBluetoothServerSocket.newInstance(1, false, false, new ParcelUuid(uuid));
    }

    @Implementation
    protected BluetoothServerSocket listenUsingRfcommWithServiceRecord(String serviceName, UUID uuid) throws IOException {
        return ShadowBluetoothServerSocket.newInstance(1, false, true, new ParcelUuid(uuid));
    }

    @Implementation
    protected boolean startDiscovery() {
        this.isDiscovering = true;
        return true;
    }

    @Implementation
    protected boolean cancelDiscovery() {
        this.isDiscovering = false;
        return true;
    }

    @Implementation(minSdk=23)
    protected boolean isBleScanAlwaysAvailable() {
        return this.isBleScanAlwaysAvailable;
    }

    @Implementation(minSdk=23)
    public int getLeState() {
        if (ShadowBluetoothAdapter.isAirplaneMode()) {
            return 10;
        }
        if (this.isEnabled()) {
            return 12;
        }
        if (this.isBleScanAlwaysAvailable()) {
            return 15;
        }
        return 10;
    }

    private static boolean isAirplaneMode() {
        Application context = RuntimeEnvironment.application;
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(UUID[] serviceUuids, BluetoothAdapter.LeScanCallback callback) {
        if (Build.VERSION.SDK_INT >= 23 && !this.realAdapter.isLeEnabled()) {
            return false;
        }
        this.leScanCallbacks.add(callback);
        return true;
    }

    @Implementation(minSdk=18)
    protected void stopLeScan(BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.remove(callback);
    }

    public Set<BluetoothAdapter.LeScanCallback> getLeScanCallbacks() {
        return Collections.unmodifiableSet(this.leScanCallbacks);
    }

    public BluetoothAdapter.LeScanCallback getSingleLeScanCallback() {
        if (this.leScanCallbacks.size() != 1) {
            int n = this.leScanCallbacks.size();
            throw new IllegalStateException(new StringBuilder(31).append("There are ").append(n).append(" callbacks").toString());
        }
        return this.leScanCallbacks.iterator().next();
    }

    @Implementation
    protected boolean isDiscovering() {
        return this.isDiscovering;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    protected boolean enable() {
        this.enabled = true;
        return true;
    }

    @Implementation
    protected boolean disable() {
        this.enabled = false;
        return true;
    }

    @Implementation
    protected String getAddress() {
        return this.address;
    }

    @Implementation
    protected int getState() {
        return this.state;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    @Implementation
    protected boolean setName(String name) {
        this.name = name;
        return true;
    }

    @Implementation
    protected boolean setScanMode(int scanMode) {
        if (scanMode != 21 && scanMode != 23 && scanMode != 20) {
            return false;
        }
        this.scanMode = scanMode;
        return true;
    }

    @Implementation(maxSdk=29)
    protected boolean setScanMode(int scanMode, int discoverableTimeout) {
        this.setDiscoverableTimeout(discoverableTimeout);
        return this.setScanMode(scanMode);
    }

    @Implementation
    protected int getScanMode() {
        return this.scanMode;
    }

    @Implementation
    protected int getDiscoverableTimeout() {
        return this.discoverableTimeout;
    }

    @Implementation
    protected void setDiscoverableTimeout(int timeout) {
        this.discoverableTimeout = timeout;
    }

    @Implementation(minSdk=21)
    protected boolean isMultipleAdvertisementSupported() {
        return this.isMultipleAdvertisementSupported;
    }

    @Implementation
    protected static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Implementation
    protected int getProfileConnectionState(int profile) {
        Integer state = this.profileConnectionStateData.get(profile);
        if (state == null) {
            return 0;
        }
        return state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBleScanAlwaysAvailable(boolean alwaysAvailable) {
        this.isBleScanAlwaysAvailable = alwaysAvailable;
    }

    public void setIsMultipleAdvertisementSupported(boolean supported) {
        this.isMultipleAdvertisementSupported = supported;
    }

    public void setProfileConnectionState(int profile, int state) {
        this.profileConnectionStateData.put(profile, state);
    }

    public void setProfileProxy(int profile, @Nullable BluetoothProfile proxy) {
        this.isOverridingProxyBehavior = true;
        if (proxy != null) {
            this.profileProxies.put(profile, proxy);
        }
    }

    public boolean hasActiveProfileProxy(int profile) {
        return this.profileProxies.get(profile) != null;
    }

    @Implementation
    protected boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (!this.isOverridingProxyBehavior) {
            return ((BluetoothAdapter)Shadow.directlyOn((Object)this.realAdapter, BluetoothAdapter.class)).getProfileProxy(context, listener, profile);
        }
        BluetoothProfile proxy = this.profileProxies.get(profile);
        if (proxy == null) {
            return false;
        }
        listener.onServiceConnected(profile, proxy);
        return true;
    }

    @Implementation
    protected void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (!this.isOverridingProxyBehavior) {
            ((BluetoothAdapter)Shadow.directlyOn((Object)this.realAdapter, BluetoothAdapter.class)).closeProfileProxy(profile, proxy);
            return;
        }
        if (proxy != null && proxy.equals(this.profileProxies.get(profile))) {
            this.profileProxies.remove(profile);
        }
    }

    @Implementation(minSdk=26)
    protected boolean isLeExtendedAdvertisingSupported() {
        return this.isLeExtendedAdvertisingSupported;
    }

    public void setIsLeExtendedAdvertisingSupported(boolean supported) {
        this.isLeExtendedAdvertisingSupported = supported;
    }
}

