/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Dialog;
import android.app.Instrumentation;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ActivityController;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboMenuItem;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivityManager;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowContextThemeWrapper;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowWindow;
import org.robolectric.shadows._Activity_;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(value=Activity.class)
public class ShadowActivity
extends ShadowContextThemeWrapper {
    @RealObject
    protected Activity realActivity;
    private int resultCode;
    private Intent resultIntent;
    private Activity parent;
    private int requestedOrientation = -1;
    private View currentFocus;
    private Integer lastShownDialogId = null;
    private int pendingTransitionEnterAnimResId = -1;
    private int pendingTransitionExitAnimResId = -1;
    private Object lastNonConfigurationInstance;
    private Map<Integer, Dialog> dialogForId = new HashMap<Integer, Dialog>();
    private ArrayList<Cursor> managedCursors = new ArrayList();
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    private int streamType = -1;
    private boolean mIsTaskRoot = true;
    private Menu optionsMenu;
    private ComponentName callingActivity;
    private String callingPackage;
    private PermissionsRequest lastRequestedPermission;
    private ActivityController controller;
    private boolean inMultiWindowMode = false;
    private IntentSenderRequest lastIntentSenderRequest;
    private boolean throwIntentSenderException;
    private boolean hasReportedFullyDrawn = false;
    private boolean isInPictureInPictureMode = false;

    public void setApplication(Application application) {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setApplication(application);
    }

    public void callAttach(Intent intent) {
        this.callAttach(intent, null);
    }

    public void callAttach(Intent intent, @Nullable @WithType(value="android.app.Activity$NonConfigurationInstances") Object lastNonConfigurationInstances) {
        ActivityInfo activityInfo;
        Application application = RuntimeEnvironment.application;
        Context baseContext = application.getBaseContext();
        ComponentName componentName = new ComponentName(application.getPackageName(), this.realActivity.getClass().getName());
        PackageManager packageManager = application.getPackageManager();
        this.shadowOf(packageManager).addActivityIfNotPresent(componentName);
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Activity is not resolved even if we made sure it exists", e);
        }
        CharSequence activityTitle = activityInfo.loadLabel(baseContext.getPackageManager());
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        Instrumentation instrumentation = activityThread.getInstrumentation();
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).callAttach(baseContext, activityThread, instrumentation, application, intent, activityInfo, activityTitle, lastNonConfigurationInstances);
        int theme = activityInfo.getThemeResource();
        if (theme != 0) {
            this.realActivity.setTheme(theme);
        }
    }

    public void setCallingActivity(ComponentName activityName) {
        this.callingActivity = activityName;
    }

    @Implementation
    protected ComponentName getCallingActivity() {
        return this.callingActivity;
    }

    public void setCallingPackage(String packageName) {
        this.callingPackage = packageName;
    }

    @Implementation
    protected String getCallingPackage() {
        return this.callingPackage;
    }

    @Implementation
    protected void setDefaultKeyMode(int keyMode) {
        this.mDefaultKeyMode = keyMode;
        switch (this.mDefaultKeyMode) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection((Spannable)this.mDefaultKeySsb, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getDefaultKeymode() {
        return this.mDefaultKeyMode;
    }

    @Implementation
    protected final void setResult(int resultCode) {
        this.resultCode = resultCode;
    }

    @Implementation
    protected final void setResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.resultIntent = data;
    }

    @Implementation
    protected LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.realActivity);
    }

    @Implementation
    protected MenuInflater getMenuInflater() {
        return new MenuInflater((Context)this.realActivity);
    }

    @Implementation
    protected View findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    @Implementation
    protected final Activity getParent() {
        return this.parent;
    }

    @HiddenApi
    @Implementation
    public void setParent(Activity parent) {
        this.parent = parent;
    }

    @Implementation
    protected void onBackPressed() {
        this.finish();
    }

    @Implementation
    protected void finish() {
        ReflectionHelpers.setField(Activity.class, (Object)this.realActivity, (String)"mFinished", (Object)true);
    }

    @Implementation(minSdk=21)
    protected void finishAndRemoveTask() {
        ReflectionHelpers.setField(Activity.class, (Object)this.realActivity, (String)"mFinished", (Object)true);
    }

    @Implementation(minSdk=16)
    protected void finishAffinity() {
        ReflectionHelpers.setField(Activity.class, (Object)this.realActivity, (String)"mFinished", (Object)true);
    }

    public void resetIsFinishing() {
        ReflectionHelpers.setField(Activity.class, (Object)this.realActivity, (String)"mFinished", (Object)false);
    }

    @Deprecated
    public boolean isFinishing() {
        return ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).isFinishing();
    }

    @Implementation
    protected Window getWindow() {
        Window window = ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).getWindow();
        if (window == null) {
            try {
                window = ShadowWindow.create((Context)this.realActivity);
                this.setWindow(window);
            }
            catch (Exception e) {
                throw new RuntimeException("Window creation failed!", e);
            }
        }
        return window;
    }

    public void setWindow(Window window) {
        ((_Activity_)Reflector.reflector(_Activity_.class, (Object)this.realActivity)).setWindow(window);
    }

    @Implementation
    protected void runOnUiThread(Runnable action) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            Shadow.directlyOn((Object)this.realActivity, Activity.class, (String)"runOnUiThread", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Runnable.class, (Object)action)});
        } else {
            ShadowApplication.getInstance().getForegroundThreadScheduler().post(action);
        }
    }

    @Implementation
    protected void setRequestedOrientation(int requestedOrientation) {
        if (this.getParent() != null) {
            this.getParent().setRequestedOrientation(requestedOrientation);
        } else {
            this.requestedOrientation = requestedOrientation;
        }
    }

    @Implementation
    protected int getRequestedOrientation() {
        if (this.getParent() != null) {
            return this.getParent().getRequestedOrientation();
        }
        return this.requestedOrientation;
    }

    @Implementation
    protected int getTaskId() {
        return 0;
    }

    @Implementation
    public void startIntentSenderForResult(IntentSender intentSender, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        if (this.throwIntentSenderException) {
            throw new IntentSender.SendIntentException("PendingIntent was canceled");
        }
        this.lastIntentSenderRequest = new IntentSenderRequest(intentSender, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Implementation(minSdk=19)
    protected void reportFullyDrawn() {
        this.hasReportedFullyDrawn = true;
    }

    public boolean getReportFullyDrawn() {
        return this.hasReportedFullyDrawn;
    }

    public View getContentView() {
        return ((ViewGroup)this.getWindow().findViewById(0x1020002)).getChildAt(0);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Intent getResultIntent() {
        return this.resultIntent;
    }

    @Override
    public IntentForResult getNextStartedActivityForResult() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        return shadowInstrumentation.getNextStartedActivityForResult();
    }

    @Override
    public IntentForResult peekNextStartedActivityForResult() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        return shadowInstrumentation.peekNextStartedActivityForResult();
    }

    @Implementation
    protected Object getLastNonConfigurationInstance() {
        if (this.lastNonConfigurationInstance != null) {
            return this.lastNonConfigurationInstance;
        }
        return ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).getLastNonConfigurationInstance();
    }

    @Deprecated
    public void setLastNonConfigurationInstance(Object lastNonConfigurationInstance) {
        this.lastNonConfigurationInstance = lastNonConfigurationInstance;
    }

    public void setCurrentFocus(View view) {
        this.currentFocus = view;
    }

    @Implementation
    protected View getCurrentFocus() {
        return this.currentFocus;
    }

    public int getPendingTransitionEnterAnimationResourceId() {
        return this.pendingTransitionEnterAnimResId;
    }

    public int getPendingTransitionExitAnimationResourceId() {
        return this.pendingTransitionExitAnimResId;
    }

    @Implementation
    protected boolean onCreateOptionsMenu(Menu menu) {
        this.optionsMenu = menu;
        return ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).onCreateOptionsMenu(menu);
    }

    public Menu getOptionsMenu() {
        return this.optionsMenu;
    }

    public boolean clickMenuItem(int menuItemResId) {
        RoboMenuItem item = new RoboMenuItem(menuItemResId);
        return this.realActivity.onMenuItemSelected(0, (MenuItem)item);
    }

    @Deprecated
    public void callOnActivityResult(int requestCode, int resultCode, Intent resultData) {
        ActivityInvoker invoker = new ActivityInvoker();
        invoker.call("onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class).with(requestCode, resultCode, resultData);
    }

    public void internalCallDispatchActivityResult(String who, int requestCode, int resultCode, Intent data) {
        ActivityInvoker invoker = new ActivityInvoker();
        if (Build.VERSION.SDK_INT >= 28) {
            invoker.call("dispatchActivityResult", String.class, Integer.TYPE, Integer.TYPE, Intent.class, String.class).with(who, requestCode, resultCode, data, "ACTIVITY_RESULT");
        } else {
            invoker.call("dispatchActivityResult", String.class, Integer.TYPE, Integer.TYPE, Intent.class).with(who, requestCode, resultCode, data);
        }
    }

    public <T extends Activity> void attachController(ActivityController controller) {
        this.controller = controller;
    }

    public void setThrowIntentSenderException(boolean throwIntentSenderException) {
        this.throwIntentSenderException = throwIntentSenderException;
    }

    public void receiveResult(Intent requestIntent, int resultCode, Intent resultIntent) {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        ShadowInstrumentation.TargetAndRequestCode targetAndRequestCode = shadowInstrumentation.getTargetAndRequestCodeForIntent(requestIntent);
        this.internalCallDispatchActivityResult(targetAndRequestCode.target, targetAndRequestCode.requestCode, resultCode, resultIntent);
    }

    @Implementation
    protected final void showDialog(int id2) {
        this.showDialog(id2, null);
    }

    @Implementation
    protected final void dismissDialog(int id2) {
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        dialog.dismiss();
    }

    @Implementation
    protected final void removeDialog(int id2) {
        this.dialogForId.remove(id2);
    }

    @Implementation
    protected final boolean showDialog(int id2, Bundle bundle) {
        this.lastShownDialogId = id2;
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            ActivityInvoker invoker = new ActivityInvoker();
            dialog = (Dialog)invoker.call("onCreateDialog", Integer.TYPE).with(id2);
            if (dialog == null) {
                return false;
            }
            if (bundle == null) {
                invoker.call("onPrepareDialog", Integer.TYPE, Dialog.class).with(id2, dialog);
            } else {
                invoker.call("onPrepareDialog", Integer.TYPE, Dialog.class, Bundle.class).with(id2, dialog, bundle);
            }
            this.dialogForId.put(id2, dialog);
        }
        dialog.show();
        return true;
    }

    public void setIsTaskRoot(boolean isRoot) {
        this.mIsTaskRoot = isRoot;
    }

    @Implementation
    protected final boolean isTaskRoot() {
        return this.mIsTaskRoot;
    }

    public Integer getLastShownDialogId() {
        return this.lastShownDialogId;
    }

    public boolean hasCancelledPendingTransitions() {
        return this.pendingTransitionEnterAnimResId == 0 && this.pendingTransitionExitAnimResId == 0;
    }

    @Implementation
    protected void overridePendingTransition(int enterAnim, int exitAnim) {
        this.pendingTransitionEnterAnimResId = enterAnim;
        this.pendingTransitionExitAnimResId = exitAnim;
    }

    public Dialog getDialogById(int dialogId) {
        return this.dialogForId.get(dialogId);
    }

    @Implementation
    protected void recreate() {
        if (this.controller == null) {
            throw new IllegalStateException("Cannot use an Activity that is not managed by an ActivityController");
        }
        this.controller.recreate();
    }

    @Implementation
    protected void startManagingCursor(Cursor c) {
        this.managedCursors.add(c);
    }

    @Implementation
    protected void stopManagingCursor(Cursor c) {
        this.managedCursors.remove(c);
    }

    public List<Cursor> getManagedCursors() {
        return this.managedCursors;
    }

    @Implementation
    protected final void setVolumeControlStream(int streamType) {
        this.streamType = streamType;
    }

    @Implementation
    protected final int getVolumeControlStream() {
        return this.streamType;
    }

    @Implementation(minSdk=23)
    protected final void requestPermissions(String[] permissions, int requestCode) {
        this.lastRequestedPermission = new PermissionsRequest(permissions, requestCode);
        ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).requestPermissions(permissions, requestCode);
    }

    @Implementation(minSdk=21)
    protected void startLockTask() {
        ((ShadowActivityManager)Shadow.extract((Object)this.getActivityManager())).setLockTaskModeState(1);
    }

    @Implementation(minSdk=21)
    protected void stopLockTask() {
        ((ShadowActivityManager)Shadow.extract((Object)this.getActivityManager())).setLockTaskModeState(0);
    }

    @Deprecated
    public boolean isLockTask() {
        return this.getActivityManager().isInLockTaskMode();
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.realActivity.getSystemService("activity");
    }

    public void setInMultiWindowMode(boolean value) {
        this.inMultiWindowMode = value;
    }

    @Implementation(minSdk=24)
    protected boolean isInMultiWindowMode() {
        return this.inMultiWindowMode;
    }

    @Implementation(minSdk=24)
    protected boolean isInPictureInPictureMode() {
        return this.isInPictureInPictureMode;
    }

    @Implementation(minSdk=24)
    protected void enterPictureInPictureMode() {
        this.isInPictureInPictureMode = true;
    }

    @Implementation(minSdk=26)
    protected boolean enterPictureInPictureMode(PictureInPictureParams params) {
        this.isInPictureInPictureMode = true;
        return true;
    }

    @Implementation
    protected boolean moveTaskToBack(boolean nonRoot) {
        this.isInPictureInPictureMode = false;
        return true;
    }

    public IntentSenderRequest getLastIntentSenderRequest() {
        return this.lastIntentSenderRequest;
    }

    public PermissionsRequest getLastRequestedPermission() {
        return this.lastRequestedPermission;
    }

    private ShadowPackageManager shadowOf(PackageManager packageManager) {
        return (ShadowPackageManager)Shadow.extract((Object)packageManager);
    }

    public static class IntentSenderRequest {
        public final IntentSender intentSender;
        public final int requestCode;
        @Nullable
        public final Intent fillInIntent;
        public final int flagsMask;
        public final int flagsValues;
        public final int extraFlags;
        public final Bundle options;

        public IntentSenderRequest(IntentSender intentSender, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) {
            this.intentSender = intentSender;
            this.requestCode = requestCode;
            this.fillInIntent = fillInIntent;
            this.flagsMask = flagsMask;
            this.flagsValues = flagsValues;
            this.extraFlags = extraFlags;
            this.options = options;
        }
    }

    public static class PermissionsRequest {
        public final int requestCode;
        public final String[] requestedPermissions;

        public PermissionsRequest(String[] requestedPermissions, int requestCode) {
            this.requestedPermissions = requestedPermissions;
            this.requestCode = requestCode;
        }
    }

    private final class ActivityInvoker {
        private Method method;

        private ActivityInvoker() {
        }

        public ActivityInvoker call(String methodName, Class ... argumentClasses) {
            try {
                this.method = Activity.class.getDeclaredMethod(methodName, argumentClasses);
                this.method.setAccessible(true);
                return this;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public Object withNothing() {
            return this.with(new Object[0]);
        }

        public Object with(Object ... parameters) {
            try {
                return this.method.invoke((Object)ShadowActivity.this.realActivity, parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class IntentForResult {
        public Intent intent;
        public int requestCode;
        public Bundle options;

        public IntentForResult(Intent intent, int requestCode) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = null;
        }

        public IntentForResult(Intent intent, int requestCode, Bundle options) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = options;
        }

        public String toString() {
            String string2 = super.toString();
            String string3 = String.valueOf(this.intent);
            int n = this.requestCode;
            String string4 = String.valueOf(this.options);
            return new StringBuilder(44 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("{intent=").append(string3).append(", requestCode=").append(n).append(", options=").append(string4).append('}').toString();
        }
    }
}

