/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    private static boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getImageSizeFromStream(InputStream is) {
        if (!initialized) {
            ImageIO.setUseCache(false);
            initialized = true;
        }
        ImageInputStream imageStream = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        try {
            reader.setInput(imageStream);
            Point point = new Point(reader.getWidth(0), reader.getHeight(0));
            reader.dispose();
            return point;
        }
        catch (Throwable throwable) {
            try {
                reader.dispose();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean writeToStream(Bitmap realBitmap, Bitmap.CompressFormat format, int quality, OutputStream stream) {
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("Quality out of bounds!");
        }
        try {
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(ImageUtil.getFormatName(format));
            if (iter.hasNext()) {
                writer = iter.next();
            }
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(stream);){
                writer.setOutput(ios);
                JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality((float)quality / 100.0f);
                writer.write(null, new IIOImage(new BufferedImage(realBitmap.getWidth(), realBitmap.getHeight(), 12), null, null), iwparam);
                ios.flush();
                writer.dispose();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static String getFormatName(Bitmap.CompressFormat compressFormat) {
        switch (compressFormat) {
            case JPEG: 
            case WEBP: 
            case WEBP_LOSSY: 
            case WEBP_LOSSLESS: {
                return "jpg";
            }
            case PNG: {
                return "png";
            }
        }
        String string2 = String.valueOf(compressFormat);
        throw new UnsupportedOperationException(new StringBuilder(23 + String.valueOf(string2).length()).append("Cannot convert format: ").append(string2).toString());
    }
}

