/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.ShadowContextThemeWrapper;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.shadows._Activity_;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

public class ActivityController<T extends Activity>
extends ComponentController<ActivityController<T>, T> {
    private _Activity_ _component_;

    public static <T extends Activity> ActivityController<T> of(T activity, Intent intent) {
        return super.attach(null);
    }

    public static <T extends Activity> ActivityController<T> of(T activity) {
        return super.attach(null);
    }

    private ActivityController(T activity, Intent intent) {
        super(activity, intent);
        this._component_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)this.component);
    }

    private ActivityController<T> attach(@Nullable @WithType(value="android.app.Activity$NonConfigurationInstances") Object lastNonConfigurationInstances) {
        if (this.attached) {
            return this;
        }
        Context context = RuntimeEnvironment.application.getBaseContext();
        PackageManager packageManager = context.getPackageManager();
        ComponentName componentName = new ComponentName(context.getPackageName(), ((Activity)this.component).getClass().getName());
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).addActivityIfNotPresent(componentName);
        packageManager.setComponentEnabledSetting(componentName, 1, 0);
        ShadowActivity shadowActivity = (ShadowActivity)Shadow.extract((Object)this.component);
        shadowActivity.callAttach(this.getIntent(), lastNonConfigurationInstances);
        shadowActivity.attachController(this);
        this.attached = true;
        return this;
    }

    private ActivityInfo getActivityInfo(Application application) {
        PackageManager packageManager = application.getPackageManager();
        ComponentName componentName = new ComponentName(application.getPackageName(), ((Activity)this.component).getClass().getName());
        try {
            return packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ActivityController<T> create(@Nullable Bundle bundle) {
        this.shadowMainLooper.runPaused(() -> ActivityController.getInstrumentation().callActivityOnCreate((Activity)this.component, bundle));
        return this;
    }

    @Override
    public ActivityController<T> create() {
        return this.create(null);
    }

    public ActivityController<T> restart() {
        if (RuntimeEnvironment.getApiLevel() <= 27) {
            this.invokeWhilePaused("performRestart", new ReflectionHelpers.ClassParameter[0]);
        } else {
            this.invokeWhilePaused("performRestart", ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(String.class, (Object)"restart()"));
        }
        return this;
    }

    public ActivityController<T> start() {
        if (RuntimeEnvironment.getApiLevel() <= 27) {
            this.invokeWhilePaused("performStart", new ReflectionHelpers.ClassParameter[0]);
        } else {
            this.invokeWhilePaused("performStart", ReflectionHelpers.ClassParameter.from(String.class, (Object)"start()"));
        }
        return this;
    }

    public ActivityController<T> restoreInstanceState(Bundle bundle) {
        this.shadowMainLooper.runPaused(() -> ActivityController.getInstrumentation().callActivityOnRestoreInstanceState((Activity)this.component, bundle));
        return this;
    }

    public ActivityController<T> postCreate(@Nullable Bundle bundle) {
        this.invokeWhilePaused("onPostCreate", ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle));
        return this;
    }

    public ActivityController<T> resume() {
        if (RuntimeEnvironment.getApiLevel() <= 27) {
            this.invokeWhilePaused("performResume", new ReflectionHelpers.ClassParameter[0]);
        } else {
            this.invokeWhilePaused("performResume", ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(String.class, (Object)"resume()"));
        }
        return this;
    }

    public ActivityController<T> postResume() {
        this.invokeWhilePaused("onPostResume", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public ActivityController<T> visible() {
        this.shadowMainLooper.runPaused(() -> {
            ((Activity)this.component).getWindow().getAttributes().type = 1;
            this._component_.setDecor(((Activity)this.component).getWindow().getDecorView());
            ReflectionHelpers.callInstanceMethod((Object)this.component, (String)"makeVisible", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        });
        this.shadowMainLooper.idleIfPaused();
        ViewRootImpl root = this.getViewRoot();
        if (root != null) {
            this.callDispatchResized(root);
            this.shadowMainLooper.idleIfPaused();
        }
        return this;
    }

    private ViewRootImpl getViewRoot() {
        return ((Activity)this.component).getWindow().getDecorView().getViewRootImpl();
    }

    private void callDispatchResized(ViewRootImpl root) {
        ((ShadowViewRootImpl)Shadow.extract((Object)root)).callDispatchResized();
    }

    public ActivityController<T> windowFocusChanged(boolean hasFocus) {
        ViewRootImpl root = this.getViewRoot();
        if (root == null) {
            this.shadowMainLooper.idle();
            root = (ViewRootImpl)Preconditions.checkNotNull((Object)this.getViewRoot());
            this.callDispatchResized(root);
        }
        ReflectionHelpers.callInstanceMethod((Object)root, (String)"windowFocusChanged", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)hasFocus), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    public ActivityController<T> userLeaving() {
        this.shadowMainLooper.runPaused(() -> ActivityController.getInstrumentation().callActivityOnUserLeaving((Activity)this.component));
        return this;
    }

    public ActivityController<T> pause() {
        this.shadowMainLooper.runPaused(() -> ActivityController.getInstrumentation().callActivityOnPause((Activity)this.component));
        return this;
    }

    public ActivityController<T> saveInstanceState(Bundle outState) {
        this.shadowMainLooper.runPaused(() -> ActivityController.getInstrumentation().callActivityOnSaveInstanceState((Activity)this.component, outState));
        return this;
    }

    public ActivityController<T> stop() {
        if (RuntimeEnvironment.getApiLevel() <= 23) {
            this.invokeWhilePaused("performStop", new ReflectionHelpers.ClassParameter[0]);
        } else if (RuntimeEnvironment.getApiLevel() <= 27) {
            this.invokeWhilePaused("performStop", ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true));
        } else {
            this.invokeWhilePaused("performStop", ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true), ReflectionHelpers.ClassParameter.from(String.class, (Object)"stop()"));
        }
        return this;
    }

    @Override
    public ActivityController<T> destroy() {
        this.shadowMainLooper.runPaused(() -> {
            ActivityController.getInstrumentation().callActivityOnDestroy((Activity)this.component);
            boolean windowAdded = (Boolean)ReflectionHelpers.getField((Object)this.component, (String)"mWindowAdded");
            if (windowAdded) {
                WindowManager windowManager = ((Activity)this.component).getWindowManager();
                windowManager.removeViewImmediate(((Activity)this.component).getWindow().getDecorView());
            }
        });
        return this;
    }

    public ActivityController<T> setup() {
        return ((ActivityController)this.create()).start().postCreate(null).resume().visible();
    }

    public ActivityController<T> setup(@Nullable Bundle savedInstanceState) {
        return this.create(savedInstanceState).start().restoreInstanceState(savedInstanceState).postCreate(savedInstanceState).resume().visible();
    }

    public ActivityController<T> newIntent(Intent intent) {
        this.invokeWhilePaused("onNewIntent", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent));
        return this;
    }

    public ActivityController<T> configurationChange() {
        return this.configurationChange(((Activity)this.component).getApplicationContext().getResources().getConfiguration());
    }

    public ActivityController<T> configurationChange(Configuration newConfiguration) {
        Configuration currentConfig = ((Activity)this.component).getResources().getConfiguration();
        final int changedBits = currentConfig.diff(newConfiguration);
        currentConfig.setTo(newConfiguration);
        if ((this.getActivityInfo((Application)((Activity)this.component).getApplication()).configChanges & changedBits) == changedBits) {
            this.shadowMainLooper.runPaused(() -> ((Activity)this.component).onConfigurationChanged(newConfiguration));
            return this;
        }
        final Activity recreatedActivity = (Activity)ReflectionHelpers.callConstructor(((Activity)this.component).getClass(), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        final _Activity_ _recreatedActivity_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)recreatedActivity);
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ReflectionHelpers.setField(Activity.class, (Object)ActivityController.this.component, (String)"mChangingConfigurations", (Object)true);
                ReflectionHelpers.setField(Activity.class, (Object)ActivityController.this.component, (String)"mConfigChangeFlags", (Object)changedBits);
                Bundle outState = new Bundle();
                ActivityController.this._component_.performPause();
                ActivityController.this._component_.performSaveInstanceState(outState);
                if (RuntimeEnvironment.getApiLevel() <= 23) {
                    ActivityController.this._component_.performStop();
                } else if (RuntimeEnvironment.getApiLevel() <= 27) {
                    ActivityController.this._component_.performStop(true);
                } else {
                    ActivityController.this._component_.performStop(true, "configurationChange");
                }
                Object nonConfigInstance = ActivityController.this._component_.retainNonConfigurationInstances();
                Object activityConfigInstance = nonConfigInstance == null ? null : ((_NonConfigurationInstances_)Reflector.reflector(_NonConfigurationInstances_.class, (Object)nonConfigInstance)).getActivity();
                ActivityController.this._component_.performDestroy();
                ShadowContextThemeWrapper shadowContextThemeWrapper = (ShadowContextThemeWrapper)Shadow.extract((Object)ActivityController.this.component);
                int theme = shadowContextThemeWrapper.callGetThemeResId();
                ActivityController.this.attached = false;
                ActivityController.this.component = recreatedActivity;
                ActivityController.this._component_ = _recreatedActivity_;
                ActivityController.this.attach(null);
                if (theme != 0) {
                    recreatedActivity.setTheme(theme);
                }
                _recreatedActivity_.setLastNonConfigurationInstances(nonConfigInstance);
                ShadowActivity shadowActivity = (ShadowActivity)Shadow.extract((Object)recreatedActivity);
                shadowActivity.setLastNonConfigurationInstance(activityConfigInstance);
                _recreatedActivity_.performCreate(outState);
                if (RuntimeEnvironment.getApiLevel() <= 27) {
                    _recreatedActivity_.performStart();
                } else {
                    _recreatedActivity_.performStart("configurationChange");
                }
                _recreatedActivity_.performRestoreInstanceState(outState);
                _recreatedActivity_.onPostCreate(outState);
                if (RuntimeEnvironment.getApiLevel() <= 27) {
                    _recreatedActivity_.performResume();
                } else {
                    _recreatedActivity_.performResume(true, "configurationChange");
                }
                _recreatedActivity_.onPostResume();
            }
        });
        return this;
    }

    public ActivityController<T> recreate() {
        Stage originalStage = ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf((Activity)this.component);
        switch (originalStage) {
            case PRE_ON_CREATE: {
                this.create();
            }
            case CREATED: 
            case RESTARTED: {
                this.start();
                this.postCreate(null);
            }
            case STARTED: {
                this.resume();
            }
            case RESUMED: {
                this.pause();
            }
            case PAUSED: {
                this.stop();
            }
            case STOPPED: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot recreate activity since it's destroyed already");
            }
        }
        ReflectionHelpers.setField((Object)this.component, (String)"mChangingConfigurations", (Object)true);
        Bundle outState = new Bundle();
        this.saveInstanceState(outState);
        Object lastNonConfigurationInstances = ReflectionHelpers.callInstanceMethod((Object)this.component, (String)"retainNonConfigurationInstances", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.destroy();
        this.component = (Activity)ReflectionHelpers.callConstructor(((Activity)this.component).getClass(), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this._component_ = (_Activity_)Reflector.reflector(_Activity_.class, (Object)this.component);
        this.attached = false;
        this.attach(lastNonConfigurationInstances);
        this.create(outState);
        this.start();
        this.restoreInstanceState(outState);
        this.postCreate(outState);
        this.resume();
        this.postResume();
        this.visible();
        this.windowFocusChanged(true);
        switch (originalStage) {
            case PAUSED: {
                this.pause();
                return this;
            }
            case STOPPED: {
                this.pause();
                this.stop();
                return this;
            }
        }
        return this;
    }

    private static Instrumentation getInstrumentation() {
        return ((ActivityThread)RuntimeEnvironment.getActivityThread()).getInstrumentation();
    }

    @ForType(className="android.app.Activity$NonConfigurationInstances")
    static interface _NonConfigurationInstances_ {
        @Accessor(value="activity")
        public Object getActivity();
    }
}

