/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppAssetManager2;
import org.robolectric.res.android.Registries;
import org.robolectric.shadows.ShadowArscAssetManager10;

@Implements(className="android.graphics.fonts.Font.Builder", minSdk=29, isInAndroidSdk=false)
public class ShadowFontBuilder {
    @Implementation
    protected static long nGetNativeAsset(AssetManager assetMgr, String path, boolean isAsset, int cookie) {
        Preconditions.checkNotNull((Object)assetMgr);
        Preconditions.checkNotNull((Object)path);
        CppAssetManager2 mgr = ShadowArscAssetManager10.AssetManagerForJavaObject(assetMgr);
        if (mgr == null) {
            return 0L;
        }
        Asset asset = isAsset ? mgr.Open(path, Asset.AccessMode.ACCESS_BUFFER) : (cookie > 0 ? mgr.OpenNonAsset(path, ApkAssetsCookie.forInt((int)(cookie - 1)), Asset.AccessMode.ACCESS_BUFFER) : mgr.OpenNonAsset(path, Asset.AccessMode.ACCESS_BUFFER));
        return Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
    }

    @Implementation
    protected static ByteBuffer nGetAssetBuffer(long nativeAsset) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(nativeAsset);
        return ByteBuffer.wrap(asset.getBuffer(false));
    }

    @Implementation
    protected static long nGetReleaseNativeAssetFunc() {
        return 0L;
    }
}

