/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowColorMatrixColorFilter;
import org.robolectric.shadows.ShadowMatrix;
import org.robolectric.shadows.ShadowPath;
import org.robolectric.util.Join;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Canvas.class)
public class ShadowCanvas {
    private final List<RoundRectPaintHistoryEvent> roundRectPaintEvents = new ArrayList<RoundRectPaintHistoryEvent>();
    private List<PathPaintHistoryEvent> pathPaintEvents = new ArrayList<PathPaintHistoryEvent>();
    private List<CirclePaintHistoryEvent> circlePaintEvents = new ArrayList<CirclePaintHistoryEvent>();
    private List<ArcPaintHistoryEvent> arcPaintEvents = new ArrayList<ArcPaintHistoryEvent>();
    private List<RectPaintHistoryEvent> rectPaintEvents = new ArrayList<RectPaintHistoryEvent>();
    private List<LinePaintHistoryEvent> linePaintEvents = new ArrayList<LinePaintHistoryEvent>();
    private List<OvalPaintHistoryEvent> ovalPaintEvents = new ArrayList<OvalPaintHistoryEvent>();
    private List<TextHistoryEvent> drawnTextEventHistory = new ArrayList<TextHistoryEvent>();
    private Paint drawnPaint;
    private Bitmap targetBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    private float translateX;
    private float translateY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int height;
    private int width;

    public static String visualize(Canvas canvas) {
        ShadowCanvas shadowCanvas = (ShadowCanvas)Shadow.extract((Object)canvas);
        return shadowCanvas.getDescription();
    }

    @Implementation
    protected void __constructor__(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    public void appendDescription(String s) {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        shadowBitmap.appendDescription(s);
    }

    public String getDescription() {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        return shadowBitmap.getDescription();
    }

    @Implementation
    protected void setBitmap(Bitmap bitmap) {
        this.targetBitmap = bitmap;
    }

    @Implementation
    protected void drawText(String text, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text));
    }

    @Implementation
    protected void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text.subSequence(start, end).toString()));
    }

    @Implementation
    protected void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, new String(text, index, count)));
    }

    @Implementation
    protected void drawText(String text, int start, int end, float x, float y, Paint paint) {
        this.drawnTextEventHistory.add(new TextHistoryEvent(x, y, paint, text.substring(start, end)));
    }

    @Implementation
    protected void translate(float x, float y) {
        this.translateX = x;
        this.translateY = y;
    }

    @Implementation
    protected void scale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    protected void scale(float sx, float sy, float px, float py) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    @Implementation
    protected void drawPaint(Paint paint) {
        this.drawnPaint = paint;
    }

    @Implementation
    protected void drawColor(int color) {
        this.appendDescription(new StringBuilder(22).append("draw color ").append(color).toString());
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.describeBitmap(bitmap, paint);
        int x = (int)(left + this.translateX);
        int y = (int)(top + this.translateY);
        if (x != 0 || y != 0) {
            this.appendDescription(new StringBuilder(29).append(" at (").append(x).append(",").append(y).append(")").toString());
        }
        if (this.scaleX != 1.0f && this.scaleY != 1.0f) {
            float f = this.scaleX;
            float f2 = this.scaleY;
            this.appendDescription(new StringBuilder(44).append(" scaled by (").append(f).append(",").append(f2).append(")").toString());
        }
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        this.describeBitmap(bitmap, paint);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (dst != null) {
            descriptionBuilder.append(" at (").append(dst.left).append(",").append(dst.top).append(") with height=").append(dst.height()).append(" and width=").append(dst.width());
        }
        if (src != null) {
            descriptionBuilder.append(" taken from ").append(src.toString());
        }
        this.appendDescription(descriptionBuilder.toString());
    }

    @Implementation
    protected void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        this.describeBitmap(bitmap, paint);
        ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        String string = String.valueOf(shadowMatrix.getDescription());
        this.appendDescription(string.length() != 0 ? " transformed by ".concat(string) : new String(" transformed by "));
    }

    @Implementation
    protected void drawPath(Path path, Paint paint) {
        this.pathPaintEvents.add(new PathPaintHistoryEvent(new Path(path), new Paint(paint)));
        this.separateLines();
        ShadowPath shadowPath = (ShadowPath)Shadow.extract((Object)path);
        String string = String.valueOf(shadowPath.getPoints().toString());
        this.appendDescription(string.length() != 0 ? "Path ".concat(string) : new String("Path "));
    }

    @Implementation
    protected void drawCircle(float cx, float cy, float radius, Paint paint) {
        this.circlePaintEvents.add(new CirclePaintHistoryEvent(cx, cy, radius, paint));
    }

    @Implementation
    protected void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.arcPaintEvents.add(new ArcPaintHistoryEvent(oval, startAngle, sweepAngle, useCenter, paint));
    }

    @Implementation
    protected void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.rectPaintEvents.add(new RectPaintHistoryEvent(left, top, right, bottom, paint));
    }

    @Implementation
    protected void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.roundRectPaintEvents.add(new RoundRectPaintHistoryEvent(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint));
    }

    @Implementation
    protected void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.linePaintEvents.add(new LinePaintHistoryEvent(startX, startY, stopX, stopY, paint));
    }

    @Implementation
    protected void drawOval(RectF oval, Paint paint) {
        this.ovalPaintEvents.add(new OvalPaintHistoryEvent(oval, paint));
    }

    @Implementation
    protected int save() {
        return 1;
    }

    @Implementation
    protected void restore() {
    }

    private void describeBitmap(Bitmap bitmap, Paint paint) {
        ColorFilter colorFilter;
        this.separateLines();
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        this.appendDescription(shadowBitmap.getDescription());
        if (paint != null && (colorFilter = paint.getColorFilter()) != null) {
            if (colorFilter instanceof ColorMatrixColorFilter) {
                ColorMatrixColorFilter colorMatrixColorFilter = (ColorMatrixColorFilter)colorFilter;
                ShadowColorMatrixColorFilter shadowColorMatrixColorFilter = (ShadowColorMatrixColorFilter)Shadow.extract((Object)colorMatrixColorFilter);
                ColorMatrix colorMatrix = shadowColorMatrixColorFilter.getMatrix();
                String string = this.formatColorMatric(colorMatrix);
                this.appendDescription(new StringBuilder(30 + String.valueOf(string).length()).append(" with ColorMatrixColorFilter<").append(string).append(">").toString());
            } else {
                String string = String.valueOf(colorFilter);
                this.appendDescription(new StringBuilder(6 + String.valueOf(string).length()).append(" with ").append(string).toString());
            }
        }
    }

    private String formatColorMatric(ColorMatrix colorMatrix) {
        ArrayList<String> floats = new ArrayList<String>();
        for (float f : colorMatrix.getArray()) {
            String format = String.format("%.2f", Float.valueOf(f));
            format = format.replace(".00", "");
            floats.add(format);
        }
        return Join.join((String)",", floats);
    }

    private void separateLines() {
        if (this.getDescription().length() != 0) {
            this.appendDescription("\n");
        }
    }

    public int getPathPaintHistoryCount() {
        return this.pathPaintEvents.size();
    }

    public int getCirclePaintHistoryCount() {
        return this.circlePaintEvents.size();
    }

    public int getArcPaintHistoryCount() {
        return this.arcPaintEvents.size();
    }

    public boolean hasDrawnPath() {
        return this.getPathPaintHistoryCount() > 0;
    }

    public boolean hasDrawnCircle() {
        return this.circlePaintEvents.size() > 0;
    }

    public Paint getDrawnPathPaint(int i) {
        return this.pathPaintEvents.get(i).pathPaint;
    }

    public Path getDrawnPath(int i) {
        return this.pathPaintEvents.get(i).drawnPath;
    }

    public CirclePaintHistoryEvent getDrawnCircle(int i) {
        return this.circlePaintEvents.get(i);
    }

    public ArcPaintHistoryEvent getDrawnArc(int i) {
        return this.arcPaintEvents.get(i);
    }

    public void resetCanvasHistory() {
        this.drawnTextEventHistory.clear();
        this.pathPaintEvents.clear();
        this.circlePaintEvents.clear();
        this.rectPaintEvents.clear();
        this.roundRectPaintEvents.clear();
        this.linePaintEvents.clear();
        this.ovalPaintEvents.clear();
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.targetBitmap);
        shadowBitmap.setDescription("");
    }

    public Paint getDrawnPaint() {
        return this.drawnPaint;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    protected int getWidth() {
        return this.width;
    }

    @Implementation
    protected int getHeight() {
        return this.height;
    }

    public TextHistoryEvent getDrawnTextEvent(int i) {
        return this.drawnTextEventHistory.get(i);
    }

    public int getTextHistoryCount() {
        return this.drawnTextEventHistory.size();
    }

    public RectPaintHistoryEvent getDrawnRect(int i) {
        return this.rectPaintEvents.get(i);
    }

    public RectPaintHistoryEvent getLastDrawnRect() {
        return this.rectPaintEvents.get(this.rectPaintEvents.size() - 1);
    }

    public int getRectPaintHistoryCount() {
        return this.rectPaintEvents.size();
    }

    public RoundRectPaintHistoryEvent getDrawnRoundRect(int i) {
        return this.roundRectPaintEvents.get(i);
    }

    public RoundRectPaintHistoryEvent getLastDrawnRoundRect() {
        return this.roundRectPaintEvents.get(this.roundRectPaintEvents.size() - 1);
    }

    public int getRoundRectPaintHistoryCount() {
        return this.roundRectPaintEvents.size();
    }

    public LinePaintHistoryEvent getDrawnLine(int i) {
        return this.linePaintEvents.get(i);
    }

    public int getLinePaintHistoryCount() {
        return this.linePaintEvents.size();
    }

    public int getOvalPaintHistoryCount() {
        return this.ovalPaintEvents.size();
    }

    public OvalPaintHistoryEvent getDrawnOval(int i) {
        return this.ovalPaintEvents.get(i);
    }

    public static class TextHistoryEvent {
        public final float x;
        public final float y;
        public final Paint paint;
        public final String text;

        private TextHistoryEvent(float x, float y, Paint paint, String text) {
            this.x = x;
            this.y = y;
            this.paint = paint;
            this.text = text;
        }
    }

    public static class ArcPaintHistoryEvent {
        public final RectF oval;
        public final float startAngle;
        public final float sweepAngle;
        public final boolean useCenter;
        public final Paint paint;

        public ArcPaintHistoryEvent(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
            this.oval = oval;
            this.startAngle = startAngle;
            this.sweepAngle = sweepAngle;
            this.useCenter = useCenter;
            this.paint = paint;
        }
    }

    public static class CirclePaintHistoryEvent {
        public final float centerX;
        public final float centerY;
        public final float radius;
        public final Paint paint;

        private CirclePaintHistoryEvent(float centerX, float centerY, float radius, Paint paint) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
            this.paint = paint;
        }
    }

    private static class PathPaintHistoryEvent {
        private final Path drawnPath;
        private final Paint pathPaint;

        PathPaintHistoryEvent(Path drawnPath, Paint pathPaint) {
            this.drawnPath = drawnPath;
            this.pathPaint = pathPaint;
        }
    }

    public static class RoundRectPaintHistoryEvent {
        public final Paint paint;
        public final RectF rect;
        public final float left;
        public final float top;
        public final float right;
        public final float bottom;
        public final float rx;
        public final float ry;

        private RoundRectPaintHistoryEvent(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
            this.rect = new RectF(left, top, right, bottom);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.paint.setTextSize(paint.getTextSize());
            this.paint.setStyle(paint.getStyle());
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.rx = rx;
            this.ry = ry;
        }
    }

    public static class RectPaintHistoryEvent {
        public final Paint paint;
        public final RectF rect;
        public final float left;
        public final float top;
        public final float right;
        public final float bottom;

        private RectPaintHistoryEvent(float left, float top, float right, float bottom, Paint paint) {
            this.rect = new RectF(left, top, right, bottom);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.paint.setTextSize(paint.getTextSize());
            this.paint.setStyle(paint.getStyle());
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    public static class OvalPaintHistoryEvent {
        public final RectF oval;
        public final Paint paint;

        private OvalPaintHistoryEvent(RectF oval, Paint paint) {
            this.oval = new RectF(oval);
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
        }
    }

    public static class LinePaintHistoryEvent {
        public Paint paint;
        public float startX;
        public float startY;
        public float stopX;
        public float stopY;

        private LinePaintHistoryEvent(float startX, float startY, float stopX, float stopY, Paint paint) {
            this.paint = new Paint(paint);
            this.paint.setColor(paint.getColor());
            this.paint.setStrokeWidth(paint.getStrokeWidth());
            this.startX = startX;
            this.startY = startY;
            this.stopX = stopX;
            this.stopY = stopY;
        }
    }
}

